/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.apiimpl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseResponse;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.CspUserDto;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.DataSyncRequest;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.Role;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.RoleResourceRelation;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.TenantUserRelation;
import com.dtyunxi.tcbj.app.open.biz.csp.service.DataSyncService;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.tcbj.center.openapi.api.IDataSyncExtApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.user.CreOrUpdRoleDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.user.CreOrUpdUserDto;
import com.dtyunxi.util.Base64;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.IUserLoginConfigApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrgRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserOrgExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.OrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataSyncExtApiImpl
implements IDataSyncExtApi {
    private static final Logger log = LoggerFactory.getLogger(DataSyncExtApiImpl.class);
    @Resource
    private IOrgRoleApi orgRoleApi;
    @Resource
    private IUserApi userApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private DataSyncService dataSyncService;
    @Autowired
    private IUserExtQueryApi userExtQueryApi;
    @Autowired
    private ISecurityApi securityApi;
    @Autowired
    private IUserLoginConfigApi userLoginConfigApi;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IUserOrgExpandApi userOrgExpandApi;
    private final String mappingCacheKey = "data:mapping:org";

    public RestResponse<String> creOrUpdRole(CreOrUpdRoleDto dto) {
        try {
            DataSyncRequest syncRequest = new DataSyncRequest();
            BaseResponse<List<Role>> rolesResponse = this.dataSyncService.syncRoles(this.getSeq(), syncRequest);
            if (rolesResponse.getCode() != 200 || rolesResponse.getData() == null) {
                return new RestResponse((Object)("\u89d2\u8272\u6570\u636e\u540c\u6b65\u5931\u8d25: " + rolesResponse.getMsg()));
            }
            BaseResponse<List<RoleResourceRelation>> syncRoleResources = this.dataSyncService.syncRoleResources(this.getSeq(), syncRequest);
            List<RoleResourceRelation> syncRoleResourcesData = syncRoleResources.getData();
            Map<String, List<RoleResourceRelation>> listMap = syncRoleResourcesData.stream().collect(Collectors.groupingBy(RoleResourceRelation::getRoleId));
            for (Role cspRole : rolesResponse.getData()) {
                OrgRoleReqDto orgRoleReqDto = new OrgRoleReqDto();
                orgRoleReqDto.setName(cspRole.getRoleName());
                orgRoleReqDto.setCode(cspRole.getRoleCode());
                orgRoleReqDto.setDescription(cspRole.getRoleDescription());
                orgRoleReqDto.setStatus(Integer.valueOf(cspRole.getEnableStatus() == 1 ? 1 : 0));
                orgRoleReqDto.setRoleType(Integer.valueOf(1));
                Optional.ofNullable(listMap.get(cspRole.getCspRoleId())).ifPresent(r -> orgRoleReqDto.setAccessCodes(r.stream().map(RoleResourceRelation::getRsId).distinct().collect(Collectors.toList())));
                RestResponseHelper.checkOrThrow((RestResponse)this.orgRoleApi.createOrUpdate(orgRoleReqDto));
            }
            return new RestResponse((Object)"\u89d2\u8272\u540c\u6b65\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u89d2\u8272\u540c\u6b65\u5931\u8d25", (Throwable)e);
            return new RestResponse((Object)("\u89d2\u8272\u540c\u6b65\u5931\u8d25: " + e.getMessage()));
        }
    }

    public RestResponse<String> creOrUpdUser(CreOrUpdUserDto dto) {
        try {
            DataSyncRequest syncRequest = new DataSyncRequest();
            syncRequest.setSyncDate(dto.getLastSyncTime());
            String seq = this.getSeq();
            BaseResponse<List<CspUserDto>> usersResponse = this.dataSyncService.syncUsers(seq, syncRequest);
            if (usersResponse.getCode() != 200 || usersResponse.getData() == null) {
                return new RestResponse((Object)("\u7528\u6237\u6570\u636e\u540c\u6b65\u5931\u8d25: " + usersResponse.getMsg()));
            }
            BaseResponse<List<TenantUserRelation>> syncUserTenants = this.dataSyncService.syncUserTenants(seq, syncRequest);
            List<TenantUserRelation> userTenantsData = syncUserTenants.getData();
            Map<String, List<TenantUserRelation>> tenantUserMap = userTenantsData.stream().collect(Collectors.groupingBy(TenantUserRelation::getUserId));
            UserQueryReqDto userQueryReqDto = new UserQueryReqDto();
            userQueryReqDto.setUserNames(new ArrayList(usersResponse.getData().stream().map(CspUserDto::getUsername).collect(Collectors.toSet())));
            List userRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userQueryReqDto));
            Map respDtoMap = userRespDtos.stream().collect(Collectors.toMap(UserRespDto::getUserName, Function.identity()));
            for (CspUserDto cspUserDto : usersResponse.getData()) {
                Long userId;
                UserRespDto existingUser = (UserRespDto)respDtoMap.get(cspUserDto.getUsername());
                if (existingUser == null) {
                    userId = this.addUserInfo(cspUserDto);
                } else {
                    userId = existingUser.getId();
                    UserDto userDto = new UserDto();
                    userDto.setUserName(cspUserDto.getUsername());
                    userDto.setAccount(cspUserDto.getEmployeeNumber());
                    userDto.setPhone(cspUserDto.getMobile());
                    userDto.setEmail(cspUserDto.getEmail());
                    userDto.setStatus(Integer.valueOf(cspUserDto.getEnableStatus() == 1 ? 1 : 0));
                    userDto.setUserType(Integer.getInteger(cspUserDto.getUserType()));
                    this.userApi.update(existingUser.getId(), userDto);
                    if (Objects.equals(cspUserDto.getEnableStatus(), 0)) {
                        this.tokenApi.deleteToken(userDto.getId() + "");
                    }
                    RestUtil.checkResponse(this.userApi.update(userDto.getId(), userDto));
                }
                List<TenantUserRelation> tenantUserRelations = tenantUserMap.get(cspUserDto.getUserId());
                UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
                userOrgRelationReqDto.setUserId(userId);
                ArrayList orgList = Lists.newArrayList();
                for (TenantUserRelation tenantUserRelation : tenantUserRelations) {
                    orgList.add(this.getOrgId(tenantUserRelation.getTenantId()));
                }
                userOrgRelationReqDto.setOrgIds((List)orgList);
                this.userOrgExpandApi.addOrUpdateUserOrgInfo(userOrgRelationReqDto);
            }
            return new RestResponse((Object)"\u7528\u6237\u540c\u6b65\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u540c\u6b65\u5931\u8d25", (Throwable)e);
            return new RestResponse((Object)("\u7528\u6237\u540c\u6b65\u5931\u8d25: " + e.getMessage()));
        }
    }

    private Long addUserInfo(CspUserDto cspUserDto) {
        UserDto userDto = new UserDto();
        userDto.setUserName(cspUserDto.getUsername());
        userDto.setExtension(cspUserDto.getUserId());
        userDto.setNickName(cspUserDto.getEmployeeNumber());
        userDto.setPhone(cspUserDto.getMobile());
        userDto.setEmail(cspUserDto.getEmail());
        userDto.setValidType(Integer.valueOf(1));
        userDto.setTenantId(CommonConstant.TENANT_ID);
        userDto.setInstanceId(CommonConstant.INSTANCE_ID);
        userDto.setPassword(Base64.encodeString((String)"ZJJK123456").replace("==", ""));
        userDto.setUserType(Integer.valueOf(1));
        userDto.setStatus(cspUserDto.getEnableStatus());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
        log.info("\u65b0\u589e\u7528\u6237\u8bf7\u6c42={}", (Object)JSONObject.toJSONString((Object)userDto));
        RestResponse userRestResponse = this.userApi.addUser(CommonConstant.INSTANCE_ID, userDto);
        log.info("\u65b0\u589e\u7528\u6237\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)userRestResponse));
        Long userId = (Long)userRestResponse.getData();
        this.securityApi.resetPasswordByAdmin(userId, userDto.getPassword());
        UserLoginConfigReqDto userLoginConfigReqDto = new UserLoginConfigReqDto();
        userLoginConfigReqDto.setLoginConfig("1,2");
        userLoginConfigReqDto.setUserId(userId);
        this.userLoginConfigApi.putUserLoginConfig(userId, userLoginConfigReqDto);
        this.cacheMaintain(userDto, userId);
        return userId;
    }

    public Long getOrgId(String code) {
        Long cache = (Long)this.cacheService.getCache("data:mapping:org", code, Long.class);
        if (Objects.nonNull(cache)) {
            return cache;
        }
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, code);
        log.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (organizationDtoRestResponse.getData() != null) {
            this.cacheService.setCache("data:mapping:org", code, (Object)((OrganizationDto)organizationDtoRestResponse.getData()).getId());
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
        }
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(code);
        RestResponse response = this.customerQueryApi.queryByThirdPartyIds(list1);
        log.info("\u5c0fB\u8d26\u6237\u5bf9\u5e94\u7684\u5ba2\u6237: {}", (Object)JSONObject.toJSONString((Object)response));
        if (!CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            this.cacheService.setCache("data:mapping:org", code, (Object)((CustomerRespDto)((List)response.getData()).get(0)).getOrgInfoId());
            return ((CustomerRespDto)((List)response.getData()).get(0)).getOrgInfoId();
        }
        return null;
    }

    private void cacheMaintain(UserDto userDto, Long id) {
        if (userDto.getUserType().equals(11)) {
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", id + "", (Object)1, 0);
        } else {
            this.cacheService.hdel("COMMON", "USER_ADMIN_KEY", new String[]{id + ""});
        }
    }

    private String getSeq() {
        return RequestId.createReqId();
    }
}

