/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.csp;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.csp.ApiClient;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseRequest;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestApiClient
implements ApiClient {
    private static final Logger log = LoggerFactory.getLogger(RestApiClient.class);
    private final RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).errorHandler((ResponseErrorHandler)new CustomErrorHandler()).build();
    @Value(value="${portal.api.base-url}")
    private String baseUrl;

    @Override
    public <T, R> BaseResponse<R> post(String endpoint, BaseRequest<T> request, Class<R> dataType) {
        String url = this.baseUrl + endpoint;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(request, (MultiValueMap)headers);
        try {
            ParameterizedTypeReference typeRef = new ParameterizedTypeReference<BaseResponse<R>>(){};
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, typeRef, new Object[0]);
            return (BaseResponse)response.getBody();
        }
        catch (RestClientException e) {
            log.error("API communication error for endpoint: {}", (Object)endpoint, (Object)e);
            throw new BizException("API request failed: " + e.getMessage());
        }
    }

    @Override
    public <T, E> BaseResponse<List<E>> postForList(String endpoint, BaseRequest<T> request) {
        String url = this.baseUrl + endpoint;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(request, (MultiValueMap)headers);
        try {
            ParameterizedTypeReference typeRef = new ParameterizedTypeReference<BaseResponse<List<E>>>(){};
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, typeRef, new Object[0]);
            return (BaseResponse)response.getBody();
        }
        catch (RestClientException e) {
            log.error("API communication error for endpoint: {}", (Object)endpoint, (Object)e);
            throw new BizException("API request failed: " + e.getMessage());
        }
    }

    private static class CustomErrorHandler
    extends DefaultResponseErrorHandler {
        private CustomErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            if (response.getStatusCode().is5xxServerError()) {
                throw new ApiException("Server error: " + response.getStatusCode());
            }
            super.handleError(response);
        }
    }
}

