/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.EmployeeEventVo;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.util.Base64;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.IUserLoginConfigApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.v3.ITokenApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserOrgExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@MQDesc(tag="tcbj-employee-event-queue")
public class EmployeeStatusProcessor
implements IMessageProcessor<Object> {
    private static final Logger log = LoggerFactory.getLogger(EmployeeStatusProcessor.class);
    @Value(value="${employee.update.syncEmployeeStatus:false}")
    private boolean syncEmployeeStatus;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private IUserApi userApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private ISecurityApi securityApi;
    @Autowired
    private IUserLoginConfigApi userLoginConfigApi;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IUserOrgExpandApi userOrgExpandApi;

    public MessageResponse process(Object message) {
        log.info("\u63a5\u6536\u5230\u5458\u5de5\u72b6\u6001\u53d8\u66f4\u7684MQ\u6570\u636e:{}", message);
        if (!this.syncEmployeeStatus) {
            log.info("\u63a5\u6536\u5230\u5458\u5de5\u72b6\u6001\u53d8\u66f4\u7684MQ\u6570\u636e\u5f00\u5173\u72b6\u6001\u5173\u95ed");
            return MessageResponse.SUCCESS;
        }
        this.handler(message);
        return MessageResponse.SUCCESS;
    }

    public void handler(Object message) {
        EmployeeEventVo employeeEventVo = (EmployeeEventVo)JSONObject.parseObject((String)String.valueOf(message), EmployeeEventVo.class);
        UserDto userDto = (UserDto)this.userQueryApi.queryByLoginStr(employeeEventVo.getLoginName(), CommonConstant.INSTANCE_ID, "").getData();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
        if (userDto == null) {
            CompletableFuture.runAsync(() -> {
                log.info("\u5f02\u6b65\u65b0\u589e\u7528\u6237\u4fe1\u606f");
                ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
                try {
                    this.addUserInfo(employeeEventVo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u540c\u6b65\u65b0\u589e\u7528\u6237\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
                }
            });
            return;
        }
        try {
            if (Objects.equals(employeeEventVo.getState(), 0)) {
                this.tokenApi.deleteToken(userDto.getId() + "");
            }
            userDto.setStatus(employeeEventVo.getState());
            RestUtil.checkResponse(this.userApi.update(userDto.getId(), userDto));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u7528\u6237\u72b6\u6001\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private void addUserInfo(EmployeeEventVo employeeEventVo) {
        UserDto userDto = new UserDto();
        userDto.setUserName(employeeEventVo.getLoginName());
        userDto.setExtension(employeeEventVo.getUserId());
        userDto.setNickName(employeeEventVo.getUserName());
        userDto.setPhone(employeeEventVo.getMobilePhone());
        userDto.setEmail(employeeEventVo.getEmail());
        userDto.setValidType(Integer.valueOf(1));
        userDto.setTenantId(CommonConstant.TENANT_ID);
        userDto.setInstanceId(CommonConstant.INSTANCE_ID);
        userDto.setPassword(Base64.encodeString((String)"ZJJK123456").replace("==", ""));
        userDto.setUserType(Integer.valueOf(1));
        userDto.setStatus(employeeEventVo.getState());
        userDto.setValidStartDate(employeeEventVo.getStartDate());
        userDto.setValidEndDate(employeeEventVo.getEndDate());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
        log.info("\u65b0\u589e\u7528\u6237\u8bf7\u6c42={}", (Object)JSONObject.toJSONString((Object)userDto));
        RestResponse userRestResponse = this.userApi.addUser(CommonConstant.INSTANCE_ID, userDto);
        log.info("\u65b0\u589e\u7528\u6237\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)userRestResponse));
        Long userId = (Long)userRestResponse.getData();
        this.securityApi.resetPasswordByAdmin(userId, userDto.getPassword());
        String tenantId = employeeEventVo.getTenantId();
        Long orgId = this.getOrgId(tenantId);
        if (Objects.nonNull(orgId)) {
            UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
            userOrgRelationReqDto.setUserId(userId);
            userOrgRelationReqDto.setOrgIds((List)Lists.newArrayList((Object[])new Long[]{orgId}));
            this.userOrgExpandApi.addOrUpdateUserOrgInfo(userOrgRelationReqDto);
        }
        UserLoginConfigReqDto userLoginConfigReqDto = new UserLoginConfigReqDto();
        userLoginConfigReqDto.setLoginConfig("1,2");
        userLoginConfigReqDto.setUserId(userId);
        this.userLoginConfigApi.putUserLoginConfig(userId, userLoginConfigReqDto);
        this.cacheMaintain(userDto, userId);
    }

    public Long getOrgId(String code) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, code);
        log.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (organizationDtoRestResponse.getData() != null) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
        }
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(code);
        RestResponse response = this.customerQueryApi.queryByThirdPartyIds(list1);
        log.info("\u5c0fB\u8d26\u6237\u5bf9\u5e94\u7684\u5ba2\u6237: {}", (Object)JSONObject.toJSONString((Object)response));
        if (!CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            return ((CustomerRespDto)((List)response.getData()).get(0)).getOrgInfoId();
        }
        return null;
    }

    private void cacheMaintain(UserDto userDto, Long id) {
        if (userDto.getUserType().equals(11)) {
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", id + "", (Object)1, 0);
        } else {
            this.cacheService.hdel("COMMON", "USER_ADMIN_KEY", new String[]{id + ""});
        }
    }
}

