/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.apiimpl.ErpPriceApiImpl;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerMaterialRelEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ZsjQueryPriceService;
import com.dtyunxi.tcbj.app.open.biz.utils.HttpUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.MdmRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.request.MdmBasePriceReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.mdm.request.MdmReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.BasePriceApplyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ZsjQueryPriceServiceImpl
implements ZsjQueryPriceService {
    private static final Logger logger = LoggerFactory.getLogger(ZsjQueryPriceServiceImpl.class);
    @Resource
    private HttpUtil httpUtil;
    @Resource
    private ErpPriceApiImpl erpPriceApi;
    @Resource
    private IItemExtQueryApi itemExtQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    @Resource
    private ZsjQueryPriceService zsjQueryPriceService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${querySuggestedPriceUrl:https://zsjjk.by-health.com/api/mdm/getModelDatas}")
    private String querySuggestedPriceUrl;

    @Override
    public BigDecimal querySuggestedPrice(String skuCode, String thirdPartyId) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("modelCode", "PROD_ORG_REL");
        jsonMap.put("queryCondition", "EASNO=" + skuCode + ";ORGID=" + thirdPartyId);
        jsonMap.put("queryField", "PRICE");
        jsonMap.put("dataType", "json");
        jsonMap.put("isVague", "no");
        jsonMap.put("userName", "xbsc");
        jsonMap.put("password", "80ddaa767f36cac0e946c11b6ea12e85");
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSON.toJSONString(jsonMap), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.querySuggestedPriceUrl, (Object)formEntity, String.class, new Object[0]);
        MdmReqDto returnValueDto = (MdmReqDto)JSONObject.parseObject((String)((String)response.getBody()), MdmReqDto.class);
        logger.info("\u4e3b\u6570\u636e\u67e5\u8be2\u4ef7\u683c\u7ed3\u679c param={}; result:{}", jsonMap, (Object)returnValueDto);
        if (returnValueDto.getLIST() == null || returnValueDto.getLIST().isEmpty()) {
            logger.info("\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c \u8df3\u8fc7");
            return null;
        }
        if (returnValueDto.getLIST().size() != 1) {
            logger.info("\u4e3b\u6570\u636e\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c\u4e0d\u552f\u4e00 \u8df3\u8fc7");
            return null;
        }
        JSONObject returnObj = (JSONObject)returnValueDto.getLIST().get(0);
        JSONObject PROD_ORG_REL = (JSONObject)returnObj.get((Object)"PROD_ORG_REL");
        if (PROD_ORG_REL == null) {
            logger.info("\u4e3b\u6570\u636e\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38 \u8df3\u8fc7");
            return null;
        }
        return new BigDecimal(PROD_ORG_REL.get((Object)"PRICE").toString());
    }

    @Override
    public MdmRespDto syncPullSuggestedPrice(List<Map<String, String>> dataList, List<String> itemCodes, Map<String, CustomerRespDto> customerRespMap) {
        logger.info("syncPullSuggestedPrice start. dataList={}; itemCodes={}; customerRespMap={}; ", new Object[]{JSONObject.toJSONString(dataList), JSONObject.toJSONString(itemCodes), JSONObject.toJSONString(customerRespMap)});
        if (dataList == null || dataList.isEmpty()) {
            logger.info("\u5904\u7406\u6570\u636e\u4e3anull \u8df3\u8fc71");
            return null;
        }
        if (itemCodes == null || itemCodes.isEmpty()) {
            logger.info("\u5904\u7406\u6570\u636e\u4e3anull \u8df3\u8fc72");
            return null;
        }
        if (customerRespMap == null || customerRespMap.isEmpty()) {
            logger.info("\u5904\u7406\u6570\u636e\u4e3anull \u8df3\u8fc73");
            return null;
        }
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApi.queryByItemLongCodes(itemCodes));
        Map<String, ItemRespDto> itemRespDtoMap = itemRespDtoList.stream().collect(Collectors.toMap(ItemRespDto::getLongCode, e -> e));
        List orgIdsParam = itemRespDtoList.stream().map(ItemRespDto::getOrganizationId).distinct().collect(Collectors.toList());
        List ppfCusDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerByOrgId(orgIdsParam));
        if (ppfCusDtos == null || ppfCusDtos.isEmpty()) {
            logger.info("\u5904\u7406\u6570\u636e\u4e3anull \u8df3\u8fc74");
            return null;
        }
        Map<Long, CustomerRespDto> ppfCusDtoMap = ppfCusDtos.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, e -> e));
        Map<String, CustomerRespDto> itemSkuCodePpfCusMap = itemRespDtoList.stream().collect(Collectors.toMap(ItemRespDto::getLongCode, e -> (CustomerRespDto)ppfCusDtoMap.get(e.getOrganizationId())));
        ArrayList<BasePriceApplyReqDto> pullDate = new ArrayList<BasePriceApplyReqDto>();
        dataList.forEach(map -> {
            String PARTNER_ID = (String)map.get(CustomerMaterialRelEnum.PARTNER_ID.name());
            String PRODUCT_ID_EASNO = (String)map.get(CustomerMaterialRelEnum.PRODUCT_ID_EASNO.name());
            ItemRespDto itemRespDto = (ItemRespDto)itemRespDtoMap.get(PRODUCT_ID_EASNO);
            logger.info("syncPullSuggestedPrice start. PARTNER_ID={}, PRODUCT_ID_EASNO={}", (Object)PARTNER_ID, (Object)PRODUCT_ID_EASNO);
            BasePriceItemRespDto basePriceApplyItem = this.queryBasePriceItem(itemRespDto);
            if (basePriceApplyItem != null) {
                logger.info("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7 \u4ef7\u683c\u5df2\u5b58\u5728 \u8df3\u8fc7 basePriceApplyItem={}", (Object)JSONObject.toJSONString((Object)basePriceApplyItem));
                return;
            }
            logger.info("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7 \u4ef7\u683c\u4e0d\u5b58\u5728 \u4ece\u4e3b\u6570\u636e\u540c\u6b65");
            CustomerRespDto itemSkuCodePpfCus = (CustomerRespDto)itemSkuCodePpfCusMap.get(PRODUCT_ID_EASNO);
            if (itemSkuCodePpfCus == null || itemSkuCodePpfCus.getId() == null) {
                logger.info("\u5904\u7406\u6570\u636e\u4e3anull \u8df3\u8fc75");
                return;
            }
            BigDecimal price = this.zsjQueryPriceService.querySuggestedPrice(PRODUCT_ID_EASNO, itemSkuCodePpfCus.getThirdPartyId());
            if (price == null) {
                logger.info("\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c \u8df3\u8fc7");
                return;
            }
            BasePriceApplyReqDto basePriceApplyReqDto = BasePriceApplyReqDto.builder().PRICE(price).SKUCODE(PRODUCT_ID_EASNO).THIRDORGID(itemSkuCodePpfCus.getThirdPartyId()).build();
            logger.info("\u4e3b\u6570\u636e\u5b58\u5728\u5efa\u8bae\u96f6\u552e\u4ef7\u4ef7\u683c add to list. basePriceApplyReqDto={}", (Object)JSONObject.toJSONString((Object)basePriceApplyReqDto));
            pullDate.add(basePriceApplyReqDto);
        });
        if (!pullDate.isEmpty()) {
            MdmReqDto<MdmBasePriceReqDto> paramData = this.zsjQueryPriceService.getAddPriceParam(pullDate);
            logger.info("\u5199\u5165\u4ece\u4e3b\u6570\u636e\u540c\u6b65\u7684\u5efa\u8bae\u96f6\u552e\u4ef7 paramData={}", (Object)JSONObject.toJSONString(paramData));
            return this.erpPriceApi.addBasePriceApplyAndAudit(paramData);
        }
        logger.info("\u9700\u8981\u4ece\u4e3b\u6570\u636e\u540c\u6b65\u7684\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a \u4e0d\u5904\u7406");
        logger.info("syncPullSuggestedPrice end.");
        return null;
    }

    private BasePriceItemRespDto queryBasePriceItem(ItemRespDto itemDto) {
        BasePriceItemQueryReqDto reqDto = new BasePriceItemQueryReqDto();
        reqDto.setSkuCode(itemDto.getLongCode());
        reqDto.setItemOrgId(itemDto.getOrganizationId());
        reqDto.setTypeId(Long.valueOf(1L));
        List basePriceApplyItemList = (List)RestUtil.checkResponse(this.basePriceItemQueryApi.queryByList(reqDto));
        logger.info("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7\u67e5\u8be2\u7ed3\u679c \u67e5\u8be2\u53c2\u6570param={}; \u67e5\u8be2\u7ed3\u679cresult={}", (Object)JSONObject.toJSONString((Object)reqDto), (Object)JSONObject.toJSONString((Object)basePriceApplyItemList));
        if (basePriceApplyItemList == null || basePriceApplyItemList.isEmpty()) {
            return null;
        }
        if (basePriceApplyItemList.size() != 1) {
            throw new BizException("\u5c0fb\u5efa\u8bae\u96f6\u552e\u4ef7\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38 \u4ef7\u683c\u6570\u636e\u6761\u6570\u4e3a:" + basePriceApplyItemList.size());
        }
        return (BasePriceItemRespDto)basePriceApplyItemList.get(0);
    }

    @Override
    public MdmReqDto<MdmBasePriceReqDto> getAddPriceParam(List<BasePriceApplyReqDto> pullDate) {
        MdmReqDto param = new MdmReqDto();
        ArrayList list = new ArrayList();
        pullDate.forEach(e -> list.add(MdmBasePriceReqDto.builder().PROD_ORG_REL(BasePriceApplyReqDto.builder().channel(Integer.valueOf(2)).PRICE(e.getPRICE()).PRICETYPE(Long.valueOf(1L)).SKUCODE(e.getSKUCODE()).THIRDORGID(e.getTHIRDORGID()).build()).CIDP_TASK_UUID(UUID.randomUUID().toString().replace("-", "")).build()));
        param.setLIST(list);
        return param;
    }
}

