/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.service.IBarcodeService;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.barcode.BarcodeReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.barcode.BarcodeResultDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.BarcodeUrlEnum;
import com.dtyunxi.util.JacksonUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BarcodeServiceImpl
implements IBarcodeService {
    private static final Logger logger = LoggerFactory.getLogger(BarcodeServiceImpl.class);
    @Value(value="${barcode.cuanhuo.url}")
    private String url;
    @Resource
    private MarketingCloudService marketingCloudService;

    @Override
    public BarcodeResultDto queryBarcodeBizFlow(BarcodeReqDto dto) {
        logger.info("\u3010\u9632\u4f2a\u7801\u3011\u83b7\u53d6\u4e32\u8d27\u67e5\u8be2\u5165\u53c21\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        JSONObject map = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
        map.put("access_token", this.marketingCloudService.getToken());
        String storeUrl = this.url + BarcodeUrlEnum.BARCODE_CUANHUO.getUrl();
        JSONObject josnRequest = new JSONObject((Map)map);
        BarcodeResultDto result = this.httpPost(storeUrl, josnRequest, BarcodeResultDto.class);
        logger.info("\u3010\u9632\u4f2a\u7801\u3011\u83b7\u53d6\u4e32\u8d27\u67e5\u8be2\u5165\u53c22\uff1a{}", (Object)JSONObject.toJSONString((Object)josnRequest));
        if (Objects.isNull(result)) {
            throw new BizException("\u8c03\u7528\u9632\u4f2a\u7801\u4e32\u8d27\u67e5\u8be2\u4fe1\u606f\u5931\u8d25");
        }
        logger.info("\u3010\u9632\u4f2a\u7801\u3011\u83b7\u53d6\u836f\u5e97\u5217\u8868\u4fe1\u606furl: {}, {}", (Object)storeUrl, (Object)JacksonUtil.toJson((Object)result));
        if (!"00".equals(result.getErrorCode())) {
            throw new BizException(result.getErrorMessage());
        }
        return result;
    }

    public <T> T httpPost(String url, JSONObject json, Class<T> clazz) {
        HttpPost httppost = new HttpPost(url);
        httppost.setHeader("Content-Type", "application/json;charset=utf-8");
        HttpResponse response = null;
        try {
            logger.info("json: {}", (Object)json);
            StringEntity entity = new StringEntity(json.toString(), "UTF-8");
            httppost.setEntity((HttpEntity)entity);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            response = httpClient.execute((HttpUriRequest)httppost);
            logger.info("response: {}", (Object)response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (response != null);
        HttpEntity httpEntity = response.getEntity();
        logger.info("httpEntity: {}", (Object)httpEntity);
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)httpEntity);
            logger.info("result: {}", (Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)JSONObject.parseObject((String)result, clazz);
    }
}

