/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.enums.OrganizationColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandleOrgServiceImpl")
public class CenterHandleOrgServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleOrgServiceImpl.class);
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Autowired
    private IBizOrganizationQueryApi bizOrganizationQueryApi;

    @Override
    public String getModelType() {
        return null;
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        String userCode = ServiceContext.getContext().getRequestUserCode();
        userCode = StringUtils.isEmpty((CharSequence)userCode) ? "csp_sub-sync" : userCode;
        MDC.put((String)"yes.req.userCode", (String)userCode);
        ServiceContext.getContext().set("yes.req.userCode", (Object)userCode);
        logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636e\u5206\u53d1:{}", (Object)modelInfoReqDto.toString());
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636emap\u8f6c\u6362\u7ed3\u679c:{}", (Object)maps.toString());
        ArrayList<DataDistributeRespDto> respDtoList = new ArrayList<DataDistributeRespDto>();
        for (Map map : maps) {
            OrganizationInfoDto infoDto = new OrganizationInfoDto();
            OrganizationDto organizationDto = new OrganizationDto();
            DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            dataDistributeRespDto.setTask_id(uuid);
            String code = map.get(OrganizationColumnEnum.ORGCODE.name()).toString();
            ArrayList<String> listCode = new ArrayList<String>();
            listCode.add(code);
            RestResponse organizations = this.bizOrganizationQueryApi.getOrganizations(listCode);
            OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = this.enumCopyObject(infoDto, organizationDto, map);
            if (((List)organizations.getData()).size() > 0) {
                for (OrganizationDto datum : (List)organizations.getData()) {
                    RestResponse voidRestResponse = this.organizationApi.modifyOrgAndOrgInfo(datum.getId(), orgAndOrgInfoReqDto);
                    dataDistributeRespDto.setType(voidRestResponse.getResultCode());
                    dataDistributeRespDto.setReason(voidRestResponse.getResultMsg());
                    respDtoList.add(dataDistributeRespDto);
                }
                continue;
            }
            orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
            orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
            RestResponse longRestResponse = this.organizationApi.addOrgAndOrgInfo(orgAndOrgInfoReqDto);
            dataDistributeRespDto.setType(longRestResponse.getResultCode());
            dataDistributeRespDto.setReason(longRestResponse.getResultMsg());
            respDtoList.add(dataDistributeRespDto);
        }
        logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636e\u8fd4\u56de\u7ed3\u679c:{}", (Object)((Object)respDtoList).toString());
        return respDtoList;
    }

    public OrgAndOrgInfoReqDto enumCopyObject(OrganizationInfoDto infoDto, OrganizationDto organizationDto, Map map) {
        OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = new OrgAndOrgInfoReqDto();
        String code = map.get(OrganizationColumnEnum.ORGCODE.name()).toString();
        infoDto.setOrgCode(code);
        if (StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get(OrganizationColumnEnum.ORGNAME.name())))) {
            infoDto.setOrgName(String.valueOf(map.get(OrganizationColumnEnum.ORGNAME.name())));
        }
        infoDto.setSimpleName(String.valueOf(map.get(OrganizationColumnEnum.SHORTNAME.name())));
        infoDto.setOrgType(String.valueOf(map.get(OrganizationColumnEnum.ORGTYPE.name())));
        infoDto.setCreditCode(String.valueOf(map.get(OrganizationColumnEnum.ORGANIZATIONCODE.name())));
        infoDto.setAddress(String.valueOf(map.get(OrganizationColumnEnum.ADDRESS.name())));
        infoDto.setPhoneNum(String.valueOf(map.get(OrganizationColumnEnum.PHONE.name())));
        infoDto.setPostcode(String.valueOf(map.get(OrganizationColumnEnum.POSTCODE.name())));
        infoDto.setId(Long.valueOf(Long.parseLong(String.valueOf(map.get(OrganizationColumnEnum.ORGID.name())))));
        organizationDto.setParentId(Long.valueOf(Long.parseLong(String.valueOf(map.get(OrganizationColumnEnum.FATHERORG.name())))));
        organizationDto.setCode(code);
        organizationDto.setType(String.valueOf(map.get(OrganizationColumnEnum.ORGTYPE.name())));
        organizationDto.setName(String.valueOf(map.get(OrganizationColumnEnum.ORGNAME.name())));
        organizationDto.setName_i1(String.valueOf(map.get(OrganizationColumnEnum.SHORTNAME.name())));
        orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
        orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
        return orgAndOrgInfoReqDto;
    }
}

