/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.tcbj.app.open.biz.dto.response.OrganizationPartnerDto;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.ItemUpdatePriceVo;
import com.dtyunxi.tcbj.app.open.biz.scheduler.SyncWarehouseTenantEvent;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.ICustomerSalesmanRelationService;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeXbDas;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ViewDateReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerRelationApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerRelationReqDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CenterHandleCustomerZBServiceImpl")
public class CenterHandleCustomerZBServiceImpl
implements ICenterHandleService {
    private static final Logger logger = LoggerFactory.getLogger(CenterHandleCustomerZBServiceImpl.class);
    @Resource
    private ICustomerRelationApi customerRelationApi;
    @Resource
    private IDataDistributeService dataDistributeService;
    @Resource
    private DataDistributeXbDas dataDistributeXbDas;
    @Resource
    private SyncWarehouseTenantEvent handleWarehouseTenantTask;
    @Autowired
    private ICustomerSalesmanRelationService customerSalesmanRelationService;
    @Resource
    private ICommonsMqService mqService;
    private final ExecutorService executorService = new ThreadPoolExecutor(3, 3, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(3, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public String getModelType() {
        return ModelCodeEnum.CUSTOMER_ZB.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u4e2dB\u79df\u6236\u540c\u6b65\u6570\u636e\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
        Map params = (Map)JSON.parseObject((String)modelInfoReqDto.getDataStr(), Map.class);
        List maps = this.dataDistributeXbDas.selectOrganizationPartner(params);
        if (CollectionUtil.isEmpty((Collection)maps)) {
            logger.info("\u65e0\u4e2dB\u6570\u636e\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)params));
            return null;
        }
        List organizationPartnerDtoList = com.alibaba.fastjson.JSONObject.parseArray((String)JSONArray.toJSONString((Object)maps), OrganizationPartnerDto.class);
        ArrayList insertRelationList = new ArrayList();
        organizationPartnerDtoList.forEach(dto -> {
            logger.info("\u5904\u7406\u4e2dB\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            if (Objects.equals(1, dto.getOrgLevel())) {
                CustomerRelationReqDto reqDto = new CustomerRelationReqDto();
                reqDto.setThirdCode(dto.getOrgId());
                reqDto.setParentThirdCode(dto.getParOrgId());
                reqDto.setOrgLevel(dto.getOrgLevel() + "");
                insertRelationList.add(reqDto);
            } else {
                CustomerRelationReqDto reqDto = new CustomerRelationReqDto();
                reqDto.setThirdCode(dto.getTenantPartnerId());
                reqDto.setParentThirdCode(dto.getOrgId());
                reqDto.setOrgLevel(dto.getOrgLevel() + "");
                insertRelationList.add(reqDto);
            }
            logger.info("\u5efa\u7acb\u5927B\u4e0e\u5c0fB\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString((Object)insertRelationList));
        });
        this.customerRelationApi.addBatchCustomerRelation(insertRelationList);
        organizationPartnerDtoList.forEach(dto -> {
            logger.info("\u5904\u7406\u4e2dB\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            if (Objects.equals(1, dto.getOrgLevel())) {
                return;
            }
            this.syncTenant(dto.getOrgId());
            String reqId = Optional.ofNullable(ServiceContext.getContext().get("yes.req.requestId")).map(r -> (String)r).orElse(UUID.randomUUID().toString());
            this.executorService.execute(() -> {
                MDC.put((String)"yes.req.requestId", (String)reqId);
                ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                MDC.put((String)"yes.req.userCode", (String)"csp_sub-sync");
                ServiceContext.getContext().set("yes.req.userCode", (Object)"csp_sub-sync");
                logger.info("\u5f02\u6b65\u540c\u6b65\u4e2dB\u79df\u6237\u5bf9\u5e94\u7684\u4e3b\u6570\u636e\uff1a{}", (Object)dto.getOrgId());
                this.syncArea(dto.getOrgId());
                this.syncCustomer(dto.getOrgId());
                this.syncWarehouse(dto.getOrgId());
                this.syncUser(dto.getOrgId());
                this.syncUserRelation(dto.getOrgId());
                this.syncPrice(dto.getOrgId());
                logger.info("\u8865\u5145\u5173\u8054\u4fe1\u606f");
                this.customerRelationApi.replenishCustomerRelation((List)Lists.newArrayList((Object[])new String[]{dto.getOrgId()}));
            });
        });
        return null;
    }

    private void syncTenant(String code) {
        ViewDateReqDto reqDto = new ViewDateReqDto();
        reqDto.setAdd(Boolean.valueOf(true));
        reqDto.setModelCode("CUSTOMER");
        reqDto.setOrder("");
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(100));
        reqDto.setSelectOne(false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("D_ROW_ID", code);
        reqDto.setParams(map);
        this.dataDistributeService.synViewDataReq(reqDto);
    }

    private void syncArea(String code) {
        ViewDateReqDto reqDto = new ViewDateReqDto();
        reqDto.setAdd(Boolean.valueOf(true));
        reqDto.setModelCode("CHANNEL_REGION");
        reqDto.setOrder("");
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(100));
        reqDto.setSelectOne(false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("D_CHANNEL_PARENTID", code);
        reqDto.setParams(map);
        this.dataDistributeService.synViewDataReq(reqDto);
    }

    private void syncCustomer(String code) {
        ViewDateReqDto reqDto = new ViewDateReqDto();
        reqDto.setAdd(Boolean.valueOf(true));
        reqDto.setModelCode("CUSTOMER");
        reqDto.setOrder("D_ROW_ID");
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(100));
        reqDto.setSelectOne(false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("D_PARPARTNERID", code);
        reqDto.setParams(map);
        this.dataDistributeService.synViewDataReq(reqDto);
    }

    private void syncWarehouse(String code) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(code);
        this.handleWarehouseTenantTask.task(strings);
    }

    private void syncUser(String code) {
        ViewDateReqDto reqDto = new ViewDateReqDto();
        reqDto.setAdd(Boolean.valueOf(true));
        reqDto.setModelCode("OUTSIDER");
        reqDto.setOrder("");
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(100));
        reqDto.setSelectOne(false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("D_ORG_ID", code);
        reqDto.setParams(map);
        this.dataDistributeService.synViewDataReq(reqDto);
    }

    private void syncUserRelation(String code) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(code);
        this.customerSalesmanRelationService.syncCustomerSalesmanRelation(strings);
    }

    private void syncPrice(String code) {
        ItemUpdatePriceVo itemUpdatePriceVo = new ItemUpdatePriceVo();
        itemUpdatePriceVo.setTenantId(code);
        this.mqService.sendSingleMessageAsync("ITEM_PRICE_TOPIC", "to-yxy-update-price-inform", (Object)JSONObject.toJSONString((Object)itemUpdatePriceVo));
    }
}

