/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.rabbit;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor.ThirdRedirectProcessor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

public class DispatchMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(DispatchMessageListener.class);
    private static final Map<String, ThirdRedirectProcessor> PROCESSOR_MAP = new HashMap<String, ThirdRedirectProcessor>(10);

    public void onMessage(Message message) {
        logger.info("\u63a5\u6536\u5230\u7b2c\u4e09\u65b9rabbitmq:{}:{}", (Object)message.getMessageProperties().getMessageId(), (Object)JSONObject.toJSONString((Object)message.getMessageProperties()));
        String processKey = DispatchMessageListener.handleKey(message.getMessageProperties().getConsumerQueue(), message.getMessageProperties().getReceivedRoutingKey());
        ThirdRedirectProcessor thirdRedirectProcessor = PROCESSOR_MAP.get(processKey);
        if (thirdRedirectProcessor == null) {
            thirdRedirectProcessor = PROCESSOR_MAP.get(PROCESSOR_MAP.keySet().stream().filter(key -> processKey.contains(key.replaceAll("\\*", ""))).findFirst().orElseThrow(() -> new BizException("\u5f53\u524d\u65e0\u6cd5\u5339\u914d")));
        }
        thirdRedirectProcessor.process(new String(message.getBody()));
    }

    public static void addProcessor(String key, ThirdRedirectProcessor processor) {
        logger.info("\u589e\u52a0mq\u8f6c\u53d1\u5668:{}", (Object)key);
        PROCESSOR_MAP.put(key, processor);
    }

    public static String handleKey(String topic, String tag) {
        return topic + "#" + topic;
    }
}

