/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.csp;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.csp.ApiClient;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseRequest;
import com.dtyunxi.tcbj.app.open.biz.csp.dto.BaseResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestApiClient
implements ApiClient {
    private static final Logger log = LoggerFactory.getLogger(RestApiClient.class);
    private final RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).errorHandler((ResponseErrorHandler)new CustomErrorHandler()).build();
    @Value(value="${portal.api.base-url}")
    private String baseUrl;

    public RestApiClient() {
        log.info("RestApiClient initialized with timeout settings");
    }

    @Override
    public <T, R> BaseResponse<R> post(String endpoint, BaseRequest<T> request, Class<R> dataType) {
        String url = this.baseUrl + endpoint;
        log.info("Making API request to: {}", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(request, (MultiValueMap)headers);
        try {
            ParameterizedTypeReference typeRef = new ParameterizedTypeReference<BaseResponse<R>>(){};
            log.info("Sending request to {}: {}", (Object)url, request);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, typeRef, new Object[0]);
            log.info("Received response from {}: {}", (Object)url, (Object)response.getStatusCode());
            return (BaseResponse)response.getBody();
        }
        catch (RestClientException e) {
            this.handleApiException(url, e);
            throw new BizException("API request failed: " + e.getMessage());
        }
    }

    @Override
    public <T, E> BaseResponse<List<E>> postForList(String endpoint, BaseRequest<T> request) {
        String url = this.baseUrl + endpoint;
        log.info("Making API list request to: {}", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(request, (MultiValueMap)headers);
        try {
            ParameterizedTypeReference typeRef = new ParameterizedTypeReference<BaseResponse<List<E>>>(){};
            log.info("Sending list request to {}: {}", (Object)url, request);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, typeRef, new Object[0]);
            log.info("Received list response from {}: {}", (Object)url, (Object)response.getStatusCode());
            return (BaseResponse)response.getBody();
        }
        catch (RestClientException e) {
            this.handleApiException(url, e);
            throw new BizException("API request failed: " + e.getMessage());
        }
    }

    private void handleApiException(String url, RestClientException e) {
        if (e.getCause() instanceof UnknownHostException) {
            log.error("\u65e0\u6cd5\u89e3\u6790\u4e3b\u673a\u540d\uff0c\u8bf7\u68c0\u67e5URL\u914d\u7f6e\u548c\u7f51\u7edc\u8fde\u63a5: {}", (Object)url, (Object)e);
        } else if (e.getCause() instanceof ConnectException) {
            log.error("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u662f\u5426\u53ef\u7528: {}", (Object)url, (Object)e);
        } else {
            log.error("API\u901a\u4fe1\u9519\u8bef: {}", (Object)url, (Object)e);
        }
    }

    private static class CustomErrorHandler
    extends DefaultResponseErrorHandler {
        private CustomErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            if (response.getStatusCode().is5xxServerError()) {
                throw new ApiException("Server error: " + response.getStatusCode());
            }
            super.handleError(response);
        }
    }
}

