/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.send;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.request.TenantCustomerRelReqDto;
import com.dtyunxi.tcbj.app.open.biz.mq.RabbitMqMessageHelper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerExtRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="CUSTOMER_UPDATE_PUBLISH", msgType="publish")
public class CustomerUpdatePushCspProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(CustomerUpdatePushCspProcessor.class);
    @Autowired
    private RabbitMqMessageHelper rabbitMqMessageHelper;
    @Value(value="${mq.exchange.test:test-common-exchange}")
    private String testExchange;
    @Value(value="${mq.exchange.prod:tcbj-common-exchange}")
    private String prodExchange;
    @Value(value="${mq.routekey.test:test-basedata-sync-yxy2jxc-routekey}")
    private String testRouteKey;
    @Value(value="${mq.routekey.prod:tcbj-basedata-sync-yxy2jxc-routekey}")
    private String prodRouteKey;
    @Value(value="${spring.profiles.active:test}")
    private String activeProfile;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;

    public MessageResponse process(String message) {
        String reqId = Optional.ofNullable(ServiceContext.getContext().get("yes.req.requestId")).map(r -> (String)r).orElse(UUID.randomUUID().toString());
        log.info("\u63a5\u6536\u5230\u5ba2\u6237\u53d8\u66f4\u7684MQ\u6570\u636e:{}", (Object)message);
        MDC.put((String)"yes.req.requestId", (String)reqId);
        try {
            CustomerRespDto customerRespDto = (CustomerRespDto)JSONObject.parseObject((String)message, CustomerRespDto.class);
            CustomerSearchExtReqDto customerSearchExtReqDto = new CustomerSearchExtReqDto();
            customerSearchExtReqDto.setIdList((List)Lists.newArrayList((Object[])new Long[]{customerRespDto.getId()}));
            RestResponse pageInfoRestResponse = this.customerQueryV3Api.queryByPageExport(customerSearchExtReqDto);
            Optional.ofNullable(pageInfoRestResponse.getData()).map(PageSerializable::getList).filter(CollectionUtils::isNotEmpty).map(r -> (CustomerExtRespDto)r.get(0)).ifPresent(r -> {
                customerRespDto.setThirdPartyId(r.getThirdPartyId());
                customerRespDto.setSortCustomerCode(r.getSortCustomerCode());
                customerRespDto.setEasCode(r.getEasCode());
            });
            TenantCustomerRelReqDto tenantCustomerRelReqDto = this.buildTenantCustomerRelRequest(customerRespDto);
            String exchange = "test".equals(this.activeProfile) ? this.testExchange : this.prodExchange;
            String routeKey = "test".equals(this.activeProfile) ? this.testRouteKey : this.prodRouteKey;
            this.rabbitMqMessageHelper.convertAndSend(exchange, routeKey, tenantCustomerRelReqDto);
            log.info("\u79df\u6237\u7ed1\u5b9a\u5ba2\u6237\u4fe1\u606fMQ\u6d88\u606f\u53d1\u9001\u6210\u529f\uff0cexchange:{}, routeKey:{}", (Object)exchange, (Object)routeKey);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5ba2\u6237\u53d8\u66f4MQ\u6570\u636e\u5931\u8d25", (Throwable)e);
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }

    private TenantCustomerRelReqDto buildTenantCustomerRelRequest(CustomerRespDto customerRespDto) {
        TenantCustomerRelReqDto reqDto = new TenantCustomerRelReqDto();
        reqDto.setMessageKey(UUID.randomUUID().toString());
        reqDto.setSrcSystem("OTHER");
        reqDto.setOrigin(false);
        reqDto.setMethod("import-basedata-tenant-customer-rel");
        TenantCustomerRelReqDto.TenantCustomerRelContentDto content = new TenantCustomerRelReqDto.TenantCustomerRelContentDto();
        content.setTenantId(customerRespDto.getThirdPartyId());
        content.setCustomerId(String.valueOf(customerRespDto.getId()));
        content.setName(customerRespDto.getName());
        content.setShortName(null);
        content.setHelpcode(customerRespDto.getSortCustomerCode());
        content.setInnercode(customerRespDto.getEasCode());
        content.setExtcode(customerRespDto.getThirdPartyId());
        reqDto.setContent(content);
        return reqDto;
    }
}

