/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerExtRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.app.open.biz.config.CustomerRegisterConfig;
import com.dtyunxi.tcbj.app.open.biz.customer.CustomerRegisterVo;
import com.dtyunxi.tcbj.app.open.biz.service.ICompanyService;
import com.dtyunxi.tcbj.app.open.biz.service.ICustomerInfoExtService;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.openapi.api.constants.CustomerInfoExtConstant;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.CustomerInfoExtReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerTypeExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsDealEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.TianyanchaProvinceEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryProvinceReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ICustomerInfoExtServiceImpl
implements ICustomerInfoExtService {
    private static final Logger log = LoggerFactory.getLogger(ICustomerInfoExtServiceImpl.class);
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private IStoreApi storeApi;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;
    @Resource
    private ICompanyService companyService;
    @Resource
    private CustomerRegisterConfig customerRegisterConfig;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;

    @Override
    public CustomerRespDto customerInfo(CustomerInfoExtReqDto customerInfoExtReqDto) {
        AssertUtils.isTrue((!StringUtils.isEmpty((Object)customerInfoExtReqDto.getCreditCode()) ? 1 : 0) != 0, (String)"\u6ce8\u518c\u5ba2\u6237\u4fe1\u7528\u4ee3\u7801\u7f3a\u5931");
        AssertUtils.isTrue((!StringUtils.isEmpty((Object)customerInfoExtReqDto.getIdentification()) ? 1 : 0) != 0, (String)"\u6ce8\u518c\u6807\u8bc6\u7f3a\u5931");
        List collect = this.customerRegisterConfig.getCustomerRegisterVos().stream().filter(c -> c.getCode().equals(customerInfoExtReqDto.getIdentification())).collect(Collectors.toList());
        AssertUtils.isTrue((!CollectionUtils.isEmpty(collect) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u6ce8\u518c\u6a21\u5f0f");
        CustomerRegisterVo customerRegisterVo = (CustomerRegisterVo)collect.stream().findFirst().get();
        CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
        customerExtReqDto.setCreditCode(customerInfoExtReqDto.getCreditCode());
        customerExtReqDto.setMerchantId(customerRegisterVo.getMerchantId());
        List customerExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomer(customerExtReqDto));
        if (!CollectionUtils.isEmpty((Collection)customerExtRespDtos)) {
            log.info("\u5f53\u524d\u6ce8\u518c\u5ba2\u6237\u5df2\u5b58\u5728");
            CustomerExtRespDto customerExtRespDto = (CustomerExtRespDto)customerExtRespDtos.stream().findFirst().get();
            return (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByCode(customerExtRespDto.getCode()));
        }
        List storeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.querySocialCreditNums((List)Lists.newArrayList((Object[])new String[]{customerInfoExtReqDto.getCreditCode()})));
        StoreRespDto storeRespDto = CollectionUtils.isEmpty((Collection)storeRespDtos) ? new StoreRespDto() : (StoreRespDto)storeRespDtos.stream().findFirst().get();
        this.storeInfoAfterProcess(customerInfoExtReqDto, storeRespDtos, storeRespDto);
        String customerCode = ICustomerInfoExtServiceImpl.generateUniqueCode();
        CustomerReqExtDto customerReqExtDto = new CustomerReqExtDto();
        customerReqExtDto.setMerchantId(customerRegisterVo.getMerchantId());
        customerReqExtDto.setType(CustomerTypeExtEnum.JUNIOR_RETAILER.getCode());
        customerReqExtDto.setCode(customerCode);
        customerReqExtDto.setName(storeRespDto.getStoreName());
        customerReqExtDto.setParentCustomerId(customerRegisterVo.getParentCustomerId());
        customerReqExtDto.setThirdParentPartyId(customerRegisterVo.getThirdParentPartyId());
        customerReqExtDto.setStatusId(CustomerStatusExtEnum.ENABLED.getCode());
        CompanyInfoDto companyInfoDto = new CompanyInfoDto();
        companyInfoDto.setCreditCode(storeRespDto.getSocialCreditNum());
        companyInfoDto.setLegalName(storeRespDto.getLegalPersonName());
        companyInfoDto.setOrgName(storeRespDto.getStoreName());
        customerReqExtDto.setCompanyInfoDto(companyInfoDto);
        CustomerAddResultDto customerAddResultDto = (CustomerAddResultDto)RestResponseHelper.extractData((RestResponse)this.customerExtThreeApi.add(customerReqExtDto));
        log.info("\u5165\u6237\u5ba2\u6237\u57fa\u7840\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerAddResultDto));
        return (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByCode(customerCode));
    }

    private void storeInfoAfterProcess(CustomerInfoExtReqDto customerInfoExtReqDto, List<StoreRespDto> storeRespDtos, StoreRespDto storeRespDto) {
        CompanyResultDto companyResultDto;
        if (CollectionUtils.isEmpty(storeRespDtos)) {
            companyResultDto = this.companyService.queryCompanyByDesc(customerInfoExtReqDto.getCreditCode());
            StoreReqDto storeReqDto = this.companyResultDtoToStoreRespDto(companyResultDto);
            RestResponseHelper.extractData((RestResponse)this.storeApi.addStore(storeReqDto));
            CubeBeanUtils.copyProperties((Object)storeRespDto, (Object)storeReqDto, (String[])new String[0]);
        }
        if (StringUtils.isEmpty((Object)storeRespDto.getLegalPersonName())) {
            companyResultDto = this.companyService.queryCompanyByDesc(customerInfoExtReqDto.getCreditCode());
            CompanyResultInfoDto result = companyResultDto.getResult();
            storeRespDto.setLegalPersonName(result.getLegalPersonName());
            StoreReqDto storeReqDto = new StoreReqDto();
            CubeBeanUtils.copyProperties((Object)storeReqDto, (Object)storeRespDto, (String[])new String[0]);
            RestResponseHelper.extractData((RestResponse)this.storeApi.updateStore(storeReqDto));
        }
    }

    public static String generateUniqueCode() {
        String uuid = UUID.randomUUID().toString();
        String uniquePart = uuid.substring(0, 8);
        String uniqueCode = "ZB" + uniquePart + "_" + DatePattern.SIMPLE_MONTH_FORMAT.format(new Date());
        return uniqueCode;
    }

    public static void main(String[] args) {
        System.out.println(ICustomerInfoExtServiceImpl.generateUniqueCode());
    }

    private void createOrganization(String orgName) {
        OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
        orgAdvAddReqDto.setTenantId(Long.valueOf(1L));
        orgAdvAddReqDto.setInstanceId(Long.valueOf(1254039287584232622L));
        orgAdvAddReqDto.setCode(ICustomerInfoExtServiceImpl.generateUniqueCode());
        orgAdvAddReqDto.setName(orgName);
        orgAdvAddReqDto.setParentId(CustomerInfoExtConstant.ORG_PARENT_DEFAULT);
        OrgAdvOpRespDto orgAdvOpRespDto = (OrgAdvOpRespDto)RestResponseHelper.extractData((RestResponse)this.organizationExtApi.add(orgAdvAddReqDto));
    }

    private StoreReqDto companyResultDtoToStoreRespDto(CompanyResultDto companyResultDto) {
        CompanyResultInfoDto result = companyResultDto.getResult();
        StoreReqDto storeReqDto = StoreReqDto.builder().storeName(result.getName()).storeAlias(result.getHistoryNames()).socialCreditNum(result.getCreditCode()).province(result.getBase()).city(result.getCity()).district(result.getDistrict()).storeAddr(result.getRegLocation()).storeRegisterAddr(result.getRegLocation()).state(result.getRegStatus()).legalPersonName(result.getLegalPersonName()).isReplenish(IsDealEnum.NOT_DEAL.getCode()).dataOrigin(StoreDataOriginEnum.SKY_EYE_QUERY.getCode()).build();
        TianyanchaProvinceEnum tianyanchaProvince = TianyanchaProvinceEnum.find((String)result.getBase());
        log.info("\u5929\u773c\u67e5\u7701\u4efd\u4fe1\u606f\u6620\u5c04 ==> \u5929\u773c\u67e5\u7ed3\u679c: {}; \u6620\u5c04\u7ed3\u679c {}", (Object)result.getBase(), (Object)(tianyanchaProvince == null ? null : tianyanchaProvince.getProvinceName()));
        if (tianyanchaProvince != null) {
            storeReqDto.setProvince(tianyanchaProvince.getProvinceName());
            storeReqDto.setProvinceCode(tianyanchaProvince.getProvinceCode());
            if (TianyanchaProvinceEnum.BIG_CITY.contains(tianyanchaProvince.getProvinceName()) && "\u5e02\u8f96\u533a".equals(result.getCity())) {
                String bigCityName = tianyanchaProvince.getProvinceName() + "\u5e02";
                log.info("\u5929\u773c\u67e5\u76f4\u8f96\u5e02\u6620\u5c04 ==> \u5929\u773c\u67e5\u7ed3\u679c: {}; \u6620\u5c04\u7ed3\u679c {}", (Object)result.getCity(), (Object)bigCityName);
                result.setCity(bigCityName);
                storeReqDto.setCity(bigCityName);
            }
            String cityCode = this.getStoreAreaCodeByName(result.getCity(), tianyanchaProvince.getProvinceCode(), String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
            storeReqDto.setCityCode(cityCode);
            if (cityCode != null) {
                String districtCode = this.getStoreAreaCodeByName(result.getDistrict(), cityCode, String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));
                storeReqDto.setDistrictCode(districtCode);
            }
        }
        return storeReqDto;
    }

    private String getStoreAreaCodeByName(String name, String parentCode, String level) {
        log.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u53c2\u6570 ==> \u533a\u57df\u540d\u79f0: {}; \u533a\u57dfparentCode {}; level {}", new Object[]{name, parentCode, level});
        if (parentCode == null) {
            return null;
        }
        StoreAreaRespDto storeAreaRespDto = (StoreAreaRespDto)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryByProvince(StoreQueryProvinceReqDto.builder().parentCode(parentCode).level(level).name(name).build()));
        log.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u7ed3\u679c ==> \u533a\u57dfcode: {}", (Object)storeAreaRespDto.getCode());
        return storeAreaRespDto.getCode();
    }
}

