/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolUtils<T, R> {
    private static ThreadPoolExecutor OPENAPI_GLOBAL_THREAD_POOL = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public void submitAsyncTask(Function<T, R> func, T param) {
        CompletableFuture.runAsync(() -> func.apply(param), OPENAPI_GLOBAL_THREAD_POOL);
    }

    public R submitSyncTask(Function<T, R> func, T param) {
        try {
            return (R)CompletableFuture.supplyAsync(() -> func.apply(param), OPENAPI_GLOBAL_THREAD_POOL).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return null;
    }
}

