/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.SellerSkuPriceDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import com.yx.tcbj.center.api.dto.response.SellerSkuPriceRespDto;
import com.yx.tcbj.center.api.query.ISellerSkuPriceQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IPriceRuleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPriceRuleHelper.class);
    @Resource
    private ISellerSkuPriceQueryApi sellerSkuPriceQueryApi;

    public List<ItemPolicyPriceRespDto> getItemPrice(CommunalPriceQueryReqDto communalPriceQueryReqDto) {
        List customerIds = communalPriceQueryReqDto.getCustomerIds();
        Long custId = communalPriceQueryReqDto.getCustId();
        if (CollUtil.isEmpty((Collection)customerIds)) {
            customerIds = ListUtil.toList((Object[])new Long[]{custId});
        }
        if (CollUtil.isEmpty((Collection)customerIds)) {
            return null;
        }
        List skuList = communalPriceQueryReqDto.getSkuList();
        if (CollUtil.isEmpty((Collection)skuList)) {
            return null;
        }
        Map shopIdMap = skuList.stream().collect(Collectors.groupingBy(CommunalPriceQueryReqDto.ItemSkuPriceReqDto::getShopId, Collectors.mapping(CommunalPriceQueryReqDto.ItemSkuPriceReqDto::getSkuId, Collectors.toList())));
        Set<Long> shopIdList = shopIdMap.keySet();
        SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
        sellerSkuPriceReqDto.setCustomerIdList(customerIds);
        sellerSkuPriceReqDto.setSkuIdList(skuList.stream().map(CommunalPriceQueryReqDto.ItemSkuPriceReqDto::getSkuId).collect(Collectors.toList()));
        Map<String, SellerSkuPriceDto> sellerSkuPriceMap = this.getSellerSkuPrice(sellerSkuPriceReqDto);
        HashMap decimalMap = MapUtil.newHashMap();
        ArrayList<ItemPolicyPriceRespDto> itemPolicyPriceRespDtos = new ArrayList<ItemPolicyPriceRespDto>();
        for (CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuInfo : skuList) {
            for (Long customerId : customerIds) {
                String key = customerId + "-" + skuInfo.getSkuId();
                if (sellerSkuPriceMap.containsKey(key) && Objects.nonNull(sellerSkuPriceMap.get(key).getMinSkuPrice())) {
                    SellerSkuPriceDto sellerSkuPriceDto = sellerSkuPriceMap.get(key);
                    ItemPolicyPriceRespDto itemPolicyPriceRespDto = new ItemPolicyPriceRespDto();
                    itemPolicyPriceRespDto.setItemId(skuInfo.getItemId());
                    itemPolicyPriceRespDto.setShopId(sellerSkuPriceDto.getShopId());
                    itemPolicyPriceRespDto.setSkuId(skuInfo.getSkuId());
                    itemPolicyPriceRespDto.setPrice(sellerSkuPriceDto.getMinSkuPrice());
                    itemPolicyPriceRespDto.setCustId(String.valueOf(customerId));
                    HashMap retailPriceMap = MapUtil.newHashMap();
                    BigDecimal retailPrice = sellerSkuPriceDto.getRetailPrice();
                    retailPriceMap.put("retailPrice", retailPrice);
                    itemPolicyPriceRespDto.setExtFields((Map)retailPriceMap);
                    itemPolicyPriceRespDtos.add(itemPolicyPriceRespDto);
                    decimalMap.put(skuInfo.getShopId() + "-" + key, itemPolicyPriceRespDto.getPrice());
                    continue;
                }
                decimalMap.put(skuInfo.getShopId() + "-" + key, null);
            }
        }
        LOGGER.info("[\u4ef7\u683c\u67e5\u8be2] >>> \u5ba2\u6237{}\u67e5\u4ef7\u7ed3\u679c[shopId-customerId-skuId:price]\uff1a{}", (Object)customerIds, (Object)decimalMap);
        return itemPolicyPriceRespDtos;
    }

    public Map<String, SellerSkuPriceDto> getSellerSkuPrice(SellerSkuPriceReqDto sellerSkuPriceReqDto) {
        List sellerSkuPriceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerSkuPriceQueryApi.queryList(sellerSkuPriceReqDto));
        List customerIdList = sellerSkuPriceReqDto.getCustomerIdList();
        boolean isKey = CollUtil.isNotEmpty((Collection)customerIdList);
        HashMap skuPriceMap = CollUtil.newHashMap();
        for (SellerSkuPriceRespDto sellerSkuPriceRespDto : sellerSkuPriceRespDtos) {
            String key = sellerSkuPriceRespDto.getCustomerId() + "-" + sellerSkuPriceRespDto.getSkuId();
            if (skuPriceMap.containsKey(key)) continue;
            SellerSkuPriceDto sellerSkuPriceDto = new SellerSkuPriceDto();
            sellerSkuPriceDto.setMinSkuPrice(sellerSkuPriceRespDto.getSupplyPrice());
            sellerSkuPriceDto.setMaxSkuPrice(sellerSkuPriceRespDto.getSupplyPrice());
            sellerSkuPriceDto.setSellerId(sellerSkuPriceRespDto.getSellerId());
            sellerSkuPriceDto.setSkuId(sellerSkuPriceRespDto.getSkuId());
            sellerSkuPriceDto.setCustomerId(sellerSkuPriceRespDto.getCustomerId());
            sellerSkuPriceDto.setItemId(sellerSkuPriceRespDto.getItemId());
            sellerSkuPriceDto.setRetailPrice(sellerSkuPriceRespDto.getRetailPrice());
            sellerSkuPriceDto.setShopId(sellerSkuPriceRespDto.getShopId());
            skuPriceMap.put(key, sellerSkuPriceDto);
        }
        return skuPriceMap;
    }

    public BigDecimal getDefaultMatchPrice(ItemPolicyPriceRespDto policyDto, Integer num) {
        if (num == null || num == 0) {
            num = 1;
        }
        if (policyDto == null) {
            return null;
        }
        BigDecimal acutualPrice = null;
        if (policyDto.getHasLadderPrice() && policyDto.getLadderPrices() != null && !policyDto.getLadderPrices().isEmpty()) {
            for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : policyDto.getLadderPrices()) {
                Integer lower = ladderPrice.getLower() == null ? -1 : ladderPrice.getLower();
                Integer upper = ladderPrice.getUpper() == null ? Integer.MAX_VALUE : ladderPrice.getUpper();
                if (num.compareTo(lower) < 0 || num.compareTo(upper) > 0) continue;
                acutualPrice = ladderPrice.getPrice();
                break;
            }
        }
        if (acutualPrice == null && policyDto.getHasDiscountPrice()) {
            acutualPrice = policyDto.getDiscountPrice();
        }
        if (acutualPrice == null) {
            acutualPrice = policyDto.getPrice();
        }
        return acutualPrice;
    }
}

