/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor.ItemUpdatePriceProcessor;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.ItemUpdatePriceVo;
import com.dtyunxi.tcbj.app.open.biz.scheduler.SchedulerHelper;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="priceSyncEvent")
@Scope(value="prototype")
public class PriceSyncEvent
extends SingleTupleScheduleEvent
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(PriceSyncEvent.class);
    @Resource
    private ItemUpdatePriceProcessor itemUpdatePriceProcessor;
    @Resource
    private SchedulerHelper schedulerHelper;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi iTaskApi;
    @Value(value="${scheduler.client.app_code:tcbj-openapi-platform}")
    private String appCode;
    @Value(value="${scheduler.client.syncPriceEventCron:0 */10 * * * ?}")
    private String syncPriceEventCron;
    @Value(value="${scheduler.client.ifOpenSyncPrice:false}")
    private boolean ifOpenSyncStore;
    public static final String REDIS_KEY = "PRICE_TENANT:UPDATE";
    public static final String REDIS_KEY_LOCK = "PRICE_TENANT:LOCK";
    @Value(value="${customer.price.relation.sync:false}")
    private boolean syncOpen;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        if (!this.syncOpen) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        this.doExecute(this.cacheService.getList(REDIS_KEY, String.class));
        long endTime = System.currentTimeMillis();
        logger.info("\u5b9a\u65f6\u4ef7\u683c\u540c\u6b65\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        return true;
    }

    private void doExecute(List<String> objs) {
        if (CollectionUtils.isEmpty(objs)) {
            return;
        }
        logger.info("\u540c\u6b65\u4ef7\u683c\u66f4\u65b0\u6570\u91cf:{}", (Object)objs.size());
        Stream.iterate(0, n -> n + 1).limit(objs.size()).forEach(n -> this.cacheService.rpop(REDIS_KEY));
        this.cacheService.delCache(REDIS_KEY);
        objs.stream().map(obj -> (ItemUpdatePriceVo)JSONObject.parseObject((String)obj.split("itemUpdatePriceVo")[1], ItemUpdatePriceVo.class)).forEach(this.itemUpdatePriceProcessor::execute);
    }

    public void after(TaskMsg taskMsg) {
    }

    public void run(String ... args) {
        logger.info(">>>>\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u521b\u5efa");
        try {
            if (!this.ifOpenSyncStore) {
                logger.info(">>>>\u4e0d\u521d\u59cb\u5316\u4efb\u52a1");
                this.schedulerHelper.stopEvent("priceSyncEvent");
                return;
            }
            this.schedulerHelper.startSyncEvent(this.appCode, "priceSyncEvent", "\u5b9a\u65f6\u540c\u6b65\u4ef7\u683c\u4efb\u52a1", this.syncPriceEventCron);
            logger.info(">>>>\u8c03\u5ea6\u4efb\u52a1\u521b\u5efa\u6210\u529f");
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }
}

