/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerAreaColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerAreaApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerAreaExtApi;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="centerHandleCustomerAreaDBServiceImpl")
public class CenterHandleCustomerAreaDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleCustomerAreaDBServiceImpl.class);
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ICustomerAreaApi customerAreaApi;
    @Resource
    private ICustomerAreaExtApi customerAreaExtApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CHANNEL_REGION_VIEW.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u9500\u552e\u533a\u57df\u6570\u636e\u5206\u53d1:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        List maps = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        HashMap<String, Object> areaAddReqDtoMap = new HashMap<String, Object>();
        HashMap areaUpdateReqDtoMap = new HashMap();
        MDC.put((String)"yes.req.userCode", (String)"csp-sync");
        ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
        for (Map map : maps) {
            String regionId;
            String districtId;
            ArrayList areaAddReqDtoList = new ArrayList();
            ArrayList<CustomerAreaExtReqDto> areaUpdateReqDtoList = new ArrayList<CustomerAreaExtReqDto>();
            String taskId = String.valueOf(map.get(ModelCodeEnum.CIDP_TASK_UUID.name()));
            if (!this.validaData(map, responseList)) continue;
            Long orgId = this.getOrgId(map);
            if (orgId == null) {
                DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                dataDistributeRespDto.setTask_id(taskId);
                dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                dataDistributeRespDto.setReason("\u7ec4\u7ec7\u7f16\u7801\u6709\u8bef:" + map.get("CHANNEL_PARENTID"));
                responseList.add(dataDistributeRespDto);
                continue;
            }
            String channelId = String.valueOf(map.get(CustomerAreaColumnEnum.CHANNEL_ID.getField()));
            if (StringUtils.isNotEmpty((CharSequence)channelId)) {
                CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                customerAreaListReqDto.setOrgInfoId(orgId);
                customerAreaListReqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{channelId}));
                List areaRespDtos = (List)this.customerAreaQueryApi.queryForList(customerAreaListReqDto).getData();
                List codeList = areaRespDtos.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
                CustomerAreaExtReqDto customerAreaExtReqDto = new CustomerAreaExtReqDto();
                customerAreaExtReqDto.setCode(channelId);
                customerAreaExtReqDto.setParentCode(NumberUtils.INTEGER_ZERO.toString());
                customerAreaExtReqDto.setName(String.valueOf(Optional.ofNullable(map.get("CHANNEL_NAME")).orElse("")));
                customerAreaExtReqDto.setLevel(NumberUtils.INTEGER_ZERO);
                String channelStatus = String.valueOf(Optional.ofNullable(map.get("CHANNEL_STATUS")).orElse(""));
                customerAreaExtReqDto.setDr("\u5931\u6548".equals(channelStatus) ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO);
                String endDate = String.valueOf(Optional.ofNullable(map.get("CHANNEL_END_DATE")).orElse(""));
                customerAreaExtReqDto.setEndDate(DateUtil.parseDate((String)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
                String updateTime = String.valueOf(Optional.ofNullable(map.get("MODIFYTIME")).orElse(""));
                customerAreaExtReqDto.setUpdateTime(DateUtil.parseDate((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss"));
                this.setCommon(customerAreaExtReqDto);
                customerAreaExtReqDto.setOrgInfoId(orgId);
                if (codeList.contains(channelId)) {
                    areaUpdateReqDtoList.add(customerAreaExtReqDto);
                } else {
                    areaAddReqDtoList.add(customerAreaExtReqDto);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(districtId = String.valueOf(map.get("DISTRICT_ID"))))) {
                CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                customerAreaListReqDto.setOrgInfoId(orgId);
                customerAreaListReqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{districtId}));
                List areaRespDtos = (List)this.customerAreaQueryApi.queryForList(customerAreaListReqDto).getData();
                List codeList = areaRespDtos.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
                CustomerAreaExtReqDto customerAreaExtReqDto = new CustomerAreaExtReqDto();
                customerAreaExtReqDto.setCode(districtId);
                customerAreaExtReqDto.setParentCode(String.valueOf(Optional.ofNullable(map.get("DISTRICT_PARENTID")).orElse("")));
                customerAreaExtReqDto.setName(String.valueOf(Optional.ofNullable(map.get("DISTRICT_NAME")).orElse("")));
                customerAreaExtReqDto.setAreaCode(String.valueOf(Optional.ofNullable(map.get("DISTRICT_CODE")).orElse("")));
                customerAreaExtReqDto.setLevel(NumberUtils.INTEGER_ONE);
                String districtStatus = String.valueOf(Optional.ofNullable(map.get("DISTRICT_STATUS")).orElse(""));
                customerAreaExtReqDto.setDr("\u5931\u6548".equals(districtStatus) ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO);
                String endDate = String.valueOf(Optional.ofNullable(map.get("DISTRICT_END_DATE")).orElse(""));
                customerAreaExtReqDto.setEndDate(DateUtil.parseDate((String)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
                String updateTime = String.valueOf(Optional.ofNullable(map.get("MODIFYTIME")).orElse(""));
                customerAreaExtReqDto.setUpdateTime(DateUtil.parseDate((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss"));
                this.setCommon(customerAreaExtReqDto);
                customerAreaExtReqDto.setOrgInfoId(orgId);
                if (codeList.contains(districtId)) {
                    areaUpdateReqDtoList.add(customerAreaExtReqDto);
                } else {
                    areaAddReqDtoList.add(customerAreaExtReqDto);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(regionId = String.valueOf(map.get("REGION_ID"))))) {
                CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                customerAreaListReqDto.setOrgInfoId(orgId);
                customerAreaListReqDto.setCodes((List)Lists.newArrayList((Object[])new String[]{regionId}));
                List areaRespDtos = (List)this.customerAreaQueryApi.queryForList(customerAreaListReqDto).getData();
                List codeList = areaRespDtos.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
                CustomerAreaExtReqDto customerAreaExtReqDto = new CustomerAreaExtReqDto();
                customerAreaExtReqDto.setCode(regionId);
                customerAreaExtReqDto.setParentCode(String.valueOf(Optional.ofNullable(map.get("DISTRICT_ID")).orElse("")));
                customerAreaExtReqDto.setName(String.valueOf(Optional.ofNullable(map.get("REGION_NAME")).orElse("")));
                customerAreaExtReqDto.setAreaCode(String.valueOf(Optional.ofNullable(map.get("REGION_CODE")).orElse("")));
                customerAreaExtReqDto.setLevel(NumberUtils.INTEGER_TWO);
                String regionStatus = String.valueOf(Optional.ofNullable(map.get("REGION_STATUS")).orElse(""));
                customerAreaExtReqDto.setDr("\u5931\u6548".equals(regionStatus) ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO);
                String endDate = String.valueOf(Optional.ofNullable(map.get("REGION_END_DATE")).orElse(""));
                logger.info("\u533a\u57df\u7ed3\u675f\u65f6\u95f4:{}", JSONObject.toJSON((Object)endDate));
                customerAreaExtReqDto.setEndDate(DateUtil.parseDate((String)endDate, (String)"yyyy-MM-dd HH:mm:ss"));
                logger.info("\u5f53\u524d\u533a\u57df:{}", JSONObject.toJSON((Object)customerAreaExtReqDto));
                String updateTime = String.valueOf(Optional.ofNullable(map.get("MODIFYTIME")).orElse(""));
                customerAreaExtReqDto.setUpdateTime(DateUtil.parseDate((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss"));
                this.setCommon(customerAreaExtReqDto);
                customerAreaExtReqDto.setOrgInfoId(orgId);
                if (codeList.contains(regionId)) {
                    areaUpdateReqDtoList.add(customerAreaExtReqDto);
                } else {
                    areaAddReqDtoList.add(customerAreaExtReqDto);
                }
            }
            areaAddReqDtoMap.put(taskId, areaAddReqDtoList);
            areaUpdateReqDtoMap.put(taskId, areaUpdateReqDtoList);
        }
        logger.info("\u6279\u91cf\u65b0\u589e\u9500\u552e\u533a\u57df\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(areaAddReqDtoMap));
        for (Map.Entry entry : areaAddReqDtoMap.entrySet()) {
            try {
                for (CustomerAreaExtReqDto areaAddReqDto : (List)entry.getValue()) {
                    this.customerAreaExtApi.addCustomerArea(areaAddReqDto);
                }
            }
            catch (Exception e) {
                DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
                dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                dataDistributeRespDto.setReason(e.getMessage());
                dataDistributeRespDto.setTask_id((String)entry.getKey());
                responseList.add(dataDistributeRespDto);
                areaUpdateReqDtoMap.remove(entry.getKey());
            }
        }
        logger.info("\u6279\u91cf\u4fee\u6539\u9500\u552e\u533a\u57df\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(areaUpdateReqDtoMap));
        for (Map.Entry entry : areaUpdateReqDtoMap.entrySet()) {
            DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
            try {
                for (CustomerAreaExtReqDto areaUpdateReqDto : (List)entry.getValue()) {
                    this.customerAreaExtApi.updateCustomerArea(areaUpdateReqDto);
                }
                dataDistributeRespDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
                dataDistributeRespDto.setReason(DataDistributeRespEnum.SUCCESS.getValue());
            }
            catch (Exception e) {
                dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                dataDistributeRespDto.setReason(e.getMessage());
            }
            finally {
                dataDistributeRespDto.setTask_id((String)entry.getKey());
                responseList.add(dataDistributeRespDto);
            }
        }
        return responseList;
    }

    private void setCommon(CustomerAreaExtReqDto customerAreaExtReqDto) {
        customerAreaExtReqDto.setInstanceId(this.requestBaseData.getInstanceId());
        customerAreaExtReqDto.setTenantId(this.requestBaseData.getTenantId());
        customerAreaExtReqDto.setSort(NumberUtils.INTEGER_ONE);
    }

    private Long getOrgId(Map map) {
        String orgInfoCode = String.valueOf(map.get("CHANNEL_PARENTID"));
        if (StringUtils.isEmpty((CharSequence)orgInfoCode)) {
            return null;
        }
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, orgInfoCode);
        if (organizationDtoRestResponse == null || organizationDtoRestResponse.getData() == null) {
            return null;
        }
        OrganizationDto orgAdvRespDto = (OrganizationDto)organizationDtoRestResponse.getData();
        return orgAdvRespDto.getId();
    }

    private boolean validaData(Map map, List<DataDistributeRespDto> responseList) {
        String taskId = String.valueOf(map.get(CustomerAreaColumnEnum.CIDP_TASK_UUID.getField()));
        if ("null".equals(taskId) || StringUtils.isEmpty((CharSequence)taskId)) {
            DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
            dataDistributeRespDto.setTask_id("");
            dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
            dataDistributeRespDto.setReason("taskID\u4e3a\u7a7a:" + JSONObject.toJSONString((Object)map));
            responseList.add(dataDistributeRespDto);
            return false;
        }
        String channelId = String.valueOf(map.get(CustomerAreaColumnEnum.CHANNEL_ID.getField()));
        if (StringUtils.isEmpty((CharSequence)channelId)) {
            DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
            dataDistributeRespDto.setTask_id(taskId);
            dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
            dataDistributeRespDto.setReason("\u6e20\u9053\u7f16\u7801\u4e3a\u7a7a");
            responseList.add(dataDistributeRespDto);
            return false;
        }
        String channelName = String.valueOf(map.get(CustomerAreaColumnEnum.CHANNEL_NAME.getField()));
        if (StringUtils.isEmpty((CharSequence)channelName)) {
            DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
            dataDistributeRespDto.setTask_id(taskId);
            dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
            dataDistributeRespDto.setReason("\u6e20\u9053\u540d\u79f0\u4e3a\u7a7a");
            responseList.add(dataDistributeRespDto);
            return false;
        }
        return true;
    }
}

