/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.EmployeeStatusEnum;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.enums.AccountColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerMaterialRelEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.Base64;
import com.dtyunxi.util.RandomCodeUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.IUserLoginConfigApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeOrgRelationExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="centerHandleAccountDBServiceImpl")
public class CenterHandleAccountDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleAccountDBServiceImpl.class);
    @Autowired
    private IEmployeeQueryApi employeeQueryApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IUserQueryApi userQueryApi;
    @Autowired
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IUserLoginConfigApi userLoginConfigApi;
    @Autowired
    private ISecurityApi securityApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerApi customerApi;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private IEmployeeExpandApi employeeExpandApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CX_AWK_PERSON.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u8d26\u6237\u6570\u636e\u540c\u6b65\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        List list = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        MDC.put((String)"yes.req.userCode", (String)"csp-sync");
        ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        for (Map map : list) {
            try {
                Long userId = 0L;
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get(AccountColumnEnum.USER_ID.name())))) {
                    String dateStr;
                    Date date;
                    userId = this.handleAccount(map);
                    Long orgId = this.handleOrg(map, userId);
                    if (ObjectUtil.isEmpty((Object)orgId)) {
                        logger.info("\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
                        continue;
                    }
                    this.handleSynEmployee(map, userId, orgId);
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    orgIds.add(orgId);
                    UserOrgRelationReqDto userOrgRelationReqDto = new UserOrgRelationReqDto();
                    userOrgRelationReqDto.setUserId(userId);
                    userOrgRelationReqDto.setOrgIds(orgIds);
                    userOrgRelationReqDto.setInstanceId(CommonConstant.INSTANCE_ID);
                    userOrgRelationReqDto.setTenantId(CommonConstant.TENANT_ID);
                    this.organizationApi.addUserOrgRelation(userOrgRelationReqDto);
                    logger.info("\u8d26\u6237\u4e0e\u79df\u6237\u7684\u5173\u7cfb:orgId={}, {}", (Object)orgId, (Object)JSONObject.toJSONString((Object)userOrgRelationReqDto));
                    if (ObjectUtils.isNotEmpty(map.get(AccountColumnEnum.ENDDATE.name())) && (date = DateUtil.parseDate((String)(dateStr = String.valueOf(map.get(AccountColumnEnum.ENDDATE.name())).replace(".0", "")), (String)"yyyy-MM-dd")).before(new Date())) {
                        this.organizationApi.deleteUserOrgRelation(userOrgRelationReqDto);
                    }
                }
                responseList.add(this.dataResp(map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.SUCCESS.getCode(), DataDistributeRespEnum.SUCCESS.getValue()));
            }
            catch (Exception e) {
                logger.info("\u8d26\u6237\u6570\u636e\u5904\u7406\u5f02\u5e38:{}  [{}]", (Object)map, (Object)e);
                responseList.add(this.dataResp(map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.FAILURE.getCode(), e.getMessage()));
            }
        }
        logger.info("\u8d26\u6237\u6570\u636e\u540c\u6b65\u7ed3\u675f:{}", (Object)JSONObject.toJSONString(responseList));
        return responseList;
    }

    private Integer getSalesmanStatus(Map<String, String> map) {
        try {
            return Optional.ofNullable(String.valueOf(map.get(AccountColumnEnum.ENDDATE.name()))).map(s -> s.replace(".0", "")).map(s -> new Date(Long.parseLong(s)).after(new Date()) ? 1 : 0).orElse(1);
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25:{}", (Object)e.getMessage());
            return 1;
        }
    }

    private void handleEmployeeOrgRelation(Map<String, String> map, Long employeeId) {
        Long groupId = this.getEmployeeOrgId(map);
        if (ObjectUtil.isEmpty((Object)groupId)) {
            logger.info("handleEmployeeOrgRelation\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            return;
        }
        EmployeeOrgRelationExtReqDto employeeOrgRelationExtReqDto = new EmployeeOrgRelationExtReqDto();
        employeeOrgRelationExtReqDto.setEmployeeId(employeeId);
        employeeOrgRelationExtReqDto.setOrganizationId(groupId);
        List empOrgList = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.queryEmployeeOrgParam(employeeOrgRelationExtReqDto));
        if (CollectionUtils.isEmpty((Collection)empOrgList)) {
            EmployeeOrgRelationReqDto employeeOrgRelationReqDto = new EmployeeOrgRelationReqDto();
            employeeOrgRelationReqDto.setEmployeeId(employeeId);
            employeeOrgRelationReqDto.setOrgId(groupId);
            logger.info("\u5904\u7406\u4eba\u5458\u4e0e\u7ec4\u7ec7\u7684\u5173\u7cfb: employeeId={} , {}", (Object)employeeId, (Object)JSONObject.toJSONString((Object)employeeOrgRelationReqDto));
            this.organizationApi.addEmployeeOrgRelation(employeeOrgRelationReqDto);
        }
    }

    private Long getEmployeeOrgId(Map<String, String> map) {
        String personType = map.get(AccountColumnEnum.PERSONTYPE.name());
        if ("EXTERNAL".equals(personType.toUpperCase())) {
            return this.getCustomerId(map);
        }
        Long organizationId = this.getOrgId(map.get(AccountColumnEnum.PARTNER_ID.name()));
        logger.info("\u5927B\u8d26\u6237\u5bf9\u5e94\u7684\u79df\u6237: {}", (Object)organizationId);
        return organizationId;
    }

    private Long getCustomerId(Map<String, String> map) {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(map.get(AccountColumnEnum.PARTNER_ID.name()));
        RestResponse response = this.customerQueryApi.queryByThirdPartyIds(list1);
        logger.info("\u5c0fB\u8d26\u6237\u5bf9\u5e94\u7684\u5ba2\u6237: {}", (Object)JSONObject.toJSONString((Object)response));
        if (!CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            map.put(AccountColumnEnum.CUSTOMER_CODE.name(), ((CustomerRespDto)((List)response.getData()).get(0)).getCode());
            return ((CustomerRespDto)((List)response.getData()).get(0)).getOrgInfoId();
        }
        return null;
    }

    private DataDistributeRespDto dataResp(String taskId, String type, String reason) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setTask_id(taskId);
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        return dataDistributeRespDto;
    }

    private Long handleEmployee(Map<String, String> map, Long userId) {
        logger.info("\u5904\u7406\u4eba\u5458\uff0c \u8fd4\u56de\u4eba\u5458\u4fe1\u606f {}", map);
        String employeeNo = map.get(AccountColumnEnum.EMPNO.name());
        if (StringUtils.isEmpty((CharSequence)employeeNo)) {
            employeeNo = map.get(AccountColumnEnum.ROW_ID.name());
        }
        RestResponse employeeResponse = this.employeeQueryApi.queryByEmployeeNo(employeeNo);
        logger.info("\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\uff1a{}, {}", (Object)employeeNo, (Object)JSONObject.toJSONString((Object)employeeResponse));
        EmployeeRespDto employeeRespDto = (EmployeeRespDto)employeeResponse.getData();
        EmployeeExtReqDto employeeExtReqDto = new EmployeeExtReqDto();
        employeeExtReqDto.setType(Integer.valueOf(0));
        employeeExtReqDto.setId(employeeRespDto.getId());
        employeeExtReqDto.setName(map.get(AccountColumnEnum.FULLNAME.name()));
        employeeExtReqDto.setEmployeeNo(employeeNo);
        employeeExtReqDto.setPhoneNum(map.get(AccountColumnEnum.PHONENUMBER.name()));
        employeeExtReqDto.setEmail(map.get(AccountColumnEnum.EMAIL.name()));
        if (StringUtils.isEmpty((CharSequence)employeeExtReqDto.getEmail())) {
            employeeExtReqDto.setEmail(employeeRespDto.getPhoneNum() + "@tcbj.com");
        }
        employeeExtReqDto.setUserId(userId);
        employeeExtReqDto.setNickName(employeeExtReqDto.getName());
        employeeExtReqDto.setInstanceId(CommonConstant.INSTANCE_ID);
        employeeExtReqDto.setTenantId(CommonConstant.TENANT_ID);
        employeeExtReqDto.setYxyPartnerId(map.get(AccountColumnEnum.PARTNER_ID.name()));
        employeeExtReqDto.setYxyOrgId(map.get(AccountColumnEnum.ORG_ID.name()));
        employeeExtReqDto.setPersonType(map.get(AccountColumnEnum.PERSONTYPE.name()));
        try {
            String dateStr;
            if (ObjectUtils.isNotEmpty((Object)map.get(AccountColumnEnum.STARTDATE.name()))) {
                dateStr = String.valueOf(map.get(AccountColumnEnum.STARTDATE.name())).replace(".0", "");
                employeeExtReqDto.setStartTime(DateUtil.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
            }
            if (ObjectUtils.isNotEmpty((Object)map.get(AccountColumnEnum.ENDDATE.name()))) {
                dateStr = String.valueOf(map.get(AccountColumnEnum.ENDDATE.name())).replace(".0", "");
                employeeExtReqDto.setEndTime(DateUtil.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = sdf.parse("2199-01-01");
                employeeExtReqDto.setEndTime(date);
            }
            if (new Date().before(employeeExtReqDto.getEndTime())) {
                employeeExtReqDto.setStatus(EmployeeStatusEnum.ENABLE.getCode());
            } else {
                employeeExtReqDto.setStatus(EmployeeStatusEnum.DISABLE.getCode());
            }
        }
        catch (Exception e) {
            logger.info("\u540c\u6b65\u4eba\u5458\u8d26\u53f7\u65e5\u671f\u89e3\u6790\u9519\u8bef:{}", (Object)e.getMessage());
        }
        logger.info("\u65b0\u589e\u6216\u66f4\u65b0\u4eba\u5458\u4fe1\u606f={}", (Object)JSONObject.toJSONString((Object)employeeRespDto));
        if (employeeRespDto != null && employeeRespDto.getId() != null) {
            employeeExtReqDto.setId(employeeRespDto.getId());
            this.employeeExpandApi.modifyEmployee(CommonConstant.INSTANCE_ID, employeeExtReqDto);
            logger.info("\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeExtReqDto));
            return employeeRespDto.getId();
        }
        RestResponse response = this.employeeExpandApi.addEmployee(CommonConstant.INSTANCE_ID, employeeExtReqDto);
        logger.info("\u65b0\u589e\u4eba\u5458\u4fe1\u606f, {} , {}", (Object)JSONObject.toJSONString((Object)employeeExtReqDto), (Object)JSONObject.toJSONString((Object)response));
        return (Long)response.getData();
    }

    private Long handleAccount(Map<String, String> map) {
        String loginStr = map.get(AccountColumnEnum.ACCOUNT.name());
        UserDto userDto = (UserDto)this.userQueryApi.queryByLoginStr(loginStr, CommonConstant.INSTANCE_ID, "").getData();
        logger.info("\u67e5\u8be2\u8d26\u53f7, {}", (Object)JSONObject.toJSONString((Object)userDto));
        boolean isUpdate = true;
        if (userDto == null) {
            isUpdate = false;
            userDto = new UserDto();
        }
        userDto.setUserName(loginStr);
        userDto.setExtension(map.get(AccountColumnEnum.USER_ID.name()));
        userDto.setNickName(map.get(AccountColumnEnum.USER_NAME.name()));
        userDto.setValidType(Integer.valueOf(1));
        userDto.setTenantId(CommonConstant.TENANT_ID);
        userDto.setInstanceId(CommonConstant.INSTANCE_ID);
        userDto.setPassword(Base64.encodeString((String)"ZJJK123456").replace("==", ""));
        userDto.setUserType(Integer.valueOf("SysAdmin".equals(map.get(AccountColumnEnum.ROLETYPE.name())) ? 11 : 1));
        String personType = map.get(AccountColumnEnum.PERSONTYPE.name());
        if ("INTERNAL".equalsIgnoreCase(personType)) {
            HashSet<RoleDto> roleSet = new HashSet<RoleDto>();
            RoleDto roleDto = new RoleDto();
            roleDto.setCode("tob-dealer-admin");
            roleDto.setId(CommonConstant.TOB_DEALER_ADMIN_ID);
            roleDto.setInstanceId(CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID);
            roleDto.setTenantId(CommonConstant.TENANT_ID);
            roleSet.add(roleDto);
            userDto.setRoleSet(roleSet);
        }
        if (isUpdate) {
            return userDto.getId();
        }
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.TOB_DEALER_ADMIN_INSTANCE_ID.toString());
        RestResponse longRestResponse1 = this.userApi.addUser(CommonConstant.INSTANCE_ID, userDto);
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.INSTANCE_ID.toString());
        logger.info("\u65b0\u589e\u8d26\u53f7, userid = {}, {}", (Object)JSONObject.toJSONString((Object)longRestResponse1), (Object)JSONObject.toJSONString((Object)userDto));
        Long userId = (Long)longRestResponse1.getData();
        this.securityApi.resetPasswordByAdmin(userId, userDto.getPassword());
        UserLoginConfigReqDto userLoginConfigReqDto = new UserLoginConfigReqDto();
        userLoginConfigReqDto.setLoginConfig("1,2");
        userLoginConfigReqDto.setUserId(userId);
        RestResponse loginCoifg = this.userLoginConfigApi.putUserLoginConfig(userId, userLoginConfigReqDto);
        this.handleOrgAdmin(map, userDto.getId());
        logger.info("\u7528\u6237\u767b\u5f55\u914d\u7f6e\u4fe1\u606f {} , {}", (Object)JSONObject.toJSONString((Object)loginCoifg), (Object)JSONObject.toJSONString((Object)userLoginConfigReqDto));
        this.cacheMaintain(userDto, userId);
        return userId;
    }

    private void cacheMaintain(UserDto userDto, Long id) {
        if (userDto.getUserType().equals(11)) {
            this.cacheService.hset("COMMON", "USER_ADMIN_KEY", id + "", (Object)1, 0);
        } else {
            this.cacheService.hdel("COMMON", "USER_ADMIN_KEY", new String[]{id + ""});
        }
    }

    private void handleOrgAdmin(Map<String, String> map, Long userId) {
        if (!"1".equals(map.get(AccountColumnEnum.ADMIN_USER.name()))) {
            return;
        }
        RestResponse restResponse = this.customerQueryApi.queryByThirdPartyIds((List)Lists.newArrayList((Object[])new String[]{map.get(AccountColumnEnum.PARTNER_ID.name())}));
        logger.info("\u67e5\u8be2\u5ba2\u6237\u662f\u5426\u5b58\u5728\uff1a{}", (Object)JSONObject.toJSONString((Object)restResponse));
        if (ObjectUtil.isNotEmpty((Object)restResponse.getData())) {
            CustomerReqDto customerReqDto = new CustomerReqDto();
            customerReqDto.setId(((CustomerRespDto)((List)restResponse.getData()).get(0)).getId());
            customerReqDto.setUserId(userId);
            customerReqDto.setName(((CustomerRespDto)((List)restResponse.getData()).get(0)).getName());
            customerReqDto.setCode(((CustomerRespDto)((List)restResponse.getData()).get(0)).getCode());
            customerReqDto.setRegionCodeList(((CustomerRespDto)((List)restResponse.getData()).get(0)).getRegionCodeList());
            logger.info("\u4fee\u6539\u5ba2\u6237\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)customerReqDto));
            RestResponse customerRespone = this.customerApi.update(customerReqDto);
            logger.info("\u4fee\u6539\u5ba2\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)customerRespone));
        } else {
            logger.info("\u7ba1\u7406\u5458{} \u6ca1\u6709\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f, cs_customer\u8868", (Object)userId);
        }
    }

    private Long handleOrg(Map<String, String> map, Long userId) {
        logger.info("\u5904\u7406\u79df\u6237\uff0c \u8fd4\u56de\u79df\u6237id {}", map);
        String personType = map.get(AccountColumnEnum.PERSONTYPE.name());
        if ("EXTERNAL".equalsIgnoreCase(personType)) {
            Long orgId = this.getCustomerId(map);
            if (ObjectUtil.isEmpty((Object)orgId)) {
                logger.info("\u5916\u90e8\u4eba\u5458\u6240\u5c5e\u7ecf\u9500\u5546ID\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
                return null;
            }
            RestResponse orgResponse = this.organizationQueryExtApi.queryById(orgId);
            if (orgResponse.getData() != null) {
                return ((OrgAdvDetailRespDto)orgResponse.getData()).getId();
            }
            return null;
        }
        String orgCode = map.get(AccountColumnEnum.ORG_ID.name());
        Long orgId = this.getOrgId(orgCode);
        if (orgId != null) {
            return orgId;
        }
        OrgAndOrgInfoReqDto orgAdvAddReqDto = new OrgAndOrgInfoReqDto();
        OrganizationDto organizationDto = new OrganizationDto();
        organizationDto.setCode(orgCode);
        OrganizationInfoDto organizationInfoDto = new OrganizationInfoDto();
        organizationInfoDto.setOrgCode(orgCode);
        organizationInfoDto.setUserId(userId);
        orgAdvAddReqDto.setOrganizationDto(organizationDto);
        orgAdvAddReqDto.setOrganizationInfoDto(organizationInfoDto);
        orgId = (Long)this.organizationApi.addOrgAndOrgInfo(orgAdvAddReqDto).getData();
        logger.info("\u65b0\u589e\u79df\u6237: organizationDto = {}, orgAdvAddReqDto = {}", (Object)JSONObject.toJSONString((Object)organizationDto), (Object)JSONObject.toJSONString((Object)orgAdvAddReqDto));
        return orgId;
    }

    public Long getOrgId(String code) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, code);
        if (organizationDtoRestResponse.getData() != null) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getId();
        }
        return null;
    }

    private Long handleSynEmployee(Map<String, String> map, Long userId, Long orgId) {
        logger.info("\u4e3b\u6570\u636e\u540c\u6b65\u66f4\u65b0\u4eba\u5458\u4fe1\u606f {}", map);
        EmployeeExtReqDto addEmployeeDto = new EmployeeExtReqDto();
        String employeeNo = map.get(AccountColumnEnum.EMPNO.name());
        addEmployeeDto.setEmployeeNo(employeeNo);
        addEmployeeDto.setName(map.get(AccountColumnEnum.FULLNAME.name()));
        addEmployeeDto.setUserId(userId);
        addEmployeeDto.setNickName(addEmployeeDto.getName() + "_" + map.get(AccountColumnEnum.EMPNO.name()));
        addEmployeeDto.setPhoneNum(map.get(AccountColumnEnum.PHONENUMBER.name()));
        addEmployeeDto.setEmail(map.get(AccountColumnEnum.EMAIL.name()));
        if (StringUtils.isEmpty((CharSequence)addEmployeeDto.getEmail())) {
            addEmployeeDto.setEmail(addEmployeeDto.getPhoneNum() + "@tcbj.com");
        }
        addEmployeeDto.setStatus(EmployeeStatusEnum.ENABLE.getCode());
        addEmployeeDto.setOrganizationId(orgId);
        addEmployeeDto.setSex(map.get(AccountColumnEnum.MF.name()));
        String startTimeStr = String.valueOf(map.get(AccountColumnEnum.STARTDATE.name())).replace(".0", "");
        Date startTime = DateUtil.getToday();
        if (StringUtils.isNotEmpty((CharSequence)startTimeStr)) {
            startTime = DateUtil.parseDate((String)startTimeStr, (String)"yyyy-MM-dd");
        }
        addEmployeeDto.setStartTime(startTime);
        String endTimeStr = String.valueOf(map.get(AccountColumnEnum.ENDDATE.name())).replace(".0", "");
        Date endTime = null;
        if (StringUtils.isNotEmpty((CharSequence)endTimeStr)) {
            endTime = DateUtil.parseDate((String)endTimeStr, (String)"yyyy-MM-dd");
        }
        addEmployeeDto.setEndTime(endTime);
        Date today = DateUtil.getToday();
        if (ObjectUtil.isNotEmpty((Object)endTime) && endTime.compareTo(today) < 0) {
            addEmployeeDto.setStatus(EmployeeStatusEnum.DISABLE.getCode());
        }
        addEmployeeDto.setIdCardNo(map.get(AccountColumnEnum.IDNUMBER.name()));
        String birthday = String.valueOf(map.get(AccountColumnEnum.BIRTHDATE.name()));
        if (StringUtils.isNotEmpty((CharSequence)birthday)) {
            addEmployeeDto.setBirthday(DateUtil.parseDate((String)birthday, (String)"yyyy-MM-dd"));
        }
        addEmployeeDto.setHomeTel(map.get(AccountColumnEnum.FAMILYPHONE.name()));
        addEmployeeDto.setFixedTel(map.get(AccountColumnEnum.PRIMARYPHONE.name()));
        addEmployeeDto.setExtTelNumber(map.get(AccountColumnEnum.EXTPHONE.name()));
        addEmployeeDto.setQq(map.get(AccountColumnEnum.QQ.name()));
        addEmployeeDto.setFax(map.get(AccountColumnEnum.FAXPHONE.name()));
        addEmployeeDto.setEducation(map.get(AccountColumnEnum.EDUCATIONALBG.name()));
        addEmployeeDto.setContactAddress(map.get(AccountColumnEnum.ADDRESS.name()));
        try {
            String entryTime = map.get(AccountColumnEnum.HIREDATE.name());
            if (StringUtils.isNotEmpty((CharSequence)entryTime)) {
                addEmployeeDto.setEntryTime(DateUtil.parseDate((String)entryTime, (String)"yyyy-MM-dd"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String departureTime = String.valueOf(map.get(AccountColumnEnum.DIMISSIONDATE.name()));
        if (StringUtils.isNotEmpty((CharSequence)departureTime)) {
            addEmployeeDto.setDepartureTime(DateUtil.parseDate((String)departureTime, (String)"yyyy-MM-dd"));
        }
        addEmployeeDto.setPosition(map.get(AccountColumnEnum.ROLETYPENAME.name()));
        addEmployeeDto.setStaffId(map.get(AccountColumnEnum.ROW_ID.name()));
        addEmployeeDto.setInstanceId(CommonConstant.INSTANCE_ID);
        addEmployeeDto.setTenantId(CommonConstant.TENANT_ID);
        addEmployeeDto.setYxyPartnerId(map.get(AccountColumnEnum.PARTNER_ID.name()));
        addEmployeeDto.setYxyOrgId(map.get(AccountColumnEnum.ORG_ID.name()));
        addEmployeeDto.setPersonType(map.get(AccountColumnEnum.PERSONTYPE.name()));
        if ("EXTERNAL".equals(addEmployeeDto.getPersonType().toUpperCase())) {
            addEmployeeDto.setType(Integer.valueOf(1));
            addEmployeeDto.setCustomerCode(map.get(AccountColumnEnum.CUSTOMER_CODE.name()));
        } else {
            addEmployeeDto.setType(Integer.valueOf(0));
        }
        List employeeExtReqDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.batchSynSaveEmployee(Collections.singletonList(addEmployeeDto)));
        if (CollectionUtils.isEmpty((Collection)employeeExtReqDtos)) {
            logger.info("\u6279\u91cf\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        return ((EmployeeExtReqDto)employeeExtReqDtos.get(0)).getId();
    }
}

