/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ContentRepeatableHttpServletRequestWrapper;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ModeTypeEnum;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthProperties;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.SignHelper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.dto.BasicSignDto;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class ThirdAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ThirdAuthInterceptor.class);
    private static final String MSG_API_NOT_SIGN = "{\"resultCode\":401,\"resultMsg\":\"not sign ,%s\"}";
    private final Map<String, String> instanceSecretMap = new ConcurrentHashMap<String, String>();
    private final ThirdAuthProperties properties;
    private List<Pattern> wildcards;
    private final Map<String, Boolean> precisionMap = new HashMap<String, Boolean>(10);
    private final SignHelper signHelper;
    private final ThreadLocal<String> local = ThreadLocal.withInitial(() -> "");

    public ThirdAuthInterceptor(SignHelper signHelper, ThirdAuthProperties properties) {
        this.signHelper = signHelper;
        this.properties = properties;
    }

    @PostConstruct
    public void init() {
        List<String> apiPaths = this.properties.getTargetList();
        this.wildcards = new ArrayList<Pattern>(apiPaths.size());
        String urlFragmentWildcard = "((/[a-zA-Z0-9-|_]+)|(/\\{[a-zA-Z0-9-|_]+\\}))";
        String multiWildcard = "(" + urlFragmentWildcard + ")+";
        String r1 = "/**";
        String r2 = "/*";
        apiPaths.forEach(path -> {
            if (path.contains(r1)) {
                path = path.replace(r1, multiWildcard);
                path = path.replace(r2, urlFragmentWildcard);
                this.wildcards.add(Pattern.compile(path));
            } else if (path.contains(r2)) {
                path = path.replace("r2", urlFragmentWildcard);
                this.wildcards.add(Pattern.compile(path));
            } else {
                this.precisionMap.put((String)path, true);
            }
        });
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String path = request.getRequestURI().replace(request.getContextPath(), "");
        return Optional.ofNullable(this.properties.getTargetList()).filter(list -> list.size() != 0).map(targets -> {
            if (this.match(path) && !Optional.ofNullable(request.getHeader("X-Yx-Signature")).map(sign -> this.isValid(request, (String)sign)).orElse(false).booleanValue()) {
                try (PrintWriter writer = response.getWriter();){
                    writer.write(String.format(MSG_API_NOT_SIGN, this.local.get()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }
            return true;
        }).orElse(true);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.local.remove();
    }

    private Boolean isValid(HttpServletRequest request, String sign) {
        String applicationKey = request.getHeader("Application-Key");
        return Optional.ofNullable(this.getAppSecret(applicationKey)).filter(StringUtils::isNotBlank).map(appSecret -> {
            BasicSignDto basicSignDto = new BasicSignDto();
            basicSignDto.setNonce(request.getHeader("X-Yx-Nonce"));
            basicSignDto.setTimestamp(request.getHeader("X-Yx-Timestamp"));
            basicSignDto.setAppSecret((String)appSecret);
            basicSignDto.setAppKey(applicationKey);
            basicSignDto.setReqParam(this.extractReqParam(request));
            String sign1 = this.signHelper.sign(basicSignDto);
            String s = JSONObject.toJSONString((Object)basicSignDto) + "," + sign1;
            this.local.set(s);
            log.info("\u7b7e\u540d\u8c03\u8bd5\u65e5\u5fd7:{}", (Object)s);
            return sign1.equals(sign);
        }).orElse(false);
    }

    private JSONObject extractReqParam(HttpServletRequest request) {
        if (ModeTypeEnum.ZERO.equals((Object)ModeTypeEnum.resolve(this.properties.getModel()))) {
            return new JSONObject();
        }
        try {
            return this.doExtractReqParam(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    private JSONObject doExtractReqParam(HttpServletRequest request) throws IOException {
        switch (Objects.requireNonNull(HttpMethod.resolve((String)request.getMethod()))) {
            case POST: 
            case PUT: {
                return JSONObject.parseObject((String)((ContentRepeatableHttpServletRequestWrapper)request).getBody(), (Feature[])new Feature[]{Feature.OrderedField});
            }
            case GET: 
            case DELETE: {
                return Optional.ofNullable(URLEncoder.encode(request.getQueryString(), "utf-8")).map(this::parseUrlData).orElse(new JSONObject());
            }
        }
        return new JSONObject();
    }

    private JSONObject parseUrlData(String data) {
        String[] split = data.split("&");
        JSONObject result = new JSONObject(split.length, true);
        Stream.of(split).forEach(str -> {
            String[] param = str.split("=");
            result.put(param[0], (Object)param[1]);
        });
        return result;
    }

    private String getAppSecret(String applicationKey) {
        this.instanceSecretMap.putIfAbsent(applicationKey, this.loadAppSecret(applicationKey));
        return this.instanceSecretMap.get(applicationKey);
    }

    private String loadAppSecret(String applicationKey) {
        return this.properties.getAppKeyMap().getOrDefault(applicationKey, "");
    }

    private boolean match(String path) {
        return this.precisionMap.containsKey(path) || this.wildcards.stream().anyMatch(pattern -> pattern.matcher(path).matches());
    }
}

