/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleRouteService;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MainDataResult;
import com.dtyunxi.util.RandomCodeUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="tcbj-partner-update-queue")
public class DealerProcessor
implements IMessageProcessor<Object> {
    private static final Logger log = LoggerFactory.getLogger(DealerProcessor.class);
    @Autowired
    private ICenterHandleRouteService centerHandleRouteService;
    @Resource
    private IDataDistributeService dataDistributeService;
    private static final String VIEW_COLUMN_PREFIX = "D_";
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(Object message) {
        String reqId = Optional.ofNullable(ServiceContext.getContext().get("yes.req.requestId")).map(r -> (String)r).orElse(UUID.randomUUID().toString());
        log.info("\u63a5\u6536\u5230\u5ba2\u6237\u53d8\u66f4\u7684MQ\u6570\u636e:{}", message);
        this.executorService.execute(new Thread(() -> {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
            MDC.put((String)"yes.req.userCode", (String)"csp_sub-sync");
            ServiceContext.getContext().set("yes.req.userCode", (Object)"csp_sub-sync");
            log.info("\u5f00\u59cb\u5904\u7406\u5ba2\u6237\u53d8\u66f4\u7684MQ\u6570\u636e:{}", message);
            try {
                JSONObject parse = (JSONObject)JSONObject.parse((String)String.valueOf(message));
                JSONArray id = (JSONArray)parse.get((Object)"id");
                List idList = id.toJavaList(String.class);
                if (CollectionUtils.isEmpty((Collection)idList)) {
                    log.info("\u67e5\u8be2\u5ba2\u6237\u89c6\u56fe\u7684\u5165\u53c2\u4e3a\u7a7a");
                    return;
                }
                if (idList.size() > 1000) {
                    List partitionList = Lists.partition((List)idList, (int)1000);
                    for (List list : partitionList) {
                        List<Map<String, String>> mapList = this.dataDistributeService.selectCustomerViewData(list);
                        if (CollectionUtils.isEmpty(mapList)) {
                            log.info("\u67e5\u8be2\u5230\u89c6\u56fe\u7684\u6570\u636e\u4e3a\u7a7a");
                            continue;
                        }
                        this.dealWithData(mapList);
                    }
                } else {
                    List<Map<String, String>> mapList = this.dataDistributeService.selectCustomerViewData(idList);
                    if (CollectionUtils.isEmpty(mapList)) {
                        log.info("\u67e5\u8be2\u5230\u89c6\u56fe\u7684\u6570\u636e\u4e3a\u7a7a");
                        return;
                    }
                    this.dealWithData(mapList);
                }
            }
            catch (Exception e) {
                log.error("\u76d1\u542c\u5668\u63a5\u6536\u5230\u6d88\u606f\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
        }));
        return MessageResponse.SUCCESS;
    }

    private void dealWithData(List<Map<String, String>> mapList) {
        MainDataResult result = new MainDataResult();
        ModelInfoReqDto modelInfoReqDto = new ModelInfoReqDto();
        modelInfoReqDto.setDataStr(DealerProcessor.getViewData("CUSTOMER", mapList));
        result.setResult(this.centerHandleRouteService.route("CUSTOMER").handle(modelInfoReqDto));
    }

    public void printProcessorInfo() {
        MQDesc mqDesc = this.getClass().getAnnotation(MQDesc.class);
        if (mqDesc == null) {
            log.info("ProcessorInfo: \u672a\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f");
            return;
        }
        String info = String.format("topic=%s, tag=%s, consumer=%s, msgType=%s", mqDesc.topic(), mqDesc.tag(), mqDesc.consumer(), mqDesc.msgType());
        log.info("ProcessorInfo: {}", (Object)info);
    }

    private static String getViewData(String modelCode, List<Map<String, String>> list) {
        ArrayList dataList = new ArrayList();
        for (Map<String, String> map : list) {
            HashMap<String, String> fileds = new HashMap<String, String>();
            for (String key : map.keySet()) {
                if (key.startsWith(VIEW_COLUMN_PREFIX)) {
                    fileds.put(key.substring(2), map.get(key));
                    continue;
                }
                fileds.put(key, map.get(key));
            }
            fileds.put("CIDP_TASK_UUID", RandomCodeUtil.generateTextCode((int)0, (int)6));
            dataList.add(fileds);
        }
        return JSONArray.toJSONString(dataList);
    }
}

