/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.config.MarketingCloudConfig;
import com.dtyunxi.tcbj.app.open.biz.control.ControlHelper;
import com.dtyunxi.tcbj.app.open.biz.customer.CustomerHelper;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.HttpResponseDto;
import com.dtyunxi.tcbj.app.open.biz.enums.ImarketingUrlEnum;
import com.dtyunxi.tcbj.app.open.biz.order.SubmitOrderHelper;
import com.dtyunxi.tcbj.app.open.biz.pay.PayHelp;
import com.dtyunxi.tcbj.app.open.biz.price.impl.PriceHelper;
import com.dtyunxi.tcbj.app.open.biz.service.IErpOrderService;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.tcbj.app.open.biz.service.after.abs.AbstractAfterSaleService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.IPriceRuleHelper;
import com.dtyunxi.tcbj.app.open.biz.storage.IStorageHelper;
import com.dtyunxi.tcbj.app.open.biz.utils.ErpOrderAssert;
import com.dtyunxi.tcbj.app.open.biz.utils.HttpTimeOutUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.OrderExceptionEnum;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.AuditArtificialResqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.CreateAfterSalesOrderDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.FinanceAuditReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ItemReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.NotifyConfirmOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OrderHonourAgreementDetailReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OrderHonourAgreementHeaderReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OrderInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OrderItemExtDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OrderReviewDetailsReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ReviewSaleReturnInHeadReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.SalesReturnAmountReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.TenantMaterialReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.UnauditReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.YXYOrderAuditReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.order.CustomerAddressReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.order.ErpSubmitOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.InfoRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OrderActivityDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OrderHonourAgreementDetailRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OrderHonourAgreementHeaderRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OrderHonourAgreementReturnDetailRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.OrderInfoRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.ProductRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.SubItemRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.OrganizationCompanyDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ReqCodeEnum;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.IAddressQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerRelationQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ParseSubItemReq;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.query.IMqMessageQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IInventorySubItemQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.InOrderCategory;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.InDraOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.MqMessageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.SubItemRelationReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.SubItemRelationRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.payment.util.HttpUtil;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.query.ICommunalPriceQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.BasicConfigEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnOmniItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.activity.OrderActivityRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IBasicConfigQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderActivityQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.IOrderBizApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.api.query.ISellerSkuPriceQueryApi;
import com.yx.tcbj.center.price.api.query.IEnablePriceConfigQueryApi;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaAccountRespDto;
import com.yx.tcbj.center.rebate.api.query.IReturnsQuotaAccountQueryApi;
import com.yx.tcbj.center.trade.api.IReturnV2Api;
import com.yx.tcbj.center.trade.api.dto.response.ReturnV2025Dto;
import com.yx.tcbj.center.trade.api.query.IOrderAuditExtQueryApi;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpOrderServiceImpl
implements IErpOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErpOrderServiceImpl.class);
    @Resource
    private MarketingCloudService marketingCloudService;
    @Resource
    private MarketingCloudConfig marketingCloudConfig;
    @Resource
    private IOrderQueryApi orderQueryApi;
    @Resource
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IOrderActivityQueryApi orderActivityQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IMqMessageQueryApi mqMessageQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ITcbjReciptApi tcbjReciptApi;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private ISellerSkuPriceQueryApi sellerSkuPriceQueryApi;
    @Resource
    private IOrderAuditExtQueryApi orderAuditExtQueryApi;
    @Resource
    private IAfterSalesTobApi afterSalesTobApi;
    @Resource
    private IOrderBizApi orderBizApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ITcbjInventoryApi iTcbjInventoryApi;
    @Resource
    private ICsDeliveryNoticeOrderApi csDeliveryNoticeOrderApi;
    @Resource
    private IOrganizationQueryExtApi organizationPropQueryApi;
    @Autowired
    private IBasicConfigQueryApi basicConfigQueryApi;
    @Autowired
    private SubmitOrderHelper submitOrderHelper;
    @Autowired
    private IStorageHelper storageHelper;
    @Autowired
    private IOrderApi orderApi;
    @Autowired
    private PriceHelper priceHelper;
    @Autowired
    private ControlHelper controlHelper;
    @Autowired
    private IAddressQueryApi addressQueryApi;
    @Autowired
    private CustomerHelper customerHelper;
    @Autowired
    private PayHelp payHelp;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IEnablePriceConfigQueryApi enablePriceConfigQueryApi;
    @Resource
    private ICommunalPriceQueryApi communalPriceQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    @Resource
    ICacheService cacheService;
    @Resource
    private IReturnsQuotaAccountQueryApi returnsQuotaAccountQueryApi;
    @Resource
    private ICustomerRelationQueryApi customerRelationQueryApi;
    @Resource
    private IAfterSalesApi afterSalesApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private com.yx.tcbj.center.customer.api.query.ICustomerQueryApi customerQueryApiExt;
    @Resource
    private IPriceRuleHelper priceRuleHelper;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource(name="subTenantAfterSaleServiceImpl")
    private AbstractAfterSaleService abstractAfterSaleService;
    @Resource
    private IInventorySubItemQueryApi inventorySubItemQueryApi;
    @Autowired
    IReturnV2Api returnV2Api;

    @Override
    public void financeCancelAudit(FinanceAuditReqDto dto) {
        LOGGER.info("\u8c03\u7528\u8425\u9500\u4e91--\u300b\u5165\u53c2\u4e3a:{}", (Object)JacksonUtil.toJson((Object)dto));
        String accessToken = this.marketingCloudService.getToken();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantId", (Object)dto.getOrgCode());
        jsonObject.put("othernumber", (Object)dto.getOrderNo());
        String params = "?access_token=" + accessToken;
        String url = this.marketingCloudConfig.getJxcUrl(ImarketingUrlEnum.RETURN_CAN_UNAUDIT.getField()) + params;
        if (dto.getType() == 2) {
            url = this.marketingCloudConfig.getJxcUrl(ImarketingUrlEnum.SUBSALERETURN_CANUNAUDIT.getField()) + params;
        }
        String result = "";
        HashMap<String, String> mapHeaders = new HashMap<String, String>();
        mapHeaders.put("Content-Type", "application/json");
        try {
            result = HttpUtil.post((String)url, (String)jsonObject.toJSONString(), mapHeaders);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("\u8c03\u7528\u662f\u5426\u53cd\u5ba1\u6838\u8bf7\u6c42\u5730\u5740\u4e3a:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{},\u8fd4\u56de\u7684\u63a5\u53e3\u4fe1\u606f\u4e3a:{}", new Object[]{url, jsonObject.toJSONString(), result});
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"10003", (String)"\u8425\u9500\u4e91\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\u7a7a");
        HttpResponseDto httpResponseDto = (HttpResponseDto)JacksonUtil.readValue((String)result, HttpResponseDto.class);
        if (this.canSkipRejectValidaFromJxc(dto, httpResponseDto)) {
            return;
        }
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)httpResponseDto.getErrorCode().equals("0"), (String)httpResponseDto.getErrorCode(), (String)httpResponseDto.getErrorMessage());
        Boolean returnBool = (Boolean)httpResponseDto.getReturnObject();
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)returnBool, (String)"10004", (String)"\u626b\u7801\u67aa\u5df2\u63a5\u53d7\u8ba2\u5355\uff0c\u8bf7\u5728\u626b\u7801\u67aa\u7684\u672c\u5730\u8ba2\u5355\u5220\u9664\u540e\u518d\u53cd\u5ba1");
        String auditUrl = this.marketingCloudConfig.getUrl(ImarketingUrlEnum.SALEORDER_UNAUDIT.getField()) + params;
        if (dto.getType() == 2) {
            auditUrl = this.marketingCloudConfig.getUrl(ImarketingUrlEnum.SUBSALERETURN_UNAUDIT.getField()) + params;
        }
        String auditResult = "";
        try {
            auditResult = HttpTimeOutUtil.post(auditUrl, jsonObject.toJSONString(), mapHeaders, 300);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("\u8c03\u7528\u53cd\u5ba1\u6838\u5730\u5740\u4e3a:{},\u53c2\u6570\u4e3a:{},\u8fd4\u56de\u7684\u63a5\u53e3\u4fe1\u606f\u4e3a:{}", new Object[]{auditUrl, jsonObject.toJSONString(), auditResult});
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)auditResult), (String)"10003", (String)"\u8425\u9500\u4e91\u53cd\u5ba1\u6838\u63a5\u53e3\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\u7a7a");
        HttpResponseDto responseDto = (HttpResponseDto)JacksonUtil.readValue((String)auditResult, HttpResponseDto.class);
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)responseDto.getErrorCode().equals("0"), (String)responseDto.getErrorCode(), (String)responseDto.getErrorMessage());
        Boolean orderAuditMapResultBool = (Boolean)responseDto.getReturnObject();
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)orderAuditMapResultBool, (String)"10003", (String)"\u626b\u7801\u67aa\u5df2\u63a5\u53d7\u9000\u8ba2\u5355\uff0c\u8bf7\u5728\u626b\u7801\u67aa\u7684\u672c\u5730\u9000\u8ba2\u5355\u5220\u9664\u540e\u518d\u53cd\u5ba1");
        this.cacheService.setCache("AuditfinanceCancel:" + dto.getOrderNo(), (Object)Boolean.TRUE, 86400);
    }

    private boolean canSkipRejectValidaFromJxc(FinanceAuditReqDto dto, HttpResponseDto httpResponseDto) {
        boolean orderNotExist;
        LOGGER.info("\u53cd\u5ba1\u662f\u5426\u8df3\u8fc7\u8fdb\u9500\u5b58\u6821\u9a8c dto:{}, httpResponseDto={}", (Object)JacksonUtil.toJson((Object)dto), (Object)JSONObject.toJSONString((Object)httpResponseDto));
        boolean bl = orderNotExist = "400".equals(httpResponseDto.getErrorCode()) && httpResponseDto.getErrorMessage() != null && httpResponseDto.getErrorMessage().contains("\u4e0d\u5b58\u5728");
        if (!orderNotExist) {
            LOGGER.info("\u53cd\u5ba1\u662f\u5426\u8df3\u8fc7\u8fdb\u9500\u5b58\u6821\u9a8c: \u8ba2\u5355\u5b58\u5728 \u7ee7\u7eed\u6821\u9a8c httpResponseDto={}", (Object)JSONObject.toJSONString((Object)httpResponseDto));
            return false;
        }
        Date orderUpdateTime = null;
        if (dto.getType() == 1) {
            OrderQueryReqDto reqDto = new OrderQueryReqDto();
            reqDto.setOrderNo(dto.getOrderNo());
            OrderRespDto orderRespDto = (OrderRespDto)((PageInfo)RestResponseHelper.extractData((RestResponse)this.orderQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), Integer.valueOf(1), Integer.valueOf(1)))).getList().get(0);
            orderUpdateTime = orderRespDto.getUpdateTime();
            LOGGER.info("\u67e5\u8be2\u5230\u8ba2\u5355 orderRespDto={}", (Object)JSONObject.toJSONString((Object)orderRespDto));
        } else if (dto.getType() == 2) {
            ReturnV2025Dto returnV2025Dto = (ReturnV2025Dto)this.returnV2Api.queryReturnByReturnNo(ReturnV2025Dto.builder().returnNo(dto.getOrderNo()).build()).getData();
            orderUpdateTime = returnV2025Dto.getUpdateTime();
            LOGGER.info("\u67e5\u8be2\u5230\u9000\u8d27\u5355 returnV2025Dto={}", (Object)JSONObject.toJSONString((Object)returnV2025Dto));
        } else {
            LOGGER.info("\u6ca1\u67e5\u5230\u8ba2\u5355 \u4e0e\u6211\u65e0\u74dc1 \u8df3\u8fc7 dto={}", (Object)JSONObject.toJSONString((Object)dto));
            return false;
        }
        boolean canSkip = orderUpdateTime.before(DateUtils.addDays((Date)new Date(), (int)-1));
        LOGGER.info("\u53cd\u5ba1\u662f\u5426\u8df3\u8fc7\u8fdb\u9500\u5b58\u6821\u9a8c canSkip:{} updateTime={}", (Object)JacksonUtil.toJson((Object)canSkip), (Object)orderUpdateTime);
        return canSkip;
    }

    @Override
    public Map<String, Object> orderHonourAgreementHeader(OrderHonourAgreementHeaderReqDto dto) {
        List orderAuditList;
        List orderNos;
        ArrayList<InfoRespDto> infoRespDtoList;
        OrderHonourAgreementHeaderRespDto result = new OrderHonourAgreementHeaderRespDto();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LOGGER.info("\u67e5\u8be2\u8ba2\u5355\u8868\u5934\u5165\u53c2:{}", (Object)JacksonUtil.toJson((Object)dto));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("seq", null);
        resultMap.put("message", "");
        if (StringUtils.isEmpty((CharSequence)dto.getOrgId())) {
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
            result.setTips(new String[]{"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a"});
            resultMap.put("data", result);
            resultMap.put("code", 1);
            return resultMap;
        }
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryOneByOrgCode(null, dto.getOrgId());
        LOGGER.info("\u67e5\u8be2\u79df\u6237\u4fe1\u606f {}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (organizationDtoRestResponse.getData() == null) {
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
            result.setTips(new String[]{"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u4fe1\u606f"});
            resultMap.put("data", result);
            resultMap.put("code", 1);
            return resultMap;
        }
        dto.setOrgId(String.valueOf(((OrganizationDto)organizationDtoRestResponse.getData()).getId()));
        if ("1".equals(dto.getNature())) {
            LOGGER.info("\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5");
            RestResponse orderRespDtoRest = this.orderQueryApi.queryByPage(this.queryCondition(dto), Integer.valueOf(Integer.parseInt(dto.getPage())), Integer.valueOf(10));
            result.setPage(String.valueOf(((PageInfo)orderRespDtoRest.getData()).getPageNum()));
            result.setPageAll(String.valueOf(((PageInfo)orderRespDtoRest.getData()).getPages()));
            result.setSize(String.valueOf(((PageInfo)orderRespDtoRest.getData()).getSize()));
            result.setSizeAll(String.valueOf(((PageInfo)orderRespDtoRest.getData()).getTotal()));
            result.setSizeShow(String.valueOf(((PageInfo)orderRespDtoRest.getData()).getPageSize()));
            infoRespDtoList = new ArrayList<InfoRespDto>();
            List orderRespDtoList = ((PageInfo)orderRespDtoRest.getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)orderRespDtoList)) {
                orderNos = orderRespDtoList.stream().map(OrderRespDto::getOrderNo).collect(Collectors.toList());
                orderAuditList = (List)RestResponseHelper.extractData((RestResponse)this.orderAuditExtQueryApi.queryList(orderNos));
                for (OrderRespDto orderRespDto : orderRespDtoList) {
                    Map<String, String> addressMap;
                    OrganizationDto organizationDto;
                    LOGGER.info("\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderRespDto));
                    String placeUserId = orderRespDto.getPlaceUserId();
                    InfoRespDto infoRespDto = new InfoRespDto();
                    if (ObjectUtils.isNotEmpty((Object)orderRespDto.getOrganizationId()) && ObjectUtils.isNotEmpty((Object)(organizationDto = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryById(orderRespDto.getOrganizationId(), ""))))) {
                        infoRespDto.setOrgId(organizationDto.getCode());
                        infoRespDto.setSupplierId(organizationDto.getCode());
                    }
                    String customerId = orderRespDto.getCustomerId();
                    CustomerRespDto customerRespDto = (CustomerRespDto)this.customerQueryApi.queryById(Long.valueOf(customerId)).getData();
                    infoRespDto.setId(String.valueOf(orderRespDto.getId()));
                    infoRespDto.setApplyerId(orderRespDto.getUserId());
                    infoRespDto.setNo(orderRespDto.getOrderNo());
                    infoRespDto.setOrgName(orderRespDto.getOrganizationName());
                    infoRespDto.setOrderStatus(orderRespDto.getOrderTradeStatus());
                    infoRespDto.setCreateDt(orderRespDto.getCreateTime());
                    infoRespDto.setRemark(orderRespDto.getBuyerRemark());
                    if (orderRespDto.getDeliveryType() != null && OrderDeliveryTypeEnum.FACTORY.getType().equals(orderRespDto.getDeliveryType())) {
                        infoRespDto.setOrderTypeCode("DISTRIBUTION_ORDER");
                    } else {
                        infoRespDto.setOrderTypeCode("NORMAL_ORDER");
                    }
                    infoRespDto.setDeliveryCode(orderRespDto.getDeliveryType() != null ? String.valueOf(orderRespDto.getDeliveryType()) : null);
                    UserDto userDto = (UserDto)this.userQueryApi.queryById(Long.valueOf(placeUserId), "{}").getData();
                    infoRespDto.setSalesman(userDto.getUserName());
                    infoRespDto.setSalesmanName(userDto.getNickName());
                    infoRespDto.setSaleDistribution(orderRespDto.getSaleChannel());
                    infoRespDto.setNature("1");
                    if (StringUtils.isNotBlank((CharSequence)orderRespDto.getDeliveryAddress()) && ObjectUtils.isNotEmpty(addressMap = JSONObject.parseObject((String)orderRespDto.getDeliveryAddress()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue()))))) {
                        String address = addressMap.get("address") + "\uff0c" + addressMap.get("deliveryName") + "\uff0c" + addressMap.get("deliveryMobile");
                        infoRespDto.setShippingAddress(address);
                        infoRespDto.setContacts(addressMap.get("deliveryName"));
                        infoRespDto.setPhone(addressMap.get("deliveryMobile"));
                    }
                    infoRespDto.setDisApplyerId(orderRespDto.getShopId());
                    infoRespDto.setQuantity(orderRespDto.getTotalItemNum());
                    infoRespDto.setTotalMoney(orderRespDto.getPayAmount());
                    infoRespDto.setNetDiscountTotalMoney(orderRespDto.getShopDiscountAmount());
                    infoRespDto.setOrderDt(sdf.format(orderRespDto.getPlaceTime()));
                    infoRespDto.setApproveDt(infoRespDto.getOrderDt());
                    orderAuditList.forEach(orderAudit -> {
                        if (orderAudit.getTradeNo().equals(orderRespDto.getOrderNo()) && ObjectUtils.isNotEmpty((Object)orderAudit.getBusinessAudit()) && ObjectUtils.isNotEmpty((Object)orderAudit.getBusinessAudit().getAuditTime())) {
                            infoRespDto.setApproveDt(sdf.format(orderAudit.getBusinessAudit().getAuditTime()));
                        }
                        if (orderAudit.getTradeNo().equals(orderRespDto.getOrderNo()) && ObjectUtils.isNotEmpty((Object)orderAudit.getFinanceAudit()) && ObjectUtils.isNotEmpty((Object)orderAudit.getFinanceAudit().getAuditTime())) {
                            infoRespDto.setFinanceApproveDt(sdf.format(orderAudit.getFinanceAudit().getAuditTime()));
                        }
                    });
                    infoRespDto.setLastUpdateDt(sdf.format(orderRespDto.getUpdateTime()));
                    if (customerRespDto != null) {
                        infoRespDto.setPartnerName(customerRespDto.getName());
                    }
                    infoRespDto.setOrgName(orderRespDto.getOrganizationName());
                    Map<String, String> customerMap = this.queryClientAppNo(orderRespDto.getCustomerId());
                    infoRespDto.setClientAppNo(customerMap.get("clientAppNo"));
                    infoRespDto.setClientAppCode(customerMap.get("clientAppCode"));
                    infoRespDto.setSigningCompany(customerMap.get("signingCompany"));
                    infoRespDtoList.add(infoRespDto);
                }
                result.setInfos(infoRespDtoList);
            }
        }
        if ("2".equals(dto.getNature())) {
            LOGGER.info("\u67e5\u8be2\u9000\u8ba2\u5355\u8be6\u60c5");
            RestResponse returnRespDtoRest = this.afterSalesQueryApi.queryReturnByPage(this.queryCondition(dto), Integer.valueOf(Integer.parseInt(dto.getPage())), Integer.valueOf(10));
            LOGGER.info("returnRespDtoRest={}", (Object)JSONObject.toJSONString((Object)returnRespDtoRest));
            result.setPage(String.valueOf(((PageInfo)returnRespDtoRest.getData()).getPageNum()));
            result.setPageAll(String.valueOf(((PageInfo)returnRespDtoRest.getData()).getPages()));
            result.setSize(String.valueOf(((PageInfo)returnRespDtoRest.getData()).getSize()));
            result.setSizeAll(String.valueOf(((PageInfo)returnRespDtoRest.getData()).getTotal()));
            result.setSizeShow(String.valueOf(((PageInfo)returnRespDtoRest.getData()).getPageSize()));
            infoRespDtoList = new ArrayList();
            List returnRespDtoList = ((PageInfo)returnRespDtoRest.getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)returnRespDtoList)) {
                orderNos = returnRespDtoList.stream().map(ReturnRespDto::getReturnNo).collect(Collectors.toList());
                orderAuditList = (List)RestResponseHelper.extractData((RestResponse)this.orderAuditExtQueryApi.queryList(orderNos));
                for (ReturnRespDto returnRespDto : returnRespDtoList) {
                    OrganizationDto organizationDto;
                    InfoRespDto infoRespDto = new InfoRespDto();
                    if (ObjectUtils.isNotEmpty((Object)returnRespDto.getOrganizationId()) && ObjectUtils.isNotEmpty((Object)(organizationDto = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryById(returnRespDto.getOrganizationId(), ""))))) {
                        infoRespDto.setOrgId(organizationDto.getCode());
                        infoRespDto.setSupplierId(organizationDto.getCode());
                    }
                    String customerId = returnRespDto.getCustomerId();
                    CustomerRespDto customerRespDto = (CustomerRespDto)this.customerQueryApi.queryById(Long.valueOf(customerId)).getData();
                    infoRespDto.setId(String.valueOf(returnRespDto.getId()));
                    infoRespDto.setApplyerId(returnRespDto.getUserId());
                    infoRespDto.setNo(returnRespDto.getReturnNo());
                    infoRespDto.setOrderStatus(returnRespDto.getReturnStatus());
                    infoRespDto.setCreateDt(returnRespDto.getCreateTime());
                    infoRespDto.setNature("2");
                    infoRespDto.setDisApplyerId(returnRespDto.getShopId());
                    infoRespDto.setQuantity(returnRespDto.getTotalItemNum());
                    infoRespDto.setTotalMoney(returnRespDto.getRefundAmount());
                    orderAuditList.forEach(orderAudit -> {
                        if (orderAudit.getTradeNo().equals(returnRespDto.getReturnNo()) && ObjectUtils.isNotEmpty((Object)orderAudit.getBusinessAudit()) && ObjectUtils.isNotEmpty((Object)orderAudit.getBusinessAudit().getAuditTime())) {
                            infoRespDto.setApproveDt(sdf.format(orderAudit.getBusinessAudit().getAuditTime()));
                        }
                    });
                    infoRespDto.setLastUpdateDt(sdf.format(returnRespDto.getUpdateTime()));
                    if (customerRespDto != null) {
                        infoRespDto.setPartnerName(customerRespDto.getName());
                    }
                    infoRespDto.setOrgName(returnRespDto.getOrganizationName());
                    Map<String, String> customerMap = this.queryClientAppNo(returnRespDto.getCustomerId());
                    infoRespDto.setClientAppNo(customerMap.get("clientAppNo"));
                    infoRespDto.setClientAppCode(customerMap.get("clientAppCode"));
                    infoRespDto.setSigningCompany(customerMap.get("signingCompany"));
                    infoRespDtoList.add(infoRespDto);
                }
                result.setInfos(infoRespDtoList);
            }
        }
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        resultMap.put("data", result);
        resultMap.put("code", 0);
        LOGGER.info("\u8fd4\u56de\u7ed9\u8425\u9500\u4e91 \u8ba2\u5355\u8868\u5934\u6570\u636e:{}", (Object)JSON.toJSONString(resultMap));
        return resultMap;
    }

    @Override
    public Map<String, Object> orderHonourAgreementDetail(OrderHonourAgreementDetailReqDto dto) {
        OrderHonourAgreementDetailRespDto result = new OrderHonourAgreementDetailRespDto();
        LOGGER.info("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec6\u5165\u53c2:{}", (Object)JacksonUtil.toJson((Object)dto));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("seq", null);
        resultMap.put("message", "");
        if (StringUtils.isEmpty((CharSequence)dto.getYwId())) {
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
            result.setTips(new String[]{"\u4e1a\u52a1ID(ywId)\u4e0d\u80fd\u4e3a\u7a7a"});
            resultMap.put("data", result);
            resultMap.put("code", 1);
            return resultMap;
        }
        RestResponse orderDetail = this.orderBizQueryApi.getOrderDetail(dto.getYwId());
        OrderDetailRespDto orderDetailData = (OrderDetailRespDto)orderDetail.getData();
        if (orderDetailData == null) {
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
            result.setTips(new String[]{"\u6839\u636e\u4e1a\u52a1ID(ywId)\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u8be6\u60c5"});
            resultMap.put("data", result);
            resultMap.put("code", 1);
            return resultMap;
        }
        LOGGER.info("\u6839\u636e\u4e1a\u52a1ID\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5:{}", (Object)JacksonUtil.toJson((Object)orderDetail));
        result.setShopId(orderDetailData.getShopId());
        result.setRemark(orderDetailData.getBuyerRemark());
        result.setOrderAddress(this.getOrderAddress(orderDetailData.getOrderAddress()));
        HashMap<String, OrderActivityDto> activityMap = new HashMap<String, OrderActivityDto>();
        if (CollectionUtils.isNotEmpty((Collection)orderDetailData.getActivityList())) {
            ArrayList<OrderActivityDto> OrderActivityDtoList = new ArrayList<OrderActivityDto>();
            for (OrderActivityRespDto orderActivityRespDto : orderDetailData.getActivityList()) {
                OrderActivityDto orderActivityDto = new OrderActivityDto();
                orderActivityDto.setActivityId(orderActivityRespDto.getActivityId());
                orderActivityDto.setActivityName(orderActivityRespDto.getActivityName());
                RestResponse activityRespDtoRestResponse = this.activityQueryApi.queryActivityDetail(Long.parseLong(orderActivityRespDto.getActivityId()));
                orderActivityDto.setRemark(activityRespDtoRestResponse.getData() != null ? ((ActivityRespDto)activityRespDtoRestResponse.getData()).getRemark() : "");
                OrderActivityDtoList.add(orderActivityDto);
                activityMap.put(orderActivityRespDto.getActivityId(), orderActivityDto);
            }
            result.setOrderActivitys(OrderActivityDtoList);
        }
        SimpleRequestDto simpleRequestDto = new SimpleRequestDto();
        simpleRequestDto.setCategory(String.valueOf(InOrderCategory.C_101.getCode()));
        simpleRequestDto.setType("101");
        simpleRequestDto.setPreNo(orderDetailData.getOrderNo());
        List inDraOrderRespDtos = (List)this.tcbjReciptApi.inOrderQuery(simpleRequestDto).getData();
        InDraOrderRespDto inDraOrderRespDto = new InDraOrderRespDto();
        if (CollectionUtils.isNotEmpty((Collection)inDraOrderRespDtos)) {
            inDraOrderRespDto = (InDraOrderRespDto)inDraOrderRespDtos.get(0);
        }
        inDraOrderRespDto.setWarehouseCode(orderDetailData.getWarehouseCode());
        List orderItems = orderDetailData.getOrderItems();
        ArrayList<ProductRespDto> productRespDtoList = new ArrayList<ProductRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)orderItems)) {
            List itemList = orderItems.stream().map(item -> item.getItemSerial() != null ? Long.valueOf(item.getItemSerial()) : null).collect(Collectors.toList());
            List<Long> skuIds = orderItems.stream().map(item -> item.getSkuSerial() != null ? Long.valueOf(item.getSkuSerial()) : null).collect(Collectors.toList());
            Map<String, BigDecimal> priceMap = this.getSellerSkuPrice(skuIds, Long.valueOf(orderDetailData.getShopId()), orderDetailData.getCustomerId());
            List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(StringUtils.join(itemList, (String)",")));
            Map<Long, Integer> itemSubTypeMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, ItemRespDto::getSubType, (e1, e2) -> e1));
            for (TradeItemRespDto orderItem : orderItems) {
                String batchNos = orderItem.getBatchNo();
                ProductRespDto productRespDto = new ProductRespDto();
                String activityIds = orderItem.getActivityIds();
                ArrayList<OrderActivityDto> orderItemActivityDtoList = new ArrayList<OrderActivityDto>();
                if (StringUtils.isNotEmpty((CharSequence)activityIds)) {
                    if (activityIds.contains(",")) {
                        Object[] splitIds = activityIds.split(",");
                        List list = Lists.newArrayList((Object[])splitIds).stream().distinct().collect(Collectors.toList());
                        for (String activityId : list) {
                            OrderActivityDto activityDto = (OrderActivityDto)activityMap.get(activityId);
                            if (activityDto == null) continue;
                            orderItemActivityDtoList.add(activityDto);
                        }
                    } else {
                        OrderActivityDto activityDto = (OrderActivityDto)activityMap.get(activityIds);
                        if (activityDto != null) {
                            orderItemActivityDtoList.add(activityDto);
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)batchNos) && batchNos.contains(",")) {
                    String[] splitBatchNos;
                    for (String batchNo : splitBatchNos = batchNos.split(",")) {
                        productRespDto = this.addItemProductList(orderItem, batchNo, inDraOrderRespDto, priceMap, itemSubTypeMap);
                        productRespDto.setOrderItemActivityDtoList(orderItemActivityDtoList);
                        productRespDtoList.add(productRespDto);
                    }
                    continue;
                }
                productRespDto = this.addItemProductList(orderItem, batchNos, inDraOrderRespDto, priceMap, itemSubTypeMap);
                productRespDto.setOrderItemActivityDtoList(orderItemActivityDtoList);
                productRespDtoList.add(productRespDto);
            }
            this.AfterProcessParseItemSubRel(productRespDtoList);
            result.setProducts(productRespDtoList);
        }
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        resultMap.put("data", result);
        resultMap.put("code", 0);
        LOGGER.info("\u8fd4\u56de\u7ed9\u8425\u9500\u4e91 \u8ba2\u5355\u660e\u7ec6\u6570\u636e:{}", (Object)JSON.toJSONString(resultMap));
        return resultMap;
    }

    private void AfterProcessParseItemSubRel(List<ProductRespDto> itemList) {
        LOGGER.info("\u83b7\u53d6\u4ea7\u54c1\u793c\u76d2\u4fe1\u606f\uff1a{} .", (Object)JSON.toJSONString(itemList));
        if (CollectionUtils.isNotEmpty(itemList)) {
            List ParseSubItemReqList = itemList.stream().map(c -> {
                ParseSubItemReq parseSubItemReq = new ParseSubItemReq();
                parseSubItemReq.setCargoCode(c.getEasNo());
                parseSubItemReq.setBatch(c.getBatchNum());
                parseSubItemReq.setIsGift(YesNoEnum.YES.getValue());
                return parseSubItemReq;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ParseSubItemReqList)) {
                return;
            }
            SubItemRelationReqDto subItemRelationReqDto = new SubItemRelationReqDto();
            subItemRelationReqDto.setReqList(ParseSubItemReqList);
            LOGGER.info("\u67e5\u8be2\u4ea7\u54c1\u5173\u8054\u5b50\u6279\u6b21 rep : {} .", (Object)JSON.toJSONString((Object)subItemRelationReqDto));
            SubItemRelationRespDto subItemRelationRespDto = (SubItemRelationRespDto)RestResponseHelper.extractData((RestResponse)this.inventorySubItemQueryApi.querySubItemRelation(subItemRelationReqDto));
            Map subItemRelation = Optional.of(subItemRelationRespDto.getSubItemRelationList()).orElse(Maps.newHashMap());
            itemList.forEach(c -> {
                ArrayList subItemRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)subItemRespDtos, (Collection)subItemRelation.getOrDefault(c.getEasNo() + c.getBatchNum(), Lists.newArrayList()), SubItemRespDto.class);
                c.setSubItems((List)subItemRespDtos);
            });
        }
    }

    private OrderAddressRespDto getOrderAddress(OrderAddressRespDto orderAddressRespDto) {
        OrderAddressRespDto orderAddress = new OrderAddressRespDto();
        if (orderAddressRespDto == null) {
            return orderAddress;
        }
        orderAddress.setOrderNo(orderAddressRespDto.getOrderNo());
        orderAddress.setDeliveryMobile(orderAddressRespDto.getDeliveryMobile());
        orderAddress.setDeliveryPhone(orderAddressRespDto.getDeliveryPhone());
        orderAddress.setDeliveryName(orderAddressRespDto.getDeliveryName());
        return orderAddress;
    }

    private ProductRespDto addItemProductList(TradeItemRespDto orderItem, String batchNo, InDraOrderRespDto inDraOrderRespDto, Map<String, BigDecimal> priceMap, Map<Long, Integer> itemSubTypeMap) {
        ProductRespDto productRespDto = new ProductRespDto();
        productRespDto.setEasNo(orderItem.getSkuCode());
        productRespDto.setProductId(orderItem.getItemSerial());
        productRespDto.setProductName(orderItem.getItemName());
        productRespDto.setProductNo(orderItem.getItemCode());
        productRespDto.setSpec(orderItem.getSkuDesc());
        productRespDto.setUnitCode(orderItem.getUnit());
        BigDecimal costRetailPrice = priceMap.get(PriceTypeEnum.RETAIL_PRICE.getTypeId() + "_" + orderItem.getSkuSerial());
        BigDecimal dealerRetailPrice = priceMap.get(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId() + "_" + orderItem.getSkuSerial());
        if (costRetailPrice != null) {
            productRespDto.setBasePrice(costRetailPrice);
        }
        if (dealerRetailPrice != null) {
            productRespDto.setDealerRetailPrice(dealerRetailPrice);
        }
        productRespDto.setPrice(orderItem.getItemMarketPrice());
        if (StringUtils.isNotEmpty((CharSequence)batchNo)) {
            String[] splitNum = batchNo.split("#");
            productRespDto.setQuantity(Integer.valueOf(splitNum[1]));
            productRespDto.setBatchNum(splitNum[0]);
        }
        if (productRespDto.getQuantity() == null || productRespDto.getQuantity() <= 0) {
            productRespDto.setQuantity(orderItem.getItemNum());
        }
        productRespDto.setActQuantity(orderItem.getItemNum());
        productRespDto.setMoney(orderItem.getPayTotalAmount());
        productRespDto.setType(String.valueOf(orderItem.getItemType()));
        productRespDto.setIsFree(String.valueOf(orderItem.getGift()));
        BigDecimal rebateAmount = Optional.ofNullable(orderItem.getRebateAmount()).orElse(BigDecimal.ZERO);
        productRespDto.setDiscountAmount(Double.valueOf(rebateAmount.doubleValue()));
        productRespDto.setDiscountMoney(Double.valueOf(orderItem.getPayTotalAmount().doubleValue()));
        productRespDto.setDiscountPrice(orderItem.getPayTotalAmount().divide(BigDecimal.valueOf(orderItem.getItemNum().intValue()), 2, RoundingMode.HALF_UP));
        productRespDto.setId(String.valueOf(orderItem.getId()));
        productRespDto.setExtNo(this.queryExtNo(orderItem.getShopId(), orderItem.getSkuSerial()));
        if (inDraOrderRespDto != null && StringUtils.isNotEmpty((CharSequence)productRespDto.getBatchNum())) {
            CargoStorageDto cargoStorageDto = new CargoStorageDto();
            cargoStorageDto.setWarehouseId(inDraOrderRespDto.getWarehouseId());
            cargoStorageDto.setWarehouseCode(inDraOrderRespDto.getWarehouseCode());
            cargoStorageDto.setCargoCode(orderItem.getSkuCode());
            cargoStorageDto.setBatch(productRespDto.getBatchNum());
            cargoStorageDto.setPageNum(Integer.valueOf(1));
            cargoStorageDto.setPageSize(Integer.valueOf(1));
            List cargoStorageDtoList = ((PageInfo)this.tcbjInventoryApi.queryCargoStorage(cargoStorageDto).getData()).getList();
            if (CollectionUtils.isNotEmpty((Collection)cargoStorageDtoList)) {
                CargoStorageDto storageDto = (CargoStorageDto)cargoStorageDtoList.get(0);
                productRespDto.setPactDate(storageDto.getProduceTime());
                productRespDto.setGiveDate(storageDto.getExpireTime());
            }
        }
        productRespDto.setAddAmount(orderItem.getAddAmount());
        productRespDto.setGiftDeduction(orderItem.getGiftDeduction());
        productRespDto.setSubType(StringUtils.isNumeric((CharSequence)orderItem.getItemSerial()) ? itemSubTypeMap.get(Long.valueOf(orderItem.getItemSerial())) : null);
        return productRespDto;
    }

    private Map<String, BigDecimal> getSellerSkuPrice(List<Long> skuIds, Long shopId, String customerId) {
        ArrayList<ItemSkuPriceConditionQueryReqDto> shopConditionList = new ArrayList<ItemSkuPriceConditionQueryReqDto>();
        for (Long skuId : skuIds) {
            ItemSkuPriceConditionQueryReqDto skuPriceConditionReqDto = new ItemSkuPriceConditionQueryReqDto();
            skuPriceConditionReqDto.setSkuId(skuId);
            skuPriceConditionReqDto.setShopId(shopId);
            shopConditionList.add(skuPriceConditionReqDto);
        }
        ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
        itemSkuPriceQueryReqDto.setShopConditionList(shopConditionList);
        List skuPriceQueryRespList = (List)RestResponseHelper.extractData((RestResponse)this.basePriceItemQueryApi.queryRetailSkuPrice(itemSkuPriceQueryReqDto));
        LOGGER.info("[\u67e5\u8be2\u4ef7\u683c\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)skuPriceQueryRespList));
        HashMap priceMap = Maps.newHashMap();
        for (ItemSkuPriceQueryRespDto itemSkuPriceQueryRespDto : skuPriceQueryRespList) {
            if (itemSkuPriceQueryRespDto.getCostRetailPrice() != null) {
                priceMap.put(PriceTypeEnum.RETAIL_PRICE.getTypeId() + "_" + itemSkuPriceQueryRespDto.getSkuId(), itemSkuPriceQueryRespDto.getCostRetailPrice());
            }
            if (itemSkuPriceQueryRespDto.getDealerRetailPrice() == null) continue;
            priceMap.put(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId() + "_" + itemSkuPriceQueryRespDto.getSkuId(), itemSkuPriceQueryRespDto.getDealerRetailPrice());
        }
        return priceMap;
    }

    @Override
    public Map<String, Object> orderHonourAgreementReturnDetail(OrderHonourAgreementDetailReqDto dto) {
        OrderHonourAgreementReturnDetailRespDto result = new OrderHonourAgreementReturnDetailRespDto();
        LOGGER.info("\u67e5\u8be2\u9000\u8ba2\u5355\u660e\u7ec6\u5165\u53c2:{}", (Object)JacksonUtil.toJson((Object)dto));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("seq", null);
        resultMap.put("message", "");
        if (StringUtils.isEmpty((CharSequence)dto.getYwId())) {
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
            result.setTips(new String[]{"\u4e1a\u52a1ID(ywId)\u4e0d\u80fd\u4e3a\u7a7a"});
            resultMap.put("data", result);
            resultMap.put("code", 1);
            return resultMap;
        }
        String filter = "";
        RestResponse returnDetail = this.afterSalesQueryApi.queryReturnDetail(dto.getYwId(), filter);
        if (returnDetail.getData() == null) {
            result.setMessage("\u67e5\u8be2\u5931\u8d25");
            result.setTips(new String[]{"\u6839\u636e\u4e1a\u52a1ID(ywId)\u672a\u67e5\u8be2\u5230\u9000\u8ba2\u5355\u8be6\u60c5"});
            resultMap.put("data", result);
            resultMap.put("code", 1);
            return resultMap;
        }
        LOGGER.info("\u6839\u636e\u4e1a\u52a1ID\u67e5\u8be2\u9000\u8ba2\u5355\u8be6\u60c5:{}", (Object)JacksonUtil.toJson((Object)returnDetail));
        ReturnDetailRespDto returnDetailDto = (ReturnDetailRespDto)returnDetail.getData();
        result.setTradeNo(returnDetailDto.getTradeNo());
        result.setRemark(returnDetailDto.getRemark());
        result.setBuyerAddrInfo(returnDetailDto.getBuyerAddrInfo());
        List returnApplyItems = ((ReturnDetailRespDto)returnDetail.getData()).getApplyReturnItemRespDtoList();
        ArrayList<ProductRespDto> returnApplyproductList = new ArrayList<ProductRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)returnApplyItems)) {
            for (ApplyReturnItemRespDto returnOmniItem : returnApplyItems) {
                ProductRespDto productRespDto = new ProductRespDto();
                productRespDto.setProductId(returnOmniItem.getItemId());
                productRespDto.setProductName(returnOmniItem.getItemName());
                productRespDto.setProductNo(returnOmniItem.getItemCode());
                productRespDto.setSpec(returnOmniItem.getSkuDesc());
                productRespDto.setUnitCode(returnOmniItem.getUnitName());
                productRespDto.setBasePrice(returnOmniItem.getItemOrigPrice());
                productRespDto.setPrice(returnOmniItem.getItemMarketPrice());
                productRespDto.setQuantity(returnOmniItem.getItemNum());
                productRespDto.setMoney(returnOmniItem.getRefundAmount());
                productRespDto.setIsFree(String.valueOf(returnOmniItem.getGift()));
                productRespDto.setExtNo(this.queryExtNo(returnOmniItem.getShopId(), returnOmniItem.getSkuSerial()));
                returnApplyproductList.add(productRespDto);
            }
            result.setApplyProducts(returnApplyproductList);
        }
        List returnOmniItems = ((ReturnDetailRespDto)returnDetail.getData()).getReturnOmniItemRespDtoList();
        ArrayList<ProductRespDto> productRespDtoList = new ArrayList<ProductRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)returnOmniItems)) {
            for (ReturnOmniItemRespDto returnOmniItem : returnOmniItems) {
                ProductRespDto productRespDto = new ProductRespDto();
                productRespDto.setProductId(returnOmniItem.getItemId());
                productRespDto.setProductName(returnOmniItem.getItemName());
                productRespDto.setProductNo(returnOmniItem.getItemCode());
                productRespDto.setSpec(returnOmniItem.getSkuDesc());
                productRespDto.setBasePrice(returnOmniItem.getItemOrigPrice());
                productRespDto.setPrice(returnOmniItem.getItemMarketPrice());
                productRespDto.setQuantity(returnOmniItem.getItemNum());
                productRespDto.setMoney(returnOmniItem.getPayTotalAmount());
                productRespDto.setIsFree(String.valueOf(returnOmniItem.getGift()));
                productRespDto.setExtNo(this.queryExtNo(returnOmniItem.getShopId(), returnOmniItem.getSkuSerial()));
                productRespDto.setBatchNum(returnOmniItem.getBatchNo());
                productRespDtoList.add(productRespDto);
            }
            result.setRealProducts(productRespDtoList);
        }
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        resultMap.put("data", result);
        resultMap.put("code", 0);
        LOGGER.info("\u8fd4\u56de\u7ed9\u8425\u9500\u4e91 \u9000\u8ba2\u5355\u660e\u7ec6\u6570\u636e:{}", (Object)JSON.toJSONString(resultMap));
        return resultMap;
    }

    private String queryExtNo(String shopId, String skuId) {
        String extNo = null;
        ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
        itemAuthReqDto.setTargetType(Integer.valueOf(2));
        if (StringUtils.isEmpty((CharSequence)shopId)) {
            LOGGER.debug("\u5e97\u94faid\u4e3a\u7a7a");
            return "";
        }
        itemAuthReqDto.setTargetIdList((List)Lists.newArrayList((Object[])new Long[]{Long.valueOf(shopId)}));
        itemAuthReqDto.setStatus(Integer.valueOf(1));
        itemAuthReqDto.setBusinessId(Long.valueOf(skuId));
        RestResponse listRestResponse = this.itemAuthQueryApi.queryByTargetIds(itemAuthReqDto);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)listRestResponse.getData()))) {
            extNo = ((ItemAuthRespDto)((List)listRestResponse.getData()).get(0)).getExternalCode();
        }
        return extNo;
    }

    private Map<String, String> queryClientAppNo(String customerId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String clientAppNo = null;
        String signingCompany = null;
        RestResponse customerRespDtoRestResponse = this.customerQueryApi.queryById(Long.valueOf(customerId));
        if (customerRespDtoRestResponse.getData() != null) {
            clientAppNo = ((CustomerRespDto)customerRespDtoRestResponse.getData()).getEasCode();
            signingCompany = ((CustomerRespDto)customerRespDtoRestResponse.getData()).getSigningCompany();
            Long orgInfoId = ((CustomerRespDto)customerRespDtoRestResponse.getData()).getOrgInfoId();
            OrganizationDto organizationDto = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryById(orgInfoId, ""));
            String code = organizationDto != null ? organizationDto.getCode() : null;
            map.put("clientAppCode", code);
        }
        map.put("clientAppNo", clientAppNo);
        map.put("signingCompany", signingCompany);
        return map;
    }

    private String queryCondition(OrderHonourAgreementHeaderReqDto dto) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("organizationId", dto.getOrgId());
        filter.put("id", dto.getId());
        filter.put("sellerId", dto.getSupplierId());
        filter.put("createTime", dto.getCreateDt());
        filter.put("saleChannel", dto.getSaleDistribution());
        filter.put("shopId", dto.getDisApplyerId());
        filter.put("instanceId", String.valueOf(this.requestBaseData.getInstanceId()));
        filter.put("tenantId", String.valueOf(this.requestBaseData.getTenantId()));
        if ("1".equals(dto.getNature())) {
            filter.put("dataType", "2");
            filter.put("orderNo", dto.getNo());
            filter.put("orderTradeStatus", dto.getOrderStatus());
            filter.put("startTime", dto.getLastStartDt());
            filter.put("endTime", dto.getLastEndDt());
        }
        if ("2".equals(dto.getNature())) {
            filter.put("refundNo", dto.getNo());
            filter.put("returnStatus", dto.getOrderStatus());
            filter.put("returnTimeStart", dto.getLastStartDt());
            filter.put("returnTimeEnd", dto.getLastEndDt());
        }
        LOGGER.info("\u5c01\u88c5\u67e5\u8be2\u6761\u4ef6:{}", (Object)JSON.toJSONString(filter));
        return JSON.toJSONString(filter);
    }

    @Override
    public Map<String, Object> orderInfo(OrderInfoReqDto dto) {
        OrderInfoRespDto orderInfoRespDto;
        ArrayList<OrderInfoRespDto> result = new ArrayList<OrderInfoRespDto>();
        LOGGER.info("\u67e5\u8be2\u8ba2\u5355MQ\u4fe1\u606f\u5165\u53c2:{}", (Object)JacksonUtil.toJson((Object)dto));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("seq", null);
        resultMap.put("message", "");
        if (StringUtils.isEmpty((CharSequence)dto.getStartDate()) && StringUtils.isEmpty((CharSequence)dto.getEndDate()) && CollectionUtils.isEmpty((Collection)dto.getOrderNos())) {
            LOGGER.info("\u5fc5\u586b\u7684\u53c2\u6570\u90fd\u4e3a\u7a7a");
            return resultMap;
        }
        HashMap<String, Object> filter = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartDate())) {
            filter.put("placeStartTime", dto.getStartDate());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getEndDate())) {
            filter.put("placeEndTime", dto.getEndDate() + " 23:59:59");
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getOrderNos())) {
            filter.put("tradeNos", dto.getOrderNos());
        }
        filter.put("instanceId", this.requestBaseData.getInstanceId());
        filter.put("tenantId", this.requestBaseData.getTenantId());
        filter.put("orderTradeStatus", "WAIT_OUT_STORAGE");
        RestResponse orderRespDtoRest = this.orderQueryApi.queryByPage(JSON.toJSONString(filter), Integer.valueOf(1), Integer.valueOf(100));
        ArrayList<String> orderNos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)orderRespDtoRest.getData()).getList())) {
            orderNos = ((PageInfo)orderRespDtoRest.getData()).getList().stream().map(OrderRespDto::getOrderNo).collect(Collectors.toList());
        }
        HashMap<String, Object> returnFilter = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartDate())) {
            returnFilter.put("placeStartTime", dto.getStartDate());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getEndDate())) {
            returnFilter.put("placeEndTime", dto.getEndDate() + " 23:59:59");
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getOrderNos())) {
            returnFilter.put("orderTradeNos", dto.getOrderNos());
        }
        returnFilter.put("instanceId", this.requestBaseData.getInstanceId());
        returnFilter.put("tenantId", this.requestBaseData.getTenantId());
        returnFilter.put("returnStatus", "WAIT_IN_STORAGE");
        RestResponse returnRespDtoRest = this.afterSalesQueryApi.queryReturnByPage(JSON.toJSONString(returnFilter), Integer.valueOf(1), Integer.valueOf(100));
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)returnRespDtoRest.getData()).getList())) {
            List returnOrderNos = ((PageInfo)returnRespDtoRest.getData()).getList().stream().map(ReturnRespDto::getReturnNo).collect(Collectors.toList());
            orderNos.addAll(returnOrderNos);
        }
        Map<String, Long> messageKeyMap = this.queryMessageKeyByNo(orderNos);
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)orderRespDtoRest.getData()).getList())) {
            for (OrderRespDto orderRespDto : ((PageInfo)orderRespDtoRest.getData()).getList()) {
                orderInfoRespDto = new OrderInfoRespDto();
                orderInfoRespDto.setOrderId(orderRespDto.getOrderNo());
                orderInfoRespDto.setMessageId(messageKeyMap.get(orderRespDto.getOrderNo() + "-1") != null ? String.valueOf(messageKeyMap.get(orderRespDto.getOrderNo() + "-1")) : "");
                orderInfoRespDto.setType("1");
                orderInfoRespDto.setMethod("tcbj-saleorder-queue");
                result.add(orderInfoRespDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)returnRespDtoRest.getData()).getList())) {
            for (ReturnRespDto returnRespDto : ((PageInfo)returnRespDtoRest.getData()).getList()) {
                orderInfoRespDto = new OrderInfoRespDto();
                orderInfoRespDto.setOrderId(returnRespDto.getReturnNo());
                orderInfoRespDto.setMessageId(messageKeyMap.get(returnRespDto.getReturnNo() + "-2") != null ? String.valueOf(messageKeyMap.get(returnRespDto.getReturnNo() + "-2")) : "");
                orderInfoRespDto.setType("2");
                orderInfoRespDto.setMethod("tcbj-saleorder-queue");
                result.add(orderInfoRespDto);
            }
        }
        resultMap.put("data", result);
        resultMap.put("code", 0);
        LOGGER.info("\u8fd4\u56de\u7ed9\u8425\u9500\u4e91 \u8ba2\u5355MQ\u4fe1\u606f\u6570\u636e:{}", (Object)JSON.toJSONString(resultMap));
        return resultMap;
    }

    @Override
    public Map<String, Object> reviewSaleReturnInHead(ReviewSaleReturnInHeadReqDto dto) {
        LOGGER.info("\u4e0b\u7ea7\u9000\u8d27\u5165\u5e93\u5ba1\u6838\u5165\u53c2\u4fe1\u606f:{}", (Object)dto);
        String result = "";
        String accessToken = this.marketingCloudService.getToken();
        HashMap<String, String> mapHeaders = new HashMap<String, String>();
        mapHeaders.put("Content-Type", "application/json");
        try {
            result = HttpUtil.post((String)this.marketingCloudConfig.getUrl(ImarketingUrlEnum.SUBSALERETURN_REVIEW.getField() + "?access_token=" + accessToken), (String)JSON.toJSONString((Object)dto), mapHeaders);
            LOGGER.info("\u4e0b\u7ea7\u9000\u8d27\u5165\u5e93\u5ba1\u6838\u54cd\u5e94\u4fe1\u606f:{}", (Object)result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @Override
    public RestResponse<Void> rejectAuditOrder(YXYOrderAuditReqDto yxyOrderAuditReqDto) {
        LOGGER.info("\u4e0b\u7ea7\u9000\u8d27\u5355\u53cd\u5ba1\u6838\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)yxyOrderAuditReqDto));
        ReturnAuditReqDto returnAuditReqDto = new ReturnAuditReqDto();
        returnAuditReqDto.setAuditDesc(yxyOrderAuditReqDto.getAuditDesc());
        returnAuditReqDto.setAuditor(yxyOrderAuditReqDto.getAuditor());
        returnAuditReqDto.setAuditStatus("reject");
        returnAuditReqDto.setAuditTime(new Date());
        returnAuditReqDto.setAuditType(yxyOrderAuditReqDto.getAuditType() + "");
        returnAuditReqDto.setReturnNo(yxyOrderAuditReqDto.getReturnNo());
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)RestResponseHelper.extractData((RestResponse)this.afterSalesQueryApi.queryReturnDetail(yxyOrderAuditReqDto.getReturnNo(), "{}"));
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((returnDetailRespDto != null ? 1 : 0) != 0, (String)"10900", (String)"\u9000\u8d27\u5355\u4e0d\u5b58\u5728");
        RestResponseHelper.extractData((RestResponse)this.afterSalesTobApi.rejectAuditOrder(yxyOrderAuditReqDto.getReturnNo(), returnAuditReqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> returnAuditOrder(YXYOrderAuditReqDto yxyOrderAuditReqDto) {
        LOGGER.info("\u8425\u9500\u4e91\u8fd4\u5ba1\u6838\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)yxyOrderAuditReqDto));
        RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(yxyOrderAuditReqDto.getOrderNo());
        OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        Assert.notNull((Object)orderData, (String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u8ba2\u5355\u8be6\u60c5", (Object[])new Object[0]);
        OrderAuditReqDto orderAuditToBReqDto1 = new OrderAuditReqDto();
        orderAuditToBReqDto1.setOrderTradeStatus("WAIT_CS_AUDIT");
        yxyOrderAuditReqDto.setAuditResult(Integer.valueOf(1));
        this.auditOrder(yxyOrderAuditReqDto, orderAuditToBReqDto1);
        if (1 == yxyOrderAuditReqDto.getAuditResult()) {
            RestResponseHelper.extractData((RestResponse)this.csDeliveryNoticeOrderApi.updateOrderStatus(yxyOrderAuditReqDto.getOrderNo(), CsDocumentActionEnum.REVERSE_AUDIT.getCode()));
        }
        return RestResponse.VOID;
    }

    private void auditOrder(YXYOrderAuditReqDto orderAuditToBReqDto, OrderAuditReqDto orderAuditToBReqDto1) {
        orderAuditToBReqDto1.setAuditDesc(orderAuditToBReqDto.getAuditDesc());
        orderAuditToBReqDto1.setAuditor(orderAuditToBReqDto.getAuditor());
        orderAuditToBReqDto1.setAuditResult(orderAuditToBReqDto.getAuditResult());
        orderAuditToBReqDto1.setAuditType(orderAuditToBReqDto.getAuditType() + "");
        orderAuditToBReqDto1.setFlowDefId(Long.valueOf(0L));
        orderAuditToBReqDto1.setOrderFlowName("ORDER_TOB");
        orderAuditToBReqDto1.setOrderTradeStatus(orderAuditToBReqDto1.getOrderTradeStatus());
        HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
        stringStringHashMap.put("auditStatus", 1 == orderAuditToBReqDto.getAuditResult() ? "pass" : "reject");
        orderAuditToBReqDto1.setExtFields(stringStringHashMap);
        orderAuditToBReqDto1.setTradeNo(orderAuditToBReqDto.getOrderNo());
        RestResponseHelper.extractData((RestResponse)this.orderBizApi.auditOrder(orderAuditToBReqDto.getOrderNo(), orderAuditToBReqDto1));
    }

    public Map<String, Long> queryMessageKeyByNo(List<String> orderNos) {
        RestResponse mqMessageRespDtoRest = this.mqMessageQueryApi.queryByNo(orderNos);
        HashMap<String, Long> map = CollectionUtils.isNotEmpty((Collection)((Collection)mqMessageRespDtoRest.getData())) ? ((List)mqMessageRespDtoRest.getData()).stream().collect(Collectors.toMap(e -> e.getNo() + "-" + e.getType(), MqMessageRespDto::getId, (last, next) -> next)) : new HashMap<String, Long>();
        return map;
    }

    @Override
    public String auditArtificial(OrderReviewDetailsReqDto dto) {
        LOGGER.info("\u4eba\u5de5\u8d22\u5ba1\u5165\u53c2:{}", (Object)JacksonUtil.toJson((Object)dto));
        AuditArtificialResqDto result = new AuditArtificialResqDto();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("seq", null);
        resultMap.put("message", "");
        if (StringUtils.isEmpty((CharSequence)dto.getNo()) || null == dto.getAuditType() || null == dto.getAuditResult()) {
            result.setMessage("\u64cd\u4f5c\u5931\u8d25");
            result.setTips(new String[]{"\u8ba2\u5355\u53f7\u3001\u5ba1\u6838\u7ed3\u679c\u3001\u5ba1\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"});
            resultMap.put("data", result);
            resultMap.put("code", 1);
            return JSON.toJSONString(resultMap);
        }
        ArrayList orderQueryEnums = Lists.newArrayList((Object[])new OrderQueryEnum[]{OrderQueryEnum.ITEM});
        RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(dto.getNo(), StringUtils.join((Iterable)orderQueryEnums, (String)","));
        OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        this.verifyOrder(dto, orderData);
        MessageVo messageVo = new MessageVo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("no", dto.getNo());
        map.put("orgId", orderData.getOrganizationId());
        map.put("auditType", dto.getAuditType());
        map.put("auditResult", dto.getAuditResult());
        map.put("auditDesc", dto.getAuditDesc());
        messageVo.setData((Object)JacksonUtil.toJson(map));
        LOGGER.info("\u53d1\u9001mq\u7684\u53c2\u6570:{}", (Object)JacksonUtil.toJson(map));
        this.commonsMqService.sendSingleMessageAsync("ORDER-FINANCE-CHECK-TOPIC", "ORDER-FINANCE-CHECK-TAG", (Object)messageVo);
        result.setMessage("\u64cd\u4f5c\u6210\u529f");
        resultMap.put("data", result);
        resultMap.put("code", 0);
        return JSON.toJSONString(resultMap);
    }

    @Override
    public RestResponse<ReturnsQuotaAccountRespDto> salesReturnAmount(SalesReturnAmountReqDto salesReturnAmountReqDto) {
        LOGGER.info("\u3010\u8fdb\u9500\u5b58\u3011\u6839\u636e\u79df\u6237ID\u67e5\u8be2\u5ba2\u6237\u9000\u8d27\u989d\u5ea6 request\uff1a{}", (Object)JSON.toJSONString((Object)salesReturnAmountReqDto));
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApiExt.queryByThirdPartyIds(Arrays.asList(salesReturnAmountReqDto.getTenantId())));
        LOGGER.info("\u3010\u8fdb\u9500\u5b58\u3011\u6839\u636e\u79df\u6237ID\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f response\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDtoList));
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)customerRespDtoList), (String)ReqCodeEnum.NOT_EXIT_RETURNSQUOTAACCOUNT.getCode(), (String)ReqCodeEnum.NOT_EXIT_RETURNSQUOTAACCOUNT.getDesc());
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoList.stream().findFirst().get();
        CustomerRelationRespDto customerRelationRespDto = (CustomerRelationRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryByCustomer(customerRespDto.getId()));
        return this.returnsQuotaAccountQueryApi.queryByCustomerId(customerRelationRespDto.getCusId());
    }

    @Override
    public String createAfterSalesOrder(CreateAfterSalesOrderDto createAfterSalesOrderDto) {
        return this.abstractAfterSaleService.createAfterSalesOrder(createAfterSalesOrderDto);
    }

    private AfterSalesItemReqDto createAfterSalesItemReqDto(Map<String, ItemSkuExtRespDto> itemSkuExtRespDtoMap, Map<String, ItemPolicyPriceRespDto> skuPriceMap, Map<Long, OrderItemExtDto> itemTypeMap, ItemReqDto c, Long shopId) {
        ItemSkuExtRespDto itemSkuExtRespDto = itemSkuExtRespDtoMap.getOrDefault(c.getCargoCode(), null);
        ItemPolicyPriceRespDto orDefault = skuPriceMap.getOrDefault(shopId + "-" + itemSkuExtRespDto.getSkuId(), null);
        OrderItemExtDto orderItemExtDto = itemTypeMap.getOrDefault(itemSkuExtRespDto.getItemId(), null);
        BigDecimal defaultMatchPrice = this.priceRuleHelper.getDefaultMatchPrice(orDefault, c.getChangeInventory().intValue());
        com.dtyunxi.cube.biz.commons.utils.Assert.notNull((Object)itemSkuExtRespDto, (String)ReqCodeEnum.ADDAFTERITAM_ERROR.getCode(), (String)ReqCodeEnum.ADDAFTERITAM_ERROR.getDesc());
        com.dtyunxi.cube.biz.commons.utils.Assert.notNull((Object)orDefault, (String)ReqCodeEnum.ADDAFTERITAM_PRICE_ERROR.getCode(), (String)ReqCodeEnum.ADDAFTERITAM_PRICE_ERROR.getDesc());
        AfterSalesItemReqDto itemReqDto = new AfterSalesItemReqDto();
        itemReqDto.setItemNum(Integer.valueOf(c.getChangeInventory().intValue()));
        itemReqDto.setItemPrice(defaultMatchPrice);
        itemReqDto.setSkuSerial(itemSkuExtRespDto.getSkuId().toString());
        itemReqDto.setItemSerial(itemSkuExtRespDto.getItemId().toString());
        itemReqDto.setItemCode(itemSkuExtRespDto.getItemCode());
        itemReqDto.setBatchNo(c.getBatch() + "#" + c.getChangeInventory());
        itemReqDto.setExtension(JSONObject.toJSONString((Object)orderItemExtDto));
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("returnedNum", 0);
        extFields.put("cargoSerial", itemSkuExtRespDto.getSkuCode());
        extFields.put("returnNum", c.getChangeInventory());
        extFields.put("unit", itemSkuExtRespDto.getUnit());
        extFields.put("itemAmount", BigDecimal.ZERO);
        extFields.put("brandId", itemSkuExtRespDto.getBrandId());
        extFields.put("shopId", shopId);
        extFields.put("itemName", itemSkuExtRespDto.getItemName());
        extFields.put("skuCode", itemSkuExtRespDto.getSkuCode());
        extFields.put("skuDesc", itemSkuExtRespDto.getAttr());
        extFields.put("refundAmount", c.getChangeInventory().multiply(defaultMatchPrice).toString());
        itemReqDto.setExtFields(extFields);
        return itemReqDto;
    }

    @Override
    public void subrtnOrderUnaudit(UnauditReqDto dto) {
        LOGGER.info("\u3010\u8fdb\u9500\u5b58\u3011\u4e8c\u7ea7\u9000\u8d27\u8ba2\u5355\u53cd\u5ba1\u6838\u63a5\u53e3\u5165\u53c2\u4e3a:{}", (Object)JacksonUtil.toJson((Object)dto));
        String accessToken = this.marketingCloudService.getToken();
        String url = this.marketingCloudConfig.getJxcUrl(ImarketingUrlEnum.SUBRTNORDER_UNAUDIT.getField()) + "?access_token=" + accessToken;
        HashMap<String, String> mapHeaders = new HashMap<String, String>();
        mapHeaders.put("Content-Type", "application/json");
        String result = "";
        try {
            result = HttpUtil.post((String)url, (String)JSON.toJSONString((Object)dto), mapHeaders);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("\u3010\u8fdb\u9500\u5b58\u3011\u4e8c\u7ea7\u9000\u8d27\u8ba2\u5355\u53cd\u5ba1\u6838:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{},\u8fd4\u56de\u7684\u63a5\u53e3\u4fe1\u606f\u4e3a:{}", new Object[]{url, JSON.toJSONString((Object)dto), result});
        HttpResponseDto httpResponseDto = (HttpResponseDto)JacksonUtil.readValue((String)result, HttpResponseDto.class);
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)((Boolean)httpResponseDto.getReturnObject()), (String)ReqCodeEnum.SUBRTNORDER_UNAUDIT_CODE.getCode(), (String)ReqCodeEnum.SUBRTNORDER_UNAUDIT_CODE.getDesc());
    }

    @Override
    public Map<String, Object> submitOrder(ErpSubmitOrderReqDto erpSubmitOrderReqDto) {
        LOGGER.info("[ERP\u63d0\u4ea4\u8ba2\u5355\u5165\u53c2]\uff1a{}", (Object)JSON.toJSONString((Object)erpSubmitOrderReqDto));
        String message = "\u64cd\u4f5c\u6210\u529f";
        String code = "0";
        OrderReqDto orderReqDto = this.submitOrderHelper.convertOrderReqDto(erpSubmitOrderReqDto);
        String orderNo = orderReqDto.getOrderNo();
        this.priceHelper.assemblyPrice(orderReqDto);
        try {
            this.storageHelper.subVirStorage(orderReqDto);
            RestResponseHelper.extractData((RestResponse)this.orderApi.addOrderReturnEo(orderReqDto));
            if (Objects.equals("2", orderReqDto.getSubmitType())) {
                try {
                    LOGGER.info("\u4e0b\u5355\u5904\u7406\u5b8c\u6210\u540e\uff0c\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u63a5\u53e3\uff0c\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)orderNo);
                    RestResponse createDeliveryResp = this.csDeliveryNoticeOrderApi.createDeliveryByOrderNo(orderNo);
                    LOGGER.info("\u4e0b\u5355\u5904\u7406\u5b8c\u6210\u540e\uff0c\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u63a5\u53e3\uff0c\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,createDeliveryResp:{}", (Object)createDeliveryResp);
                }
                catch (Exception e) {
                    LOGGER.error("\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5f02\u5e38,e:{}", (Throwable)e);
                }
            }
            this.payHelp.pay(orderReqDto, erpSubmitOrderReqDto.getPayStatus(), erpSubmitOrderReqDto.getPayType());
        }
        catch (Exception e) {
            LOGGER.error("erp\u63d0\u4ea4\u8ba2\u5355\u62a5\u9519\uff1a{}", (Throwable)e);
            if (Objects.equals("2", orderReqDto.getSubmitType())) {
                this.storageHelper.rollbackVirSotrage(orderNo);
            }
            message = e.getMessage();
            code = "10000";
            orderNo = null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("message", message);
        resultMap.put("data", orderNo);
        resultMap.put("code", code);
        return resultMap;
    }

    @Override
    public Map<String, Object> queryCustomerAddress(CustomerAddressReqDto customerAddressReqDto) {
        LOGGER.info("[\u67e5\u8be2\u7ecf\u9500\u5546\u5730\u5740\u5165\u53c2]:{}", (Object)JSON.toJSONString((Object)customerAddressReqDto));
        CustomerRespDto customerRespDto = this.customerHelper.queryCustomerByThirdId(customerAddressReqDto.getPartnerId());
        ErpOrderAssert.notNull(customerRespDto, OrderExceptionEnum.DATA_EXISTS, "\u5ba2\u6237");
        LOGGER.info("[\u67e5\u8be2\u7ecf\u9500\u5546\u5730\u5740],[\u5ba2\u6237\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
        AddressQueryReqDto addressQueryReqDto = new AddressQueryReqDto();
        addressQueryReqDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        addressQueryReqDto.setAddressType("1");
        PageInfo addressPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.addressQueryApi.queryAddressByPage(addressQueryReqDto, Integer.valueOf(1), Integer.valueOf(10000)));
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("message", "\u64cd\u4f5c\u6210\u529f");
        resultMap.put("data", addressPage.getList());
        resultMap.put("code", 0);
        return resultMap;
    }

    @Override
    public void notifyConfirmOrder(NotifyConfirmOrderReqDto dto) {
        LOGGER.info("\u8c03\u7528\u8425\u9500\u4e91\u91c7\u8d2d\u5165\u5e93\u5355\u5ba1\u6838\u63a5\u53e3\u5165\u53c2\u4e3a:{}", (Object)JacksonUtil.toJson((Object)dto));
        String accessToken = this.marketingCloudService.getToken();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("otherNumber", (Object)dto.getOrderNo());
        String params = "?access_token=" + accessToken;
        String url = this.marketingCloudConfig.getJxcUrl(ImarketingUrlEnum.PURINWARE_AUDIT.getField()) + params;
        String result = "";
        HashMap<String, String> mapHeaders = new HashMap<String, String>();
        mapHeaders.put("Content-Type", "application/json");
        try {
            result = HttpUtil.post((String)url, (String)jsonObject.toJSONString(), mapHeaders);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("\u8c03\u7528\u8425\u9500\u4e91\u91c7\u8d2d\u5165\u5e93\u5355\u5ba1\u6838\u8bf7\u6c42\u5730\u5740\u4e3a:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{},\u8fd4\u56de\u7684\u63a5\u53e3\u4fe1\u606f\u4e3a:{}", new Object[]{url, jsonObject.toJSONString(), result});
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)result), (String)"10003", (String)"\u8425\u9500\u4e91\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\u7a7a");
        HttpResponseDto httpResponseDto = (HttpResponseDto)JacksonUtil.readValue((String)result, HttpResponseDto.class);
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)httpResponseDto.getErrorCode().equals("0"), (String)httpResponseDto.getErrorCode(), (String)httpResponseDto.getErrorMessage());
        Boolean returnBool = (Boolean)httpResponseDto.getReturnObject();
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)returnBool, (String)"10004", (String)httpResponseDto.getErrorMessage());
    }

    private void verifyOrder(OrderReviewDetailsReqDto dto, OrderDetailRespDto orderData) {
        boolean useBatch;
        com.dtyunxi.cube.biz.commons.utils.Assert.notNull((Object)orderData, (String)"100022", (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (Objects.equals(dto.getAuditType(), 1) && !OrderBizStatusTobEnum.WAIT_CS_AUDIT.getCode().equals(orderData.getOrderTradeStatus())) {
            throw new BizException("\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u975e\u5f85\u4e1a\u52a1\u5ba1\u6838");
        }
        if (Objects.equals(dto.getAuditType(), 2) && !OrderBizStatusTobEnum.WAIT_FINANCE_AUDIT.getCode().equals(orderData.getOrderTradeStatus())) {
            throw new BizException("\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u975e\u5f85\u8d22\u52a1\u5ba1\u6838");
        }
        List orderItems = orderData.getOrderItems();
        if (CollectionUtils.isEmpty((Collection)orderItems)) {
            throw new BizException("\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        BasicConfigRespDto batchConfig = (BasicConfigRespDto)RestResponseHelper.extractData((RestResponse)this.basicConfigQueryApi.queryConfigByOrgIdAndCode(orderData.getOrganizationId(), BasicConfigEnum.BATCH_NO));
        LOGGER.info("\u4eba\u5de5\u5ba1\u6838-\u6279\u6b21\u53f7\uff0c\u57fa\u7840\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)batchConfig));
        boolean bl = useBatch = batchConfig == null || Objects.equals("1", batchConfig.getValue());
        if (useBatch && Objects.equals(dto.getAuditType(), 2)) {
            orderItems.forEach(orderItem -> {
                if (StringUtils.isEmpty((CharSequence)orderItem.getBatchNo())) {
                    throw new BizException("\u6279\u6b21\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8d22\u52a1\u5ba1\u6838\u901a\u8fc7");
                }
            });
        }
    }

    @Override
    public List<OrganizationCompanyDto> queryCustomerCompany(List<String> thirdPartIds) {
        ArrayList<OrganizationCompanyDto> result;
        block5: {
            result = new ArrayList<OrganizationCompanyDto>();
            if (!CollectionUtils.isNotEmpty(thirdPartIds)) break block5;
            List<CustomerRespDto> customerRespDtos = this.customerHelper.queryCustomersByThirdIds(thirdPartIds);
            OrganizationCompanyDto companyDto = null;
            if (CollectionUtils.isNotEmpty(customerRespDtos)) {
                Map<String, Long> orgPartyMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getThirdPartyId, CustomerRespDto::getOrgInfoId, (e1, e2) -> e1));
                ArrayList orgList = Lists.newArrayList(orgPartyMap.values());
                List orgAndOrgInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)orgList));
                Map compInfoMap = orgAndOrgInfoRespDtos.stream().collect(Collectors.toMap(eo -> eo.getOrganizationDto().getId(), Function.identity()));
                Long orgInfoId = null;
                OrgAndOrgInfoRespDto orgInfoDto = null;
                for (String thirdPartId : thirdPartIds) {
                    companyDto = new OrganizationCompanyDto();
                    companyDto.setId(thirdPartId);
                    orgInfoId = orgPartyMap.get(thirdPartId);
                    if (ObjectUtils.isNotEmpty((Object)orgInfoId) && ObjectUtils.isNotEmpty((Object)(orgInfoDto = (OrgAndOrgInfoRespDto)compInfoMap.get(orgInfoId))) && ObjectUtils.isNotEmpty((Object)orgInfoDto.getOrganizationInfoDto())) {
                        companyDto.setTaxRegistNo(orgInfoDto.getOrganizationInfoDto().getCreditCode());
                        companyDto.setCheckedName(orgInfoDto.getOrganizationInfoDto().getOrgName());
                    }
                    result.add(companyDto);
                }
            } else {
                for (String thirdPartId : thirdPartIds) {
                    companyDto = new OrganizationCompanyDto();
                    companyDto.setId(thirdPartId);
                    result.add(companyDto);
                }
            }
        }
        return result;
    }

    @Override
    public void bindTenantMaterial(TenantMaterialReqDto tenantMaterialReqDto) {
        LOGGER.info("\u79df\u6237\u7ed1\u5b9a\u4ea7\u54c1\u660e\u7ec6 params : {}", (Object)JSON.toJSONString((Object)tenantMaterialReqDto));
        String accessToken = this.marketingCloudService.getToken();
        String url = this.marketingCloudConfig.getJxcUrl(ImarketingUrlEnum.BIND_TENANT_MATERIAL.getField()) + "?access_token=" + accessToken;
        HashMap<String, String> mapHeaders = new HashMap<String, String>();
        mapHeaders.put("Content-Type", "application/json");
        String result = "";
        try {
            result = HttpUtil.post((String)url, (String)JSON.toJSONString((Object)tenantMaterialReqDto), mapHeaders);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("\u3010\u8fdb\u9500\u5b58\u3011\u79df\u6237\u7ed1\u5b9a\u4ea7\u54c1\u660e\u7ec6:{},\u8bf7\u6c42\u53c2\u6570\u4e3a:{},\u8fd4\u56de\u7684\u63a5\u53e3\u4fe1\u606f\u4e3a:{}", new Object[]{url, JSON.toJSONString((Object)tenantMaterialReqDto), result});
        HttpResponseDto httpResponseDto = (HttpResponseDto)JacksonUtil.readValue((String)result, HttpResponseDto.class);
        com.dtyunxi.cube.biz.commons.utils.Assert.isTrue((boolean)httpResponseDto.getErrorCode().equals("0"), (String)httpResponseDto.getErrorCode(), (String)httpResponseDto.getErrorMessage());
    }
}

