/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    @Autowired
    private RestTemplate restTemplate;

    public <T> T httpGet(String url, Map<String, Object> params, Class<T> clazz) {
        return this.httpGet(url, params, null, clazz);
    }

    public <T> T httpGet(String url, Map<String, Object> params, Map<String, Object> header, Class<T> clazz) {
        url = this.generateRequestParameters(url, params);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, clazz, new Object[0]);
        return (T)forEntity.getBody();
    }

    public <T> T httpPost(String url, Map<String, Object> paramsMap, Map<String, Object> jsonMap, Class<T> clazz) {
        return this.httpPost(url, paramsMap, jsonMap, null, clazz);
    }

    public <T> T httpPost(String url, Map<String, Object> jsonMap, Class<T> clazz) {
        return this.httpPost(url, null, jsonMap, null, clazz);
    }

    public <T> T httpPost(String url, Map<String, Object> paramsMap, Map<String, Object> jsonMap, Map<String, Object> header, Class<T> clazz) {
        logger.info("------>HttpPost\uff1a{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{url, JSONObject.toJSONString(paramsMap), JSONObject.toJSONString(jsonMap), JSONObject.toJSONString(header)});
        if (ObjectUtils.isNotEmpty(paramsMap)) {
            url = this.generateRequestParameters(url, paramsMap);
        }
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, this.generatePostJson(jsonMap, header), clazz, new Object[0]);
        logger.info("------>HttpPost\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)forEntity));
        return (T)forEntity.getBody();
    }

    public <T> T httpPost(String url, Map<String, Object> paramsMap, HttpHeaders header, Map<String, Object> jsonMap, Class<T> clazz) {
        logger.info("------>HttpPost\uff1a{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{url, JSONObject.toJSONString(paramsMap), JSONObject.toJSONString(jsonMap), JSONObject.toJSONString((Object)header)});
        if (ObjectUtils.isNotEmpty(paramsMap)) {
            url = this.generateRequestParameters(url, paramsMap);
        }
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, this.generatePostJson(jsonMap, (MultiValueMap<String, String>)header), clazz, new Object[0]);
        logger.info("------>HttpPost\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)forEntity));
        return (T)forEntity.getBody();
    }

    private String generateRequestParameters(String url, Map<String, Object> params) {
        StringBuffer sb = new StringBuffer(url);
        if (ObjectUtils.isNotEmpty(params)) {
            sb.append("?");
            for (Map.Entry<String, Object> map : params.entrySet()) {
                sb.append((Object)map.getKey()).append("=").append(map.getValue()).append("&");
            }
            url = sb.substring(0, sb.length() - 1);
            return url;
        }
        return sb.toString();
    }

    public HttpEntity<Map<String, Object>> generatePostJson(Map<String, Object> jsonMap, Map<String, Object> headerMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json;charset=UTF-8");
        httpHeaders.setContentType(type);
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(MediaType.APPLICATION_JSON_UTF8);
        httpHeaders.setAccept(mediaTypeList);
        if (ObjectUtils.isNotEmpty(headerMap)) {
            for (Map.Entry<String, Object> map : headerMap.entrySet()) {
                httpHeaders.add(map.getKey().toString(), map.getValue().toString());
            }
        }
        HttpEntity httpEntity = new HttpEntity(jsonMap, (MultiValueMap)httpHeaders);
        return httpEntity;
    }

    public HttpEntity<Map<String, Object>> generatePostJson(Map<String, Object> jsonMap, MultiValueMap<String, String> httpHeaders) {
        jsonMap.forEach((k, v) -> httpHeaders.set(k, (Object)v.toString()));
        return new HttpEntity(httpHeaders);
    }
}

