/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.config;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.aliyun.assembler.MessageAssembler;
import com.dtyunxi.huieryun.mq.provider.aliyun.util.AliyunConsumerHelper;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor.ItemUpdatePriceProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ConsumerExtConfiguration
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerExtConfiguration.class);
    @Resource
    private MessageRegistryVo messageRegistryVo;
    @Resource
    private ItemUpdatePriceProcessor itemUpdatePriceProcessor;
    @Resource
    private Environment environment;
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;

    public void run(String ... args) {
        this.initPriceConsumer();
    }

    private void initPriceConsumer() {
        CompletableFuture.runAsync(() -> {
            MessageRegistryVo registryVo = (MessageRegistryVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.messageRegistryVo), MessageRegistryVo.class);
            registryVo.setConsumerId("PRICE_CONSUMER");
            Properties properties = AliyunConsumerHelper.getProperties((MessageRegistryVo)this.messageRegistryVo);
            String consumerName = this.parseStringWithProfile(CommonsMqHelper.parseConsumer((MessageRegistryVo)this.messageRegistryVo, (String)registryVo.getConsumerId(), (String)""));
            properties.setProperty("GROUP_ID", consumerName);
            properties.setProperty("ConsumerId", consumerName);
            properties.put("MessageModel", MessageModel.CLUSTERING);
            properties.setProperty("ConsumeThreadNums", String.valueOf(this.messageRegistryVo.getConsumeThreadNums()));
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            String topic = "ITEM_PRICE_TOPIC";
            topic = this.parseStringWithProfile(this.environment.resolvePlaceholders(this.environment.resolvePlaceholders(topic)));
            HashMap<String, IMessageProcessor> map = new HashMap<String, IMessageProcessor>(1);
            map.put("to-yxy-update-price-inform", this.itemUpdatePriceProcessor);
            consumer.subscribe(topic, "to-yxy-update-price-inform", this.consumerMessageListener(map));
            if (!consumer.isStarted()) {
                consumer.start();
            }
            logger.info("\u9879\u76ee\u6269\u5c55\u6d88\u8d39\u8005\u542f\u52a8\u6210\u529f:{}", (Object)registryVo.getConsumerId());
        });
    }

    protected String parseStringWithProfile(String str) {
        return (str + "_" + this.globalProfile).replace("-", "_").toUpperCase();
    }

    private MessageListener consumerMessageListener(Map<String, IMessageProcessor> messageProcessorMap) {
        return (message, context) -> {
            Action action;
            Action var4;
            if (logger.isInfoEnabled()) {
                logger.info("\u6269\u5c55\u6d88\u8d39\u8005Receive message success! message:{}" + message.toString());
            }
            try {
                IMessageProcessor messageProcessor = (IMessageProcessor)messageProcessorMap.get(message.getTag());
                if (messageProcessor != null) {
                    Action var6;
                    MQMessageVo messageVo = MessageAssembler.messageToVo((Message)message, (SerializeCode)this.messageRegistryVo.getSerializeCode());
                    MessageResponse response = messageProcessor.process(messageVo);
                    if (response == null) {
                        Action var62;
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c(response is null)\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217\uff01");
                        }
                        Action action2 = var62 = Action.ReconsumeLater;
                        return action2;
                    }
                    if ("error".equals(response.getResultMsg())) {
                        Action var63;
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u8fd4\u56de\u9519\u8bef\u72b6\u6001(response message:{})\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217\uff01", (Object)response.getResultMsg());
                        }
                        Action action3 = var63 = Action.ReconsumeLater;
                        return action3;
                    }
                    if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
                        logger.debug("\u5904\u7406\u6210\u529f\uff0c\u6b63\u5e38\u6d88\u8d39\uff01");
                    }
                    Action action4 = var6 = Action.CommitMessage;
                    return action4;
                }
                logger.warn("\u65e0\u6d88\u606f\u8ba2\u9605\u8005\uff0ctag={}", (Object)message.getTag());
                var4 = Action.CommitMessage;
            }
            catch (BusinessRuntimeException var12) {
                Action var42;
                if (logger.isDebugEnabled()) {
                    logger.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u5f02\u5e38\u6d88\u606f\uff1a", (Throwable)var12);
                } else {
                    logger.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)var12.getMessage());
                }
                action = var42 = Action.CommitMessage;
                return action;
            }
            catch (Error var13) {
                Action var43;
                if (logger.isDebugEnabled()) {
                    logger.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u9519\u8bef\u6d88\u606f\uff1a", (Throwable)var13);
                } else {
                    logger.error("\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u5904\u7406\uff0c\u6d88\u606f\u4e22\u5f03,\u9519\u8bef\u6d88\u606f\uff1a{}", (Object)var13.getMessage());
                }
                action = var43 = Action.CommitMessage;
                return action;
            }
            catch (Throwable var14) {
                Action var44;
                if (logger.isDebugEnabled()) {
                    logger.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a", var14);
                } else {
                    logger.error("\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff0c\u6d88\u606f\u91cd\u65b0\u56de\u5230\u961f\u5217,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)var14.getMessage());
                }
                action = var44 = Action.ReconsumeLater;
                return action;
            }
            finally {
                if (this.messageRegistryVo.isPassSvcContext()) {
                    ServiceContext.removeContext();
                }
            }
            return var4;
        };
    }
}

