/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.apitest;

import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public class TestRestHttp2 {
    private static final String CONFIG_ABSOLUTE_PATH = "D:\\ideaProject\\minishop\\tcbj-openapi-platform\\tcbj-openapi-platformbiz\\src\\main\\java\\com\\dtyunxi\\tcbj\\app\\open\\biz\\apitest\\test-request-trade-detail.txt";
    private static final String APPLICATION_KEY = "AH";
    private static final String APPLICATION_SECRET = "4ac4843c-1741-42fa-8191-43eb387fbe44";

    public static void main(String[] args) {
        try {
            Config config = TestRestHttp2.readConfigFromAbsolutePath(CONFIG_ABSOLUTE_PATH);
            String payload = TestRestHttp2.buildFormattedPayload(config.getBizJson());
            String nonce = UUID.randomUUID().toString();
            String timestamp = String.valueOf(System.currentTimeMillis());
            String sign = TestRestHttp2.generateSign(payload, nonce, timestamp);
            Map<String, String> headers = TestRestHttp2.buildHeaders(nonce, timestamp, sign);
            TestRestHttp2.sendRequestWithFormat(config.getUrl(), payload, headers);
        }
        catch (Exception e) {
            System.err.println("===== \u8bf7\u6c42\u5931\u8d25 =====");
            System.err.println("\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    private static Config readConfigFromAbsolutePath(String absolutePath) throws IOException {
        File configFile = new File(absolutePath);
        if (!configFile.exists()) {
            throw new IOException("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\n\u5f53\u524d\u8def\u5f84\uff1a" + absolutePath + "\n\u68c0\u67e5\uff1a\u8def\u5f84\u6b63\u786e\u6027\u3001\u6587\u4ef6\u662f\u5426\u5b58\u5728\u3001\u6587\u4ef6\u540d\u662f\u5426\u5339\u914d");
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        try (Scanner scanner = new Scanner(configFile, StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                lines.add(line);
            }
        }
        String url = null;
        StringBuilder jsonSb = new StringBuilder();
        for (String string : lines) {
            if (string.startsWith("URL=")) {
                url = string.substring("URL=".length()).trim();
                continue;
            }
            jsonSb.append(string);
        }
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("\u683c\u5f0f\u9519\u8bef\uff1aURL=\u63a5\u53e3\u5730\u5740");
        }
        String bizJson = jsonSb.toString().trim();
        if (bizJson.isEmpty()) {
            throw new IllegalArgumentException("\u683c\u5f0f\u9519\u8bef\uff1a\u672a\u914d\u7f6eJSON\u53c2\u6570");
        }
        return new Config(url, bizJson);
    }

    private static String buildFormattedPayload(String bizJson) {
        JSONObject jsonObj = JSONObject.parseObject((String)bizJson, (Feature[])new Feature[]{Feature.OrderedField});
        return JSON.toJSONString((Object)jsonObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteNullStringAsEmpty});
    }

    private static String generateSign(String payload, String nonce, String timestamp) {
        String compressedPayload = JSON.toJSONString((Object)JSONObject.parseObject((String)payload));
        TreeMap<String, String> signMap = new TreeMap<String, String>();
        signMap.put("X-Yx-Timestamp", timestamp);
        signMap.put("X-Nonce", nonce);
        signMap.put("Application-Key", APPLICATION_KEY);
        signMap.put("Application-Secret", APPLICATION_SECRET);
        signMap.put("md5", MD5.create().digestHex16(compressedPayload));
        String signSource = signMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, APPLICATION_SECRET).hmacHex(signSource).toLowerCase();
    }

    private static Map<String, String> buildHeaders(String nonce, String timestamp, String sign) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Application-Key", APPLICATION_KEY);
        headers.put("X-Yx-Nonce", nonce);
        headers.put("X-Yx-Timestamp", timestamp);
        headers.put("X-Yx-Signature", sign);
        headers.put("Content-Type", "application/json;charset=UTF-8");
        return headers;
    }

    private static void sendRequestWithFormat(String url, String formattedPayload, Map<String, String> headers) {
        System.out.println();
        System.out.println("========================================== \u3010\u8bf7\u6c42\u4fe1\u606f\u3011 ============================================");
        System.out.println();
        System.out.println("\u63a5\u53e3URL\uff1a" + url);
        System.out.println("\u8bf7\u6c42\u5934\uff1a" + headers);
        System.out.println("\u8bf7\u6c42\u4f53\uff1a");
        System.out.println(formattedPayload);
        System.out.println();
        System.out.println("==================================================================================================");
        System.out.println();
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).body(JSON.toJSONString((Object)JSONObject.parseObject((String)formattedPayload))).headerMap(headers, true)).timeout(30000).execute();
        String responseBody = response.body();
        String formattedResponse = TestRestHttp2.formatJson(responseBody);
        System.out.println();
        System.out.println("========================================== \u3010\u54cd\u5e94\u4fe1\u606f\u3011 ==========================================");
        System.out.println();
        System.out.println("\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + response.getStatus());
        System.out.println("\u54cd\u5e94\u4f53\uff1a");
        System.out.println(formattedResponse);
        System.out.println();
        System.out.println("==================================================================================================");
        System.out.println();
        response.close();
    }

    private static String formatJson(String jsonStr) {
        try {
            if (jsonStr.startsWith("{")) {
                return JSON.toJSONString((Object)JSONObject.parseObject((String)jsonStr), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
            if (jsonStr.startsWith("[")) {
                return JSON.toJSONString((Object)JSON.parseArray((String)jsonStr), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
            }
            return jsonStr;
        }
        catch (Exception e) {
            return jsonStr;
        }
    }

    private static class Config {
        private final String url;
        private final String bizJson;

        public Config(String url, String bizJson) {
            this.url = url;
            this.bizJson = bizJson;
        }

        public String getUrl() {
            return this.url;
        }

        public String getBizJson() {
            return this.bizJson;
        }
    }
}

