/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.EasRespBean;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.EasRespBean2;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EasResponseHelper {
    private static final String SUCCESS = "SUCCESS";
    public static final String TOKEN_DISABLED_CODE = "10000";

    private EasResponseHelper() {
    }

    public static void checkOrThrow(EasRespBean restResp) {
        EasResponseHelper.extractData(restResp);
    }

    public static String checkData(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        EasRespBean easRespBean = (EasRespBean)JSON.parseObject((String)data, EasRespBean.class);
        return EasResponseHelper.check(easRespBean);
    }

    public static String checkDataT(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        EasRespBean2 easRespBean = (EasRespBean2)JSON.parseObject((String)data, EasRespBean2.class);
        if (StringUtils.isBlank((CharSequence)easRespBean.getErrorCode()) || !easRespBean.getErrorCode().equals("00")) {
            throw new BizException("\u8bf7\u6c42EAS\u670d\u52a1\u5f02\u5e38\uff1a" + easRespBean.getErrorMessage() + "\uff0c\u603b\u54cd\u5e94\uff1a" + JSON.toJSONString((Object)easRespBean));
        }
        return JSON.toJSONString((Object)easRespBean.getReturnObject());
    }

    public static String check(EasRespBean restResp) {
        if (restResp == null) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
        Integer code = restResp.getErrCode();
        if (Objects.equals(code, 1000)) {
            return TOKEN_DISABLED_CODE;
        }
        if (!Objects.equals(code, 0)) {
            throw new BizException(restResp.getErrMsg());
        }
        Map map = (Map)JSONObject.parseObject((String)restResp.getData(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        if (ObjectUtil.isEmpty((Object)map)) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38\uff0cdata\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(map.get("result"))) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38\uff0cresult\u7ed3\u679c\u4e3a\u7a7a");
        }
        return (String)map.get("result");
    }

    public static void notAllowNull(EasRespBean restResp) {
        if (EasResponseHelper.extractData(restResp) == null) {
            throw new BizException("\u670d\u52a1\u7aef\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a!");
        }
    }

    public static Object extractData(EasRespBean restResp) {
        if (restResp == null) {
            return null;
        }
        Integer code = restResp.getErrCode();
        if (!Objects.equals(code, 0)) {
            throw new BizException(restResp.getErrMsg());
        }
        String data = restResp.getData();
        if (StringUtils.isBlank((CharSequence)data) || !data.contains(SUCCESS)) {
            throw new BizException(data);
        }
        return data;
    }
}

