/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.check;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.tcbj.app.open.biz.auth.ModeTypeEnum;
import com.dtyunxi.tcbj.app.open.biz.auth.ResultBo;
import com.dtyunxi.tcbj.app.open.biz.auth.ServletDataUtils;
import com.dtyunxi.tcbj.app.open.biz.auth.check.ICheck;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthProperties;
import com.dtyunxi.tcbj.app.open.biz.auth.filter.ContentRepeatableHttpServletRequestWrapper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.SignHelper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.dto.BasicSignDto;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpMethod;

public class HmacParamCheckImpl
implements ICheck {
    private final Map<String, String> instanceSecretMap = new ConcurrentHashMap<String, String>();
    private final SignHelper signHelper;
    @Resource
    private ThirdAuthProperties properties;

    public HmacParamCheckImpl(SignHelper signHelper) {
        this.signHelper = signHelper;
    }

    @Override
    public boolean supports(HttpServletRequest request) {
        return StringUtils.isNotBlank((String)request.getHeader("X-Yx-Signature"));
    }

    @Override
    public ResultBo check(HttpServletRequest request) {
        return this.doCheck(request) ? ResultBo.successData() : ResultBo.build(false);
    }

    private boolean doCheck(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("X-Yx-Signature")).map(sign -> this.isValid(request, (String)sign)).orElse(false);
    }

    private Boolean isValid(HttpServletRequest request, String sign) {
        String applicationKey = request.getHeader("Application-Key");
        return Optional.ofNullable(this.getAppSecret(applicationKey)).filter(StringUtils::isNotBlank).map(appSecret -> {
            BasicSignDto basicSignDto = new BasicSignDto();
            basicSignDto.setNonce(request.getHeader("X-Yx-Nonce"));
            basicSignDto.setTimestamp(request.getHeader("X-Yx-Timestamp"));
            basicSignDto.setAppSecret((String)appSecret);
            basicSignDto.setAppKey(applicationKey);
            basicSignDto.setReqParam(this.extractReqParam(request));
            return this.signHelper.sign(basicSignDto).equals(sign);
        }).orElse(false);
    }

    private JSONObject extractReqParam(HttpServletRequest request) {
        if (ModeTypeEnum.ZERO.equals((Object)ModeTypeEnum.resolve(this.properties.getModel()))) {
            return new JSONObject();
        }
        try {
            return this.doExtractReqParam(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    private JSONObject doExtractReqParam(HttpServletRequest request) throws IOException {
        switch (Objects.requireNonNull(HttpMethod.resolve((String)request.getMethod()))) {
            case POST: 
            case PUT: {
                return JSONObject.parseObject((String)((ContentRepeatableHttpServletRequestWrapper)request).getBody(), (Feature[])new Feature[]{Feature.OrderedField});
            }
            case GET: 
            case DELETE: {
                return Optional.ofNullable(URLEncoder.encode(request.getQueryString(), "utf-8")).map(ServletDataUtils::urlParse).orElse(new JSONObject());
            }
        }
        return new JSONObject();
    }

    private String getAppSecret(String applicationKey) {
        this.instanceSecretMap.putIfAbsent(applicationKey, this.loadAppSecret(applicationKey));
        return this.instanceSecretMap.get(applicationKey);
    }

    private String loadAppSecret(String applicationKey) {
        return this.properties.getAppKeyMap().getOrDefault(applicationKey, "");
    }
}

