/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.WarehouseTenantRespDto;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.WarehouseSyncVo;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="tcbj-warehouse-sync-queue")
public class WarehouseProcessor
implements IMessageProcessor<Object> {
    private static final Logger log = LoggerFactory.getLogger(WarehouseProcessor.class);
    @Resource
    private MarketingCloudService marketingCloudService;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private ICsPhysicsWarehouseApi csPhysicsWarehouseApi;
    @Resource
    private ICsPhysicsWarehouseQueryApi csPhysicsWarehouseQueryApi;
    private static final Integer LIMIT = 100;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(Object message) {
        log.info("\u63a5\u6536\u5230\u4ed3\u5e93\u65b0\u589e\u540c\u6b65\u7684MQ\u6570\u636e:{}", message);
        this.executorService.execute(new Thread(() -> {
            log.info("\u5f00\u59cb\u5904\u7406\u4ed3\u5e93\u6570\u636e:{}", message);
            this.dealWithWarehouse(message);
        }));
        return MessageResponse.SUCCESS;
    }

    public static void main(String[] args) {
        String message = "{\"content\":\"{\\\"depotList\\\":[{\\\"extTenantId\\\":\\\"0445cb11ab1a4e919387a2ce85fb670b\\\",\\\"tenantCode\\\":\\\"czybj\\\",\\\"id\\\":1498861326867496962,\\\"number\\\":\\\"00003028056\\\",\\\"name\\\":\\\"\u5f85\u5904\u7406\u4ed3\\\",\\\"type\\\":2,\\\"tenantId\\\":1167870438,\\\"deleteFlag\\\":\\\"0\\\",\\\"isDefault\\\":false,\\\"createTime\\\":1646191362494,\\\"updateTime\\\":1646191362494,\\\"extSysCode\\\":\\\"\\\"}]}\",\"messageKey\":\"66344689f45f4c188a27e84cd279420b\",\"method\":\"tcbj-depot-add-queue\",\"origin\":true,\"srcSystem\":\"JXC\"}";
        JSONObject parse = (JSONObject)JSONObject.parse((String)String.valueOf(message));
        System.out.println(parse);
        JSONObject content = parse.getJSONObject("content");
        List warehouseSyncVos = content.getJSONArray("depotList").toJavaList(WarehouseSyncVo.class);
    }

    private void dealWithWarehouse(Object message) {
        try {
            long startTime = System.currentTimeMillis();
            JSONObject parse = (JSONObject)JSONObject.parse((String)String.valueOf(message));
            String originStr = parse.getString("origin");
            if (StringUtils.isBlank((CharSequence)originStr) || "false".equals(originStr)) {
                log.info("origin\u53c2\u6570\u4e3a\u7a7a\u6216false");
                return;
            }
            JSONObject content = parse.getJSONObject("content");
            List warehouseSyncVos = content.getJSONArray("depotList").toJavaList(WarehouseSyncVo.class);
            if (CollectionUtils.isEmpty((Collection)warehouseSyncVos)) {
                log.info("warehouseSyncVos\u53c2\u6570\u4e3a\u7a7a");
                return;
            }
            List idsStr = warehouseSyncVos.stream().map(WarehouseSyncVo::getExtTenantId).collect(Collectors.toList());
            String accessToken = this.marketingCloudService.getToken();
            ArrayList dataList = new ArrayList();
            int max = LIMIT;
            int currentIndex = 0;
            while (idsStr.size() > currentIndex) {
                Object warehouseTenantList;
                List<String> id = null;
                if (idsStr.size() - currentIndex > max) {
                    id = idsStr.subList(currentIndex, currentIndex + max);
                    currentIndex += max;
                } else {
                    id = idsStr.subList(currentIndex, idsStr.size());
                    currentIndex = idsStr.size();
                }
                if (!CollectionUtils.isNotEmpty(warehouseTenantList = this.marketingCloudService.getWarehouseTenantList(id, accessToken))) continue;
                dataList.addAll(warehouseTenantList);
            }
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u83b7\u53d6\u4ed3\u5e93\u4e0e\u79df\u6237\u5173\u7cfb\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(dataList));
            if (CollectionUtils.isEmpty(dataList)) {
                log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u540c\u6b65\u7ed3\u675f\uff0c\u65e0\u7ecf\u4ed3\u5e93\u4e0e\u79df\u6237\u5173\u7cfb\u6570\u636e");
                return;
            }
            List orgDtoList = (List)this.bizOrganizationQueryApi.getOrganizations(idsStr).getData();
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u6839\u636e\u7f16\u53f7\u67e5\u8be2\u5728\u5e93\u7ec4\u7ec7\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)orgDtoList));
            if (CollectionUtils.isEmpty((Collection)orgDtoList)) {
                log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u540c\u6b65\u7ed3\u675f\uff0c\u65e0\u7ec4\u7ec7\u6570\u636e");
                return;
            }
            for (WarehouseTenantRespDto dto : dataList) {
                for (OrganizationDto org : orgDtoList) {
                    if (!dto.getExtTenantId().equals(org.getCode())) continue;
                    dto.setOrgId(org.getId());
                    dto.setOrgName(org.getName());
                }
            }
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u8d4b\u4e88\u7ec4\u7ec7ID\u4e0e\u7f16\u53f7\u540e\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(dataList));
            CsPhysicsWarehouseQueryDto queryDto = new CsPhysicsWarehouseQueryDto();
            queryDto.setPageNum(Integer.valueOf(1));
            queryDto.setPageSize(Integer.valueOf(10000));
            PageInfo warehousePage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseQueryApi.queryByPage(queryDto));
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u67e5\u8be2\u5728\u5e93\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)warehousePage));
            List warehouseList = warehousePage.getList();
            int insertCount = 0;
            int updateCount = 0;
            int failCount = 0;
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u8fdb\u884c\u843d\u5e93");
            for (WarehouseTenantRespDto dto : dataList) {
                log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u5904\u7406\u4ed3\u5e93\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
                if (dto.getOrgId() == null) {
                    log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u5f02\u5e38\u6570\u636e\uff0c\u65e0\u5339\u914d\u7ec4\u7ec7");
                    ++failCount;
                    continue;
                }
                if (CollectionUtils.isNotEmpty((Collection)warehouseList)) {
                    boolean isNew = true;
                    for (CsPhysicsWarehouseRespDto warehouse : warehouseList) {
                        if (!dto.getNumber().equals(warehouse.getWarehouseCode())) continue;
                        isNew = false;
                        dto.setWarehouseRespDto(warehouse);
                        break;
                    }
                    if (isNew) {
                        this.csPhysicsWarehouseApi.initPhysicsWarehouse(this.getCreateReqDto(dto));
                        ++insertCount;
                        continue;
                    }
                    this.csPhysicsWarehouseApi.updatePhysicsWarehouse(dto.getWarehouseRespDto().getId(), this.getUpdateReqDto(dto));
                    ++updateCount;
                    continue;
                }
                this.csPhysicsWarehouseApi.initPhysicsWarehouse(this.getCreateReqDto(dto));
                ++insertCount;
            }
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u843d\u5e93\u5b8c\u6210\uff0c\u5171\u8ba1\uff1a{}\uff0c\u65b0\u589e\uff1a{}\uff0c\u66f4\u65b0\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{dataList.size(), insertCount, updateCount, failCount});
            long endTime = System.currentTimeMillis();
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u8017\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
            log.info("\u3010\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u7ed3\u675f\u540c\u6b65--------->");
        }
        catch (Exception e) {
            log.error("\u63a5\u6536\u5230\u4ed3\u5e93\u65b0\u589e\u540c\u6b65\u6d88\u606f\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void printProcessorInfo() {
        MQDesc mqDesc = this.getClass().getAnnotation(MQDesc.class);
        if (mqDesc == null) {
            log.info("ProcessorInfo: \u672a\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f");
            return;
        }
        String info = String.format("topic=%s, tag=%s, consumer=%s, msgType=%s", mqDesc.topic(), mqDesc.tag(), mqDesc.consumer(), mqDesc.msgType());
        log.info("ProcessorInfo: {}", (Object)info);
    }

    private CsPhysicsWarehouseAddReqDto getCreateReqDto(WarehouseTenantRespDto dto) {
        CsPhysicsWarehouseAddReqDto physicsWarehouseAddReqDto = new CsPhysicsWarehouseAddReqDto();
        physicsWarehouseAddReqDto.setWarehouseStatus(CsPhysicsWarehouseStatusEnum.INITIAL.getCode());
        physicsWarehouseAddReqDto.setOrganizationName(dto.getName());
        physicsWarehouseAddReqDto.setOrganizationId(dto.getOrgId());
        physicsWarehouseAddReqDto.setWarehouseName(dto.getName());
        physicsWarehouseAddReqDto.setWarehouseCode(dto.getNumber());
        physicsWarehouseAddReqDto.setWarehouseType(dto.getType().toString());
        physicsWarehouseAddReqDto.setMainWarehouse(this.getIsDefault(dto.getIsDefault()));
        log.info("\u65b0\u589e\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)physicsWarehouseAddReqDto));
        return physicsWarehouseAddReqDto;
    }

    private CsPhysicsWarehouseUpdateReqDto getUpdateReqDto(WarehouseTenantRespDto dto) {
        CsPhysicsWarehouseUpdateReqDto warehouseUpdateReqDto = new CsPhysicsWarehouseUpdateReqDto();
        warehouseUpdateReqDto.setWarehouseStatus(dto.getWarehouseRespDto().getWarehouseStatus());
        warehouseUpdateReqDto.setOrganizationName(dto.getName());
        warehouseUpdateReqDto.setOrganizationId(dto.getOrgId());
        warehouseUpdateReqDto.setWarehouseName(dto.getName());
        warehouseUpdateReqDto.setWarehouseCode(dto.getNumber());
        warehouseUpdateReqDto.setWarehouseType(dto.getType().toString());
        warehouseUpdateReqDto.setMainWarehouse(this.getIsDefault(dto.getIsDefault()));
        log.info("\u66f4\u65b0\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)warehouseUpdateReqDto));
        return warehouseUpdateReqDto;
    }

    private Integer getIsDefault(Boolean value) {
        if (value.booleanValue()) {
            return 1;
        }
        return 0;
    }
}

