/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.request.PcpWarehouse;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="centerHandlePcpWarehouseServiceImpl")
public class CenterHandlePcpWarehouseServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandlePcpWarehouseServiceImpl.class);
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private ICsLogicWarehouseApi csLogicWarehouseApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.WAREHOUSE.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        long startTime = System.currentTimeMillis();
        ArrayList<DataDistributeRespDto> respDtoList = new ArrayList<DataDistributeRespDto>();
        DataDistributeRespDto respDto = new DataDistributeRespDto();
        logger.info("\u4ed3\u5e93\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
        List pcpWarehousesList = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), PcpWarehouse.class);
        if (CollectionUtils.isEmpty((Collection)pcpWarehousesList)) {
            DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
            dataDistributeRespDto.setReason("\u53c2\u6570\u4e3a\u7a7a");
            dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.name());
            respDtoList.add(dataDistributeRespDto);
            return respDtoList;
        }
        List codes = pcpWarehousesList.stream().map(PcpWarehouse::getNumber).collect(Collectors.toList());
        List orgCodes = pcpWarehousesList.stream().map(PcpWarehouse::getOrgNum).collect(Collectors.toList());
        CsLogicWarehouseQueryDto queryDto = new CsLogicWarehouseQueryDto();
        queryDto.setWarehouseCodeList(codes);
        List warehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseQueryApi.queryByParam(queryDto));
        logger.info("\u7269\u7406\u4ed3\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)warehouseRespDtoList));
        Map warehouseMap = warehouseRespDtoList.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Functions.identity(), (n1, n2) -> n1));
        List orgDtoList = (List)this.organizationQueryExtApi.queryOrgDetailByThirdCode(orgCodes).getData();
        logger.info("\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)orgDtoList));
        Map orgListMap = null;
        if (CollectionUtils.isNotEmpty((Collection)orgDtoList)) {
            orgListMap = orgDtoList.stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getThirdOrgId, Functions.identity(), (n1, n2) -> n1));
        }
        AtomicInteger insertCount = new AtomicInteger(0);
        AtomicInteger updateCount = new AtomicInteger(0);
        AtomicInteger failCount = new AtomicInteger(0);
        logger.info("\u4ed3\u5e93\u5bf9\u8c61\u5217\u8868\uff1a{}", (Object)JSON.toJSONString((Object)pcpWarehousesList));
        OrgAdvDetailRespDto orgDto = null;
        for (PcpWarehouse dto : pcpWarehousesList) {
            respDto = new DataDistributeRespDto();
            respDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
            respDto.setTask_id(dto.getCidpTaskUuid());
            try {
                CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)warehouseMap.get(dto.getNumber());
                if (orgListMap != null) {
                    orgDto = (OrgAdvDetailRespDto)orgListMap.get(dto.getOrgNum());
                }
                if (!Objects.isNull(orgDto)) {
                    dto.setOrg(orgDto);
                }
                dto.setWarehouseRespDto(warehouseRespDto);
                if (Objects.nonNull(warehouseRespDto)) {
                    this.csLogicWarehouseApi.update(dto.getWarehouseRespDto().getId(), this.getUpdateReqDto(dto));
                    updateCount.addAndGet(1);
                } else {
                    this.csLogicWarehouseApi.add(this.getCreateReqDto(dto));
                    insertCount.addAndGet(1);
                    respDto.setTask_id(dto.getCidpTaskUuid());
                    respDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
                    respDto.setReason("\u65b0\u589e\u4ed3\u5e93\u6210\u529f\uff0c\u4ed3\u5e93\u7f16\u7801\u4e3a:" + dto.getOrgNum());
                }
                respDtoList.add(respDto);
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u4ed3\u5e93\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
                respDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                respDto.setReason(e.getMessage());
                respDtoList.add(respDto);
            }
        }
        logger.info("\u3010PCP\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u843d\u5e93\u5b8c\u6210\uff0c\u5171\u8ba1\uff1a{}\uff0c\u65b0\u589e\uff1a{}\uff0c\u66f4\u65b0\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{pcpWarehousesList.size(), insertCount, updateCount, failCount});
        long endTime = System.currentTimeMillis();
        logger.info("\u3010PCP\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u8017\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        logger.info("\u3010PCP\u4ed3\u5e93\u65b0\u589e\u540c\u6b65mq\u3011\u7ed3\u675f\u540c\u6b65--------->");
        return respDtoList;
    }

    private CsLogicWarehouseAddReqDto getCreateReqDto(PcpWarehouse dto) {
        CsLogicWarehouseAddReqDto csLogicWarehouseAddReqDto = new CsLogicWarehouseAddReqDto();
        csLogicWarehouseAddReqDto.setWarehouseStatus("initial");
        csLogicWarehouseAddReqDto.setOrganizationName(dto.getOrgName());
        if (Objects.nonNull(dto.getOrg())) {
            csLogicWarehouseAddReqDto.setOrganizationId(dto.getOrg().getId());
        }
        csLogicWarehouseAddReqDto.setWarehouseName(dto.getName());
        csLogicWarehouseAddReqDto.setWarehouseCode(dto.getNumber());
        csLogicWarehouseAddReqDto.setWarehouseType(dto.getType());
        csLogicWarehouseAddReqDto.setMainWarehouse(Optional.ofNullable(dto.getIsDefault()).orElse(1));
        csLogicWarehouseAddReqDto.setCargoEscheatageId(dto.getOrgNum());
        csLogicWarehouseAddReqDto.setCargoEscheatageName(dto.getOrgName());
        csLogicWarehouseAddReqDto.setCreatePerson("MDM");
        csLogicWarehouseAddReqDto.setUpdatePerson("MDM");
        logger.info("\u65b0\u589e\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)csLogicWarehouseAddReqDto));
        return csLogicWarehouseAddReqDto;
    }

    private CsLogicWarehouseUpdateReqDto getUpdateReqDto(PcpWarehouse dto) {
        CsLogicWarehouseUpdateReqDto warehouseUpdateReqDto = new CsLogicWarehouseUpdateReqDto();
        warehouseUpdateReqDto.setWarehouseStatus(dto.getWarehouseRespDto().getWarehouseStatus());
        warehouseUpdateReqDto.setOrganizationName(dto.getOrgName());
        warehouseUpdateReqDto.setOrganizationCode(dto.getOrgNum());
        if (Objects.nonNull(dto.getOrg())) {
            warehouseUpdateReqDto.setOrganizationId(dto.getOrg().getId());
        }
        warehouseUpdateReqDto.setWarehouseName(dto.getName());
        warehouseUpdateReqDto.setCargoEscheatageId(dto.getOrgNum());
        warehouseUpdateReqDto.setCargoEscheatageName(dto.getOrgName());
        warehouseUpdateReqDto.setUpdatePerson("MDM");
        logger.info("\u66f4\u65b0\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)warehouseUpdateReqDto));
        return warehouseUpdateReqDto;
    }

    private static Map convert(Map map) {
        HashMap newMap = Maps.newHashMap();
        for (Object s : map.keySet()) {
            String key = StrUtil.toCamelCase((CharSequence)s.toString().toLowerCase());
            newMap.put(key, map.get(s));
        }
        return newMap;
    }
}

