/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.WarehouseColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="centerHandleWarehouseServiceImpl")
public class CenterHandleWarehouseServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleWarehouseServiceImpl.class);
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private RequestBaseData requestBaseData;

    @Override
    public String getModelType() {
        return null;
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        ArrayList<DataDistributeRespDto> respDtoList = new ArrayList<DataDistributeRespDto>();
        DataDistributeRespDto respDto = new DataDistributeRespDto();
        logger.info("\u4ed3\u5e93\u6570\u636e\u5206\u53d1:{}", (Object)modelInfoReqDto.toString());
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        String str = this.validaData(maps);
        if (StringUtils.isNotEmpty((String)str)) {
            return new ArrayList<DataDistributeRespDto>();
        }
        ArrayList<String> codes = new ArrayList<String>();
        ArrayList<String> orgCodes = new ArrayList<String>();
        for (Map map : maps) {
            codes.add(map.get(WarehouseColumnEnum.FNUMBER.name()).toString());
            orgCodes.add(map.get(WarehouseColumnEnum.ORGNUM.name()).toString());
        }
        respDto.setReason("\u66f4\u65b0\u6210\u529f");
        respDtoList.add(respDto);
        return respDtoList;
    }

    private String validaData(List<Map> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return "\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (Map map : dataMap) {
            if (map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name()) == null) {
                return "\u4ed3\u5e93\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a";
            }
            String s = this.getStatus(map);
            if (s == null) {
                return "\u4ed3\u5e93\u72b6\u6001\u6570\u503c'" + map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name()) + "'\u65e0\u6cd5\u5bf9\u5e94";
            }
            map.put(WarehouseColumnEnum.WAREHOUSE_STATUS.name(), s);
            if (map.get(WarehouseColumnEnum.ORGNUM.name()) == null) {
                return "\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801";
            }
            if (map.get(WarehouseColumnEnum.FNUMBER.name()) == null) {
                return "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (map.get(WarehouseColumnEnum.FNAME.name()) != null) continue;
            return "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String getStatus(Map map) {
        Object o = map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name());
        if (o == null) {
            return null;
        }
        try {
            if (Integer.parseInt(o.toString()) == 0) {
                return "BANNED";
            }
            if (Integer.parseInt(o.toString()) == 1) {
                return "NORMAL";
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return "\u4ed3\u5e93\u72b6\u6001\u8f6c\u6362\u5f02\u5e38";
        }
    }
}

