/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InTransitInNoticeDetailReqDto;
import com.dtyunxi.tcbj.api.query.ICsOutNoticeOrderDetailQueryApi;
import com.dtyunxi.tcbj.api.vo.Batch;
import com.dtyunxi.tcbj.api.vo.InTransitInNoticeDetailVo;
import com.dtyunxi.tcbj.app.open.biz.service.IApiLogService;
import com.dtyunxi.tcbj.app.open.biz.service.IMultiAllotOrderService;
import com.dtyunxi.tcbj.app.open.biz.utils.AssertUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.DateUtils;
import com.dtyunxi.tcbj.app.open.biz.utils.StockOutAndInToWmsUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.AllotOrderDetailDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.AllotOrderDto;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.RouteMultiAllotNodeEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOrderCancelReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsWarehouseAddressApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.entity.IInOutNoticeOrderApi;
import com.yunxi.dg.base.center.inventory.api.entity.IInOutNoticeOrderDetailApi;
import com.yunxi.dg.base.center.inventory.api.entity.IReceiveDeliveryNoticeOrderApi;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDetailPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MultiAllotOrderServiceImpl
implements IMultiAllotOrderService {
    private static final Logger log = LoggerFactory.getLogger(MultiAllotOrderServiceImpl.class);
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private IInOutNoticeOrderDetailApi inOutNoticeOrderDetailApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;
    @Resource
    private IApiLogService apiLogService;
    @Resource(name="externalWmsRest")
    private IExternalWmsApi externalWmsApi;
    @Resource
    private ICsWmsApi csWmsApi;
    @Resource
    private IReceiveDeliveryNoticeOrderApi receiveDeliveryNoticeOrderApi;
    @Resource
    private StockOutAndInToWmsUtil stockOutAndInToWmsUtil;
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private IPcpItemQueryApi pcpItemQueryApi;
    @Resource
    private ICsTransferOrderApi transferOrderApi;
    @Resource
    private ICsWarehouseAddressApi csWarehouseAddressApi;
    @Resource
    private ICsPhysicsWarehouseApi csPhysicsWarehouseApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private IInOutNoticeOrderApi inOutNoticeOrderApi;
    @Resource
    private ICsOutNoticeOrderDetailQueryApi csOutNoticeOrderDetailQueryApi;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private IInventoryApi iInventoryApi;

    @Override
    public void routeMultiAllotPreemptInventory(AllotOrderDto allotOrderDto) {
        List<CsInventoryOperateReqDto> csInventoryOperateReqDtoList = this.inventoryOperateListBuild(Lists.newArrayList((Object[])new AllotOrderDto[]{allotOrderDto}), null);
        log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u9884\u5360\u5e93\u5b58\uff1a{}", (Object)JacksonUtil.toJson(csInventoryOperateReqDtoList));
        try {
            RestResponseHelper.extractData((RestResponse)this.csInventoryExposedApi.batchPreemptInventory(csInventoryOperateReqDtoList));
        }
        catch (Exception e) {
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.PREEMPT, false, e.getMessage());
            throw new BizException("-1", "\u5728\u9014\u5185\u90e8\u4ea4\u6613\u9884\u5360\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void routeMultiAllotReleaseInventory(AllotOrderDto allotOrderDto) {
        try {
            ReleasePreemptDto preemptDto = new ReleasePreemptDto();
            preemptDto.setSourceNo(allotOrderDto.getExternalSaleOrderNo());
            preemptDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
            log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u91ca\u653e\u5e93\u5b58\uff1a{}", (Object)JacksonUtil.toJson((Object)preemptDto));
            RestResponseHelper.extractData((RestResponse)this.iInventoryApi.releaseLogicPreempt(preemptDto));
        }
        catch (Exception e) {
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.RELEASE, false, e.getMessage());
            throw new BizException("-1", "\u91ca\u653e\u5e93\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public InTransitInNoticeDetailVo routeMultiAllotCancelToWms(List<InTransitInNoticeDetailVo> noticeDetailVos, AllotOrderDto allotOrderDto) {
        log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u9009\u62e9\u5165\u5e93\u901a\u77e5\u5e76\u63a8\u9001WMS\u53d6\u6d88");
        InTransitInNoticeDetailVo noticeDetailVo = null;
        for (InTransitInNoticeDetailVo vo : noticeDetailVos) {
            boolean cancelResult = this.cancelToWms(vo);
            if (!cancelResult) continue;
            noticeDetailVo = vo;
            break;
        }
        if (ObjectUtil.isEmpty(noticeDetailVo)) {
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.CANCEL_WMS, false, JacksonUtil.toJson(noticeDetailVos));
            AssertUtil.isTrues(ObjectUtil.isEmpty((Object)noticeDetailVo), "-1", "\u5339\u914d\u5230\u7684\u5165\u5e93\u901a\u77e5\u5747WMS\u53d6\u6d88\u5931\u8d25");
        }
        allotOrderDto.setTransferOrderNo(noticeDetailVo.getTransferOrderNo());
        allotOrderDto.setInNoticeOrderNo(noticeDetailVo.getInNoticeNo());
        allotOrderDto.setNoticeDetailList(noticeDetailVo.getBatches());
        return noticeDetailVo;
    }

    @Override
    public void routeMultiAllotExecute(AllotOrderDto allotOrderDto, InTransitInNoticeDetailVo noticeDetailVo) {
        log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u6d41\u8f6c\uff1a{}\uff1b{}", (Object)JacksonUtil.toJson((Object)allotOrderDto), (Object)JacksonUtil.toJson((Object)noticeDetailVo));
        CsOutNoticeOrderRespDto noticeOrder = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(allotOrderDto.getInNoticeOrderNo()));
        InOutNoticeOrderDetailPageReqDto query = new InOutNoticeOrderDetailPageReqDto();
        query.setDocumentNo(noticeOrder.getDocumentNo());
        query.setPageNum(Integer.valueOf(1));
        query.setPageSize(Integer.valueOf(1000));
        List noticeDetailList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.inOutNoticeOrderDetailApi.page(query))).getList();
        try {
            RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApi.cancel(noticeOrder.getPreOrderNo()));
        }
        catch (Exception e) {
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.CANCEL_OCS, false, e.getMessage());
            log.error("OCS\u53d6\u6d88\u901a\u77e5\u5355\u5931\u8d25\uff1a" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        if (noticeDetailList.size() != allotOrderDto.getNoticeDetailList().size()) {
            log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u62c6\u5355");
            this.noticeOrderSplit(allotOrderDto, noticeOrder, noticeDetailList);
        }
        try {
            List<EasTransferOrderReqDto> easTransferOrderReqDtoList = this.easTransferOrderList(Lists.newArrayList((Object[])new AllotOrderDto[]{allotOrderDto}), noticeDetailList);
            log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u521b\u5efa\u5355\u636e\uff1a{}", (Object)JSON.toJSONString(easTransferOrderReqDtoList));
            RestResponseHelper.extractData((RestResponse)this.transferOrderApi.batchEasAddTransferOrder(easTransferOrderReqDtoList));
        }
        catch (Exception e) {
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.CREATE, false, e.getMessage());
            log.error("\u521b\u5efa\u5355\u636e\u5931\u8d25\uff1a" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<InTransitInNoticeDetailVo> routeMultiAllotMatch(AllotOrderDto allotOrderDto) {
        AllotOrderDetailDto allotOrderDetailDto = (AllotOrderDetailDto)allotOrderDto.getItemDetailList().get(0);
        InTransitInNoticeDetailReqDto reqDto = new InTransitInNoticeDetailReqDto();
        reqDto.setSkuCode(allotOrderDetailDto.getSkuCode());
        reqDto.setQuantity(Integer.valueOf(allotOrderDetailDto.getQuantity().intValue()));
        reqDto.setInTransitWarehouseCode(allotOrderDetailDto.getOutWarehouseCode());
        reqDto.setPageNum(Integer.valueOf(1));
        reqDto.setPageSize(Integer.valueOf(1000));
        log.info("\u5339\u914d\u5165\u5e93\u901a\u77e5\u660e\u7ec6\uff1a{}", (Object)JacksonUtil.toJson((Object)reqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderDetailQueryApi.inTransitInNoticeDetail(reqDto));
        if (ObjectUtil.isEmpty((Object)pageInfo) || CollectionUtil.isEmpty((Collection)pageInfo.getList())) {
            String msg = String.format("\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u5165\u5e93\u901a\u77e5\uff0c\u54c1\uff1a%s\uff0c\u6570\u91cf\uff1a%s\uff0c\u51fa\u5e93\u4ed3\uff1a%s", reqDto.getSkuCode(), reqDto.getQuantity(), reqDto.getInTransitWarehouseCode());
            throw new BizException("-1", msg);
        }
        log.info("\u5339\u914d\u5165\u5e93\u901a\u77e5\u660e\u7ec6\u7ed3\u679c\uff1a{}", (Object)JacksonUtil.toJson((Object)pageInfo.getList()));
        return pageInfo.getList();
    }

    private boolean cancelToWms(InTransitInNoticeDetailVo noticeDetailVo) {
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(noticeDetailVo.getTransferOrderNo()));
        AssertUtil.isTrues(ObjectUtil.isEmpty((Object)transferOrder), "-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355\uff1a" + noticeDetailVo.getTransferOrderNo());
        WmsOrderCancelReqDto cancelReqDto = new WmsOrderCancelReqDto();
        cancelReqDto.setOrderCode(noticeDetailVo.getInNoticeNo());
        cancelReqDto.setOrderType(CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode());
        cancelReqDto.setWarehouseCode(transferOrder.getInPhysicsWarehouseCode());
        cancelReqDto.setLogicWarehouseCode(transferOrder.getOutPhysicsWarehouseCode());
        log.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\uff0cWMS\u53d6\u6d88\u5165\u5e93\u901a\u77e5\u5355:{}", (Object)JSON.toJSONString((Object)cancelReqDto));
        try {
            WmsBaseRespDto wmsBaseRespDto = (WmsBaseRespDto)RestResponseHelper.extractData((RestResponse)this.externalWmsApi.cancel(cancelReqDto));
            AssertUtil.isTrues(!wmsBaseRespDto.isSuccess(), "-1", "\u8bf7\u6c42WMS\u53d6\u6d88\u5165\u5e93\u5931\u8d25\uff1a" + wmsBaseRespDto.getContent());
        }
        catch (Exception e) {
            log.info("WMS\u53d6\u6d88\u5165\u5e93\u901a\u77e5\u5355\u5931\u8d25\uff1a" + cancelReqDto.getOrderCode() + "\u3002" + e.getMessage());
            return false;
        }
        return true;
    }

    private void noticeOrderSplit(AllotOrderDto allotOrderDto, CsOutNoticeOrderRespDto noticeOrder, List<InOutNoticeOrderDetailDto> noticeDetailList) {
        List inNoticeDetailIds = allotOrderDto.getNoticeDetailList().stream().map(Batch::getId).collect(Collectors.toList());
        noticeDetailList = noticeDetailList.stream().filter(f -> !inNoticeDetailIds.contains(f.getId())).collect(Collectors.toList());
        ReceiveDeliveryNoticeOrderDto splitNoticeOrderDto = new ReceiveDeliveryNoticeOrderDto();
        BeanUtil.copyProperties((Object)noticeOrder, (Object)splitNoticeOrderDto, (String[])new String[0]);
        splitNoticeOrderDto.setDocumentNo(null);
        splitNoticeOrderDto.setId(null);
        splitNoticeOrderDto.setWmsOrderNo(null);
        splitNoticeOrderDto.setBizDate(null);
        splitNoticeOrderDto.setPreOrderNo(null);
        splitNoticeOrderDto.setOrderType("receive");
        splitNoticeOrderDto.setOrderStatus(null);
        splitNoticeOrderDto.setAutoComplete(Boolean.valueOf(false));
        splitNoticeOrderDto.setSendWms(Boolean.valueOf(true));
        splitNoticeOrderDto.setIgnoreRepeat(Boolean.valueOf(true));
        splitNoticeOrderDto.setExternalOrderNo(noticeOrder.getExternalOrderNo());
        splitNoticeOrderDto.setDeliveryLogicWarehouseCode(noticeOrder.getOutLogicWarehouseCode());
        splitNoticeOrderDto.setDeliveryLogicWarehouseName(noticeOrder.getOutLogicWarehouseName());
        splitNoticeOrderDto.setDeliveryPhysicsWarehouseCode(noticeOrder.getOutPhysicsWarehouseCode());
        splitNoticeOrderDto.setDeliveryPhysicsWarehouseName(noticeOrder.getOutPhysicsWarehouseName());
        splitNoticeOrderDto.setReceiveLogicWarehouseCode(noticeOrder.getInLogicWarehouseCode());
        splitNoticeOrderDto.setReceiveLogicWarehouseName(noticeOrder.getInLogicWarehouseName());
        splitNoticeOrderDto.setReceivePhysicsWarehouseCode(noticeOrder.getInPhysicsWarehouseCode());
        splitNoticeOrderDto.setReceivePhysicsWarehouseName(noticeOrder.getInPhysicsWarehouseName());
        List detailDtoList = noticeDetailList.stream().map(detail -> {
            ReceiveDeliveryNoticeOrderDetailDto splitDetailDto = new ReceiveDeliveryNoticeOrderDetailDto();
            BeanUtil.copyProperties((Object)detail, (Object)splitDetailDto, (String[])new String[0]);
            splitDetailDto.setId(null);
            splitDetailDto.setDocumentNo(null);
            splitDetailDto.setWmsOrderNo(null);
            splitDetailDto.setPreOrderNo(null);
            if (ObjectUtil.isEmpty((Object)detail.getTradeOrderItemId())) {
                splitDetailDto.setTradeOrderItemId(detail.getPreOrderItemId());
            }
            return splitDetailDto;
        }).collect(Collectors.toList());
        splitNoticeOrderDto.setReceiveDeliveryNoticeOrderDetailDtos(detailDtoList);
        log.info("\u62c6\u5355\uff0c\u521b\u5efa\u65b0\u7684\u901a\u77e5\u5355\uff1a{}", (Object)JacksonUtil.toJson((Object)splitNoticeOrderDto));
        try {
            ReceiveDeliveryNoticeOrderDto noticeOrderDto = (ReceiveDeliveryNoticeOrderDto)RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApi.create(splitNoticeOrderDto));
            noticeOrder.setDocumentNo(noticeOrderDto.getDocumentNo());
            noticeOrder.setId(noticeOrderDto.getId());
            noticeDetailList.forEach(detail -> detail.setDocumentNo(noticeOrder.getDocumentNo()));
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.SPLIT_OCS, true, noticeOrder.getDocumentNo());
        }
        catch (Exception e) {
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.SPLIT_OCS, false, e.getMessage());
            throw new BizException("-1", "\u62c6\u5355\u521b\u5efa\u901a\u77e5\u5355\u5931\u8d25\uff1a" + e.getMessage());
        }
        try {
            this.stockOutAndInToWmsUtil.doProcess(this.buildInWmsSendInfo(noticeOrder, noticeDetailList), "in");
        }
        catch (Exception e) {
            this.apiLogService.addRouteInternalDeal(allotOrderDto.getExternalSaleOrderNo(), RouteMultiAllotNodeEnum.SPLIT_WMS, false, e.getMessage());
            throw new BizException("-1", "\u62c6\u5355\u63a8\u9001WMS\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private List<CsInventoryOperateReqDto> inventoryOperateListBuild(List<AllotOrderDto> dto, String allotType) {
        log.info("\u6279\u91cf\u9884\u5360\u6570\u636e\u6784\u5efa\uff1a{}=={}", (Object)JSON.toJSONString(dto), (Object)allotType);
        ArrayList<CsInventoryOperateReqDto> csInventoryOperateReqDtoList = new ArrayList<CsInventoryOperateReqDto>();
        dto.forEach(allot -> {
            if (StringUtils.isBlank((CharSequence)allotType) || allot.getAllotType().equals(allotType)) {
                CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
                BeanUtil.copyProperties((Object)allot, (Object)csInventoryOperateReqDto, (String[])new String[0]);
                csInventoryOperateReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
                csInventoryOperateReqDto.setSourceNo(allot.getExternalSaleOrderNo());
                csInventoryOperateReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
                csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
                csInventoryOperateReqDto.setBusinessType(CsPcpBusinessTypeEnum.ALLOT_OUT.getCode());
                csInventoryOperateReqDto.setBatchCalculate(Boolean.valueOf(true));
                csInventoryOperateReqDto.setNegativeValidate(Integer.valueOf(1));
                ArrayList inventoryOperateCargoReqDtoList = new ArrayList();
                ArrayList itemDetailList = new ArrayList();
                allot.getItemDetailList().forEach(item -> {
                    CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
                    inventoryOperateCargoReqDto.setLongCode(item.getSkuCode());
                    inventoryOperateCargoReqDto.setWarehouseCode(item.getOutWarehouseCode());
                    inventoryOperateCargoReqDto.setChangeInventory(item.getQuantity());
                    inventoryOperateCargoReqDto.setBatch(item.getBatch());
                    inventoryOperateCargoReqDtoList.add(inventoryOperateCargoReqDto);
                });
                csInventoryOperateReqDto.setOperateCargoReqDtoList(inventoryOperateCargoReqDtoList);
                csInventoryOperateReqDtoList.add(csInventoryOperateReqDto);
            }
        });
        return csInventoryOperateReqDtoList;
    }

    private List<EasTransferOrderReqDto> easTransferOrderList(List<AllotOrderDto> dto, List<InOutNoticeOrderDetailDto> noticeDetailList) {
        log.info("\u6279\u91cf\u751f\u6210\u5355\u636e\u6570\u636e\u6784\u5efa\uff1a{}\uff1b{}", (Object)JacksonUtil.toJson(dto), (Object)JacksonUtil.toJson(noticeDetailList));
        ArrayList<EasTransferOrderReqDto> easTransferOrderReqDtoList = new ArrayList<EasTransferOrderReqDto>();
        dto.forEach(allot -> {
            EasTransferOrderReqDto easTransferOrderReqDto = new EasTransferOrderReqDto();
            easTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.EAS.getCode());
            easTransferOrderReqDto.setPlatformOrderNo(allot.getPlatformOrderNo());
            easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
            easTransferOrderReqDto.setExternalSaleOrderNo(allot.getExternalSaleOrderNo());
            easTransferOrderReqDto.setExternalPurchaseOrderNo(allot.getExternalPurchaseOrderNo());
            easTransferOrderReqDto.setAllotType(allot.getAllotType());
            easTransferOrderReqDto.setParentOrderNo(allot.getPlatformOrderParentNo());
            easTransferOrderReqDto.setSupplierCode(allot.getSupplierCode());
            easTransferOrderReqDto.setInWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getInWarehouseCode());
            easTransferOrderReqDto.setOutWarehouseCode(((AllotOrderDetailDto)allot.getItemDetailList().get(0)).getOutWarehouseCode());
            easTransferOrderReqDto.setRemark(allot.getRemark());
            Map<String, Object> extensionMap = this.getExtensionMap((AllotOrderDto)allot);
            easTransferOrderReqDto.setExtension(JSON.toJSONString(extensionMap));
            List<String> longCodes = allot.getItemDetailList().stream().map(AllotOrderDetailDto::getSkuCode).collect(Collectors.toList());
            Map<String, PcpItemRespDto> map = this.queryItemInfo(longCodes);
            ArrayList itemDetailList = new ArrayList();
            AllotOrderDetailDto item = (AllotOrderDetailDto)allot.getItemDetailList().get(0);
            allot.getNoticeDetailList().forEach(noticeDetail -> {
                PcpItemRespDto pcpItemRespDto;
                EasTransferOrderDetailReqDto easTransferOrderDetailReqDto = new EasTransferOrderDetailReqDto();
                easTransferOrderDetailReqDto.setLongCode(item.getSkuCode());
                easTransferOrderDetailReqDto.setQuantity(new BigDecimal(noticeDetail.getBatchQuantity()));
                easTransferOrderDetailReqDto.setBatch(item.getBatch());
                if (ObjectUtil.isNotEmpty((Object)map) && ObjectUtil.isNotEmpty(map.get(item.getSkuCode())) && ObjectUtil.isNotEmpty((Object)(pcpItemRespDto = (PcpItemRespDto)map.get(item.getSkuCode())).getVolume())) {
                    easTransferOrderDetailReqDto.setVolume(pcpItemRespDto.getVolume().multiply(item.getQuantity()).setScale(4, RoundingMode.DOWN));
                }
                Map<String, Object> itemExtensionMap = this.getItemExtensionMap(allot.getAllotType(), item);
                easTransferOrderDetailReqDto.setExtension(JSON.toJSONString(itemExtensionMap));
                noticeDetailList.forEach(sourceNoticeDetail -> {
                    if (noticeDetail.getId().equals(sourceNoticeDetail.getId())) {
                        easTransferOrderDetailReqDto.setProduceTime(sourceNoticeDetail.getProduceTime());
                        easTransferOrderDetailReqDto.setExpireTime(sourceNoticeDetail.getExpireTime());
                        easTransferOrderDetailReqDto.setBatch(sourceNoticeDetail.getBatch());
                    }
                });
                itemDetailList.add(easTransferOrderDetailReqDto);
            });
            easTransferOrderReqDto.setItemDetailList(itemDetailList);
            easTransferOrderReqDtoList.add(easTransferOrderReqDto);
        });
        log.info("\u6279\u91cf\u751f\u6210\u5355\u636e\u6570\u636e\u6784\u5efa\u7ed3\u679c\uff1a{}", (Object)JacksonUtil.toJson(easTransferOrderReqDtoList));
        return easTransferOrderReqDtoList;
    }

    private Map<String, Object> getItemExtensionMap(String allotType, AllotOrderDetailDto item) {
        HashMap<String, Object> itemExtensionMap = new HashMap<String, Object>();
        if (allotType.equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode())) {
            itemExtensionMap.put(EASExtendKeyEnum.SALE_ORDER_ENTRYID.code, item.getSaleOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_ENTRYID.code, item.getPurchaseOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code, item.getProjectNo());
            itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code, item.getIfOnline());
            itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code, item.getTrackPlan());
        } else {
            itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID.code, item.getPurchaseOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.ENTRY_ID2.code, item.getSaleOrderDetailId());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_PRICE.code, item.getPrice());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_SALE_PRICE.code, item.getSalePrice());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_ACTUALLY_AMOUNT.code, item.getActuallyAmount());
            itemExtensionMap.put(EASExtendKeyEnum.ITEM_PAYABLE_AMOUNT.code, item.getPayableAmount());
            itemExtensionMap.put(EASExtendKeyEnum.DISCOUNT_AMOUNT.code, item.getDiscountAmount());
            itemExtensionMap.put(EASExtendKeyEnum.TAX_RATE.code, item.getTaxRate());
            itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code, item.getProjectNo());
            itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_IF_ONLINE.code, item.getIfOnline());
            itemExtensionMap.put(EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code, item.getTrackPlan());
        }
        return itemExtensionMap;
    }

    private Map<String, Object> getExtensionMap(AllotOrderDto allot) {
        HashMap<String, Object> extensionMap = new HashMap<String, Object>();
        if (allot.getAllotType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL_BA.getCode())) {
            extensionMap.put(EASExtendKeyEnum.IN_INVENTORY_ORG_CODE.code, allot.getInInventoryOrgCode());
            extensionMap.put(EASExtendKeyEnum.OUT_INVENTORY_ORG_CODE.code, allot.getOutInventoryOrgCode());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_ID.code, allot.getExternalSaleOrderId());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_NO.code, allot.getExternalSaleOrderNo());
            extensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_ID.code, allot.getExternalPurchaseOrderId());
            extensionMap.put(EASExtendKeyEnum.PURCHASE_ORDER_NO.code, allot.getExternalPurchaseOrderNo());
            extensionMap.put(EASExtendKeyEnum.SALE_ORG_CODE.code, allot.getSaleOrganizationCode());
            extensionMap.put(EASExtendKeyEnum.SALE_CUS_CODE.code, allot.getSaleCustomerCode());
            extensionMap.put(EASExtendKeyEnum.ITEM_TOTAL_AMOUNT.code, allot.getItemTotalAmount());
        } else {
            if (allot.getAllotType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode())) {
                extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getInInventoryOrgCode());
            } else {
                extensionMap.put(EASExtendKeyEnum.F_COMPANY_ORG.code, allot.getOutInventoryOrgCode());
            }
            extensionMap.put(EASExtendKeyEnum.SOURCE_NUM.code, allot.getExternalPurchaseOrderNo());
            extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_NO.code, allot.getExternalSaleOrderNo());
            extensionMap.put(EASExtendKeyEnum.SALE_ORDER_ID.code, allot.getExternalSaleOrderId());
            extensionMap.put(EASExtendKeyEnum.SOURCE_ID.code, allot.getExternalPurchaseOrderId());
            extensionMap.put(EASExtendKeyEnum.SALE_ORG_CODE.code, allot.getSaleOrganizationCode());
            extensionMap.put(EASExtendKeyEnum.SALE_CUS_CODE.code, allot.getSaleCustomerCode());
            extensionMap.put(EASExtendKeyEnum.ITEM_TOTAL_AMOUNT.code, allot.getItemTotalAmount());
        }
        extensionMap.put(EASExtendKeyEnum.ROUTE_DEAL_TRANSFER_NO.code, allot.getTransferOrderNo());
        extensionMap.put(EASExtendKeyEnum.ROUTE_DEAL_NOTICE_NO.code, allot.getInNoticeOrderNo());
        String ids = allot.getNoticeDetailList().stream().map(Batch::getId).map(String::valueOf).collect(Collectors.joining(","));
        extensionMap.put(EASExtendKeyEnum.ROUTE_DEAL_DETAIL_ID.code, ids);
        return extensionMap;
    }

    private Map<String, PcpItemRespDto> queryItemInfo(List<String> longCodes) {
        try {
            log.info("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(longCodes));
            if (CollectionUtils.isEmpty(longCodes)) {
                return new HashMap<String, PcpItemRespDto>();
            }
            List itemList = (List)RestResponseHelper.extractData((RestResponse)this.pcpItemQueryApi.queryItemByItemLongCodes(longCodes));
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                return itemList.stream().collect(Collectors.toMap(PcpItemRespDto::getLongCode, entity -> entity));
            }
            return new HashMap<String, PcpItemRespDto>();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e3b\u6570\u636e\u4fe1\u606f\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String buildInWmsSendInfo(CsOutNoticeOrderRespDto outNoticeOrderEo, List<InOutNoticeOrderDetailDto> detailEoList) {
        WmsStockEntryOrderReqDto wmsStockEntryOrderReqDto = new WmsStockEntryOrderReqDto();
        CsWarehouseAddressParamQueryDto addressDto = new CsWarehouseAddressParamQueryDto();
        addressDto.setWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        List csWarehouseAddressRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csWarehouseAddressApi.queryParam(addressDto));
        if (CollectionUtil.isNotEmpty((Collection)csWarehouseAddressRespDtoList)) {
            CubeBeanUtils.copyProperties((Object)wmsStockEntryOrderReqDto, csWarehouseAddressRespDtoList.get(0), (String[])new String[0]);
        }
        wmsStockEntryOrderReqDto.setExtensionExternal(this.getExtensionExternal(outNoticeOrderEo.getRelevanceNo()));
        wmsStockEntryOrderReqDto.setDocumentNo(outNoticeOrderEo.getDocumentNo());
        wmsStockEntryOrderReqDto.setRelevanceNo(outNoticeOrderEo.getRelevanceNo());
        wmsStockEntryOrderReqDto.setThirdOrderNo(outNoticeOrderEo.getExternalOrderNo());
        wmsStockEntryOrderReqDto.setOrderCreateTime(DateUtils.formatYMDHms(outNoticeOrderEo.getCreateTime()));
        wmsStockEntryOrderReqDto.setRemark(outNoticeOrderEo.getRemark());
        wmsStockEntryOrderReqDto.setOrderType(outNoticeOrderEo.getOrderType());
        wmsStockEntryOrderReqDto.setBusinessType(outNoticeOrderEo.getBusinessType());
        wmsStockEntryOrderReqDto.setWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        wmsStockEntryOrderReqDto.setLogicWarehouseCode(outNoticeOrderEo.getInLogicWarehouseCode());
        wmsStockEntryOrderReqDto.setEnableBatch(!YesNoEnum.YES.getValue().equals(outNoticeOrderEo.getNoBatch()));
        List<WmsItemLine> itemLines = this.getWmsItemLines(detailEoList);
        CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(wmsStockEntryOrderReqDto.getLogicWarehouseCode()));
        if (ObjectUtil.isNotEmpty((Object)warehouseRespDto)) {
            wmsStockEntryOrderReqDto.setOrganizationCode(warehouseRespDto.getCargoEscheatageId() + "");
            wmsStockEntryOrderReqDto.setOrganizationName(warehouseRespDto.getCargoEscheatageName());
        }
        CsPhysicsWarehouseQueryDto warehouseQueryDto = new CsPhysicsWarehouseQueryDto();
        warehouseQueryDto.setWarehouseCode(wmsStockEntryOrderReqDto.getWarehouseCode());
        List physicsWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseApi.queryByParam(warehouseQueryDto));
        if (CollectionUtil.isNotEmpty((Collection)physicsWarehouseRespDtoList)) {
            wmsStockEntryOrderReqDto.setPhysicsOrganizationCode(((CsPhysicsWarehouseRespDto)physicsWarehouseRespDtoList.get(0)).getOrganizationCode());
            wmsStockEntryOrderReqDto.setPhysicsOrganizationName(((CsPhysicsWarehouseRespDto)physicsWarehouseRespDtoList.get(0)).getOrganizationName());
        }
        wmsStockEntryOrderReqDto.setItemLines(itemLines);
        return JSON.toJSONString((Object)wmsStockEntryOrderReqDto);
    }

    private List<WmsItemLine> getWmsItemLines(List<InOutNoticeOrderDetailDto> detailEoList) {
        ArrayList<WmsItemLine> itemLines = new ArrayList<WmsItemLine>();
        for (InOutNoticeOrderDetailDto InOutNoticeOrderDetailEo : detailEoList) {
            WmsItemLine itemLine = new WmsItemLine();
            itemLine.setCargoCode(InOutNoticeOrderDetailEo.getSkuCode());
            itemLine.setCargoName(InOutNoticeOrderDetailEo.getSkuName());
            itemLine.setBatch(InOutNoticeOrderDetailEo.getBatch());
            itemLine.setPlanQuantity(InOutNoticeOrderDetailEo.getPlanQuantity());
            itemLine.setTradeOrderItemId(null != InOutNoticeOrderDetailEo.getPreOrderItemId() ? InOutNoticeOrderDetailEo.getPreOrderItemId().toString() : InOutNoticeOrderDetailEo.getId().toString());
            itemLines.add(itemLine);
            String productDate = null != InOutNoticeOrderDetailEo.getProduceTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo.getProduceTime()) : null;
            String arrivalDate = null != InOutNoticeOrderDetailEo.getExpireTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo.getExpireTime()) : null;
            itemLine.setProductDate(productDate);
            itemLine.setArrivalDate(arrivalDate);
        }
        return itemLines;
    }

    private String getExtensionExternal(String relevanceNo) {
        log.info("\u83b7\u53d6\u51fa\u5e93\u7ed3\u679c\u5355\uff1a{}", (Object)relevanceNo);
        CsOutResultOrderQueryDto queryDto = new CsOutResultOrderQueryDto();
        queryDto.setRelevanceNo(relevanceNo);
        List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryByParam(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            return ((CsOutResultOrderRespDto)respDtoList.get(0)).getExtensionExternal();
        }
        return null;
    }
}

