/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressResolutionUtil {
    private static String addressDuplicate(String address) {
        if (address.startsWith("\u5317\u4eac\u5e02") || address.startsWith("\u5929\u6d25\u5e02") || address.startsWith("\u4e0a\u6d77\u5e02") || address.startsWith("\u91cd\u5e86\u5e02")) {
            String substring = address.substring(0, 2);
            address = substring + address;
        }
        return address;
    }

    public static List<Map<String, String>> addressResolution(String address) {
        address = AddressResolutionUtil.addressDuplicate(address);
        String regex = "(?<province>[^\u7701]+\u81ea\u6cbb\u533a|\u5317\u4eac|\u5929\u6d25|\u91cd\u5e86|\u4e0a\u6d77|.*?\u7701|.*?\u884c\u653f\u533a|.*?\u5e02)(?<city>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5e02|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|.*?\u53bf)(?<county>[^\u53bf]+\u53bf|.*?\u533a|.+\u5e02|.+\u65d7|.+\u6d77\u57df|.+\u5c9b)?(?<town>[^\u533a].+\u9547)?(?<village>.*)";
        Matcher m = Pattern.compile(regex).matcher(address);
        String province = null;
        String city = null;
        String county = null;
        String town = null;
        String village = null;
        ArrayList<Map<String, String>> table = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, String> row = null;
        while (m.find()) {
            row = new LinkedHashMap<String, String>();
            province = m.group("province");
            row.put("province", province == null ? "" : province.trim());
            city = m.group("city");
            row.put("city", city == null ? "" : city.trim());
            county = m.group("county");
            row.put("county", county == null ? "" : county.trim());
            town = m.group("town");
            row.put("town", town == null ? "" : town.trim());
            village = m.group("village");
            row.put("village", village == null ? "" : village.trim());
            table.add(row);
        }
        return table;
    }
}

