/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.config.RqWmsConfig;
import com.dtyunxi.tcbj.center.openapi.api.enums.RqWmsApiEnum;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=1)
@Component
public class RqWmsClient {
    private static final Logger log = LoggerFactory.getLogger(RqWmsClient.class);
    @Autowired
    private RqWmsConfig rqWmsConfig;
    private static RqWmsClient rqWmsClient;
    private static RqWmsConfig RQ_WMS_CONFIG;

    @PostConstruct
    public void init() {
        rqWmsClient = new RqWmsClient();
        RQ_WMS_CONFIG = this.rqWmsConfig;
    }

    public static RestResponse<String> execute(Map<String, Object> param, RqWmsApiEnum rqWmsApiEnum) {
        String userName = RQ_WMS_CONFIG.getUserName();
        String password = RQ_WMS_CONFIG.getPassword();
        String apiUrl = RQ_WMS_CONFIG.getUrl();
        try {
            String url = apiUrl + rqWmsApiEnum.getApiLink();
            log.info("\u6267\u884c\u8363\u5e86WMS API\u8bf7\u6c42url:{} ", (Object)url);
            HttpRequest post = HttpUtil.createPost((String)url);
            post.basicAuth(userName, password);
            String paramStr = JSON.toJSONString(param);
            post.body(paramStr);
            TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
            TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)paramStr);
            post.timeout(RQ_WMS_CONFIG.getTimeout().intValue());
            HttpResponse httpResponse = post.execute();
            log.info("\u6267\u884c\u8363\u5e86WMS API\u8bf7\u6c42\u54cd\u5e94{}", (Object)httpResponse.body());
            TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
            TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)httpResponse.body());
            TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
            return new RestResponse((Object)httpResponse.body());
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u8363\u5e86WMS API\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return new RestResponse("100000", e.getMessage());
        }
    }
}

