/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerOrgPartnerApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerOrgPartnerReqDto;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="tcbj-tenant-sync-queue")
public class TenantUpdateProcessor
implements IMessageProcessor<Object> {
    private static final Logger log = LoggerFactory.getLogger(TenantUpdateProcessor.class);
    @Resource
    private ICustomerOrgPartnerApi customerOrgPartnerApi;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageResponse process(Object message) {
        MDC.put((String)"yes.req.requestId", (String)UUID.randomUUID().toString().replace("-", ""));
        log.info("\u79df\u6237\u4fe1\u606f\u66f4\u65b0\u540c\u6b65\uff1a{}", (Object)JSON.toJSONString((Object)message));
        Mutex mutex = null;
        try {
            CustomerOrgPartnerReqDto reqDto = (CustomerOrgPartnerReqDto)JSON.parseObject((String)message.toString(), CustomerOrgPartnerReqDto.class);
            log.info("\u6570\u636e\u8f6c\u6362\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            if (StringUtils.isBlank((CharSequence)reqDto.getPartnerId())) {
                throw new BizException("-1", "\u53c2\u6570\u5f02\u5e38\uff0c\u7ecf\u9500\u5546ID\u4e3a\u7a7a");
            }
            mutex = this.lockService.lock("TenantUpdateProcessor", reqDto.getPartnerId(), 10);
            if (null == mutex) {
                throw new BizException("\u79df\u6237\u4fe1\u606f\u66f4\u65b0\u540c\u6b65\u5f02\u5e38\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            this.customerOrgPartnerApi.updateCustomerOrgPartner(reqDto);
            if (null == mutex) return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error("\u79df\u6237\u4fe1\u606f\u66f4\u65b0\u540c\u6b65\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.SUCCESS;
        }
        finally {
            if (null != mutex) {
                this.lockService.unlock(mutex);
            }
        }
        this.lockService.unlock(mutex);
        return MessageResponse.SUCCESS;
    }
}

