/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.app.open.biz.service.ILimitsService;
import com.dtyunxi.tcbj.app.open.biz.service.IMapService;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.Geocode;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MapRespDto;
import com.dtyunxi.util.HttpUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MapServiceImpl
implements IMapService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapServiceImpl.class);
    @Value(value="${autoNavi.map.geocode.url}")
    private String autoNaviMapUrl;
    @Value(value="${autoNavi.map.access.token}")
    private String autoNaviKey;
    @Resource
    ILimitsService limitsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapRespDto parserStoreAddress(String address) {
        this.limitsService.syncReportInspected("2021-01-01");
        MapRespDto mapRespDto = null;
        try {
            StringBuffer param = new StringBuffer();
            param.append("key=").append(this.autoNaviKey);
            param.append("&").append("address=").append(address);
            String body = HttpUtil.sendGet((String)this.autoNaviMapUrl, (String)param.toString());
            LOGGER.info("req\u3010\u9ad8\u5fb7\u3011\u83b7\u53d6\u5730\u5740\u6570\u636e response :{}", (Object)body);
            mapRespDto = (MapRespDto)JSON.parseObject((String)body, MapRespDto.class);
            if (CollectionUtils.isNotEmpty((Collection)mapRespDto.getGeocodes())) {
                Geocode geocode = (Geocode)mapRespDto.getGeocodes().stream().findFirst().get();
                String location = geocode.getLocation();
                geocode.setLog(location.substring(0, location.indexOf(",")));
                geocode.setLat(location.substring(location.indexOf(",") + 1, location.length()));
                mapRespDto.setGeocodes(Arrays.asList(geocode));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u9ad8\u5fb7\u5730\u56fe\u3011\u9006\u5730\u5740\u89e3\u6790\u7ecf\u7eac\u5ea6\u5f02\u5e38");
            e.printStackTrace();
        }
        finally {
            return mapRespDto;
        }
    }
}

