/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.app.open.biz.service.IGiftPackageInfoService;
import com.dtyunxi.tcbj.app.open.dao.das.GiftPackageInfoDas;
import com.dtyunxi.tcbj.app.open.dao.eo.GiftPackageInfoEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.GiftPackageInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.GiftPackageInfoRespDto;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GiftPackageInfoServiceImpl
implements IGiftPackageInfoService {
    private static final Logger logger = LoggerFactory.getLogger(GiftPackageInfoServiceImpl.class);
    @Resource
    private GiftPackageInfoDas giftPackageInfoDas;
    @Resource
    private IExternalOutService externalOutService;

    @Override
    public Long addGiftPackageInfo(GiftPackageInfoReqDto addReqDto) {
        GiftPackageInfoEo giftPackageInfoEo = new GiftPackageInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)giftPackageInfoEo);
        this.giftPackageInfoDas.insert((BaseEo)giftPackageInfoEo);
        return giftPackageInfoEo.getId();
    }

    @Override
    public void modifyGiftPackageInfo(GiftPackageInfoReqDto modifyReqDto) {
        GiftPackageInfoEo giftPackageInfoEo = new GiftPackageInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)giftPackageInfoEo);
        this.giftPackageInfoDas.updateSelective((BaseEo)giftPackageInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeGiftPackageInfo(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.giftPackageInfoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public GiftPackageInfoRespDto queryById(Long id) {
        GiftPackageInfoEo giftPackageInfoEo = (GiftPackageInfoEo)this.giftPackageInfoDas.selectByPrimaryKey(id);
        GiftPackageInfoRespDto giftPackageInfoRespDto = new GiftPackageInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)giftPackageInfoEo, (BaseVo)giftPackageInfoRespDto);
        return giftPackageInfoRespDto;
    }

    @Override
    public PageInfo<GiftPackageInfoRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        GiftPackageInfoReqDto giftPackageInfoReqDto = (GiftPackageInfoReqDto)JSON.parseObject((String)filter, GiftPackageInfoReqDto.class);
        GiftPackageInfoEo giftPackageInfoEo = new GiftPackageInfoEo();
        DtoHelper.dto2Eo((BaseVo)giftPackageInfoReqDto, (BaseEo)giftPackageInfoEo);
        PageInfo eoPageInfo = this.giftPackageInfoDas.selectPage((BaseEo)giftPackageInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, GiftPackageInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<GiftPackageInfoRespDto> queryList(GiftPackageInfoReqDto reqDto) {
        logger.info("\u67e5\u8be2\u793c\u76d2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getProNo()) || StringUtils.isBlank((CharSequence)reqDto.getLot())) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570proNo\u3001lot\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GiftPackageInfoEo queryEo = new GiftPackageInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)queryEo);
        List eoList = this.giftPackageInfoDas.select((BaseEo)queryEo);
        if (CollectionUtil.isNotEmpty((Collection)eoList)) {
            ArrayList<GiftPackageInfoRespDto> dtoList = new ArrayList<GiftPackageInfoRespDto>();
            DtoHelper.eoList2DtoList((Collection)eoList, dtoList, GiftPackageInfoRespDto.class);
            return dtoList;
        }
        if (ObjectUtils.isNotEmpty((Object)reqDto.getIfSync()) && reqDto.getIfSync().booleanValue()) {
            logger.info("\u5e93\u5185\u4e0d\u5b58\u5728\u6570\u636e\uff0c\u53bb\u7b2c\u4e09\u65b9\u7cfb\u7edf\u67e5\u8be2");
            List<GiftPackageInfoRespDto> list = this.externalOutService.queryGiftPackageInfo(reqDto);
            ArrayList<GiftPackageInfoReqDto> reqDtoList = new ArrayList<GiftPackageInfoReqDto>();
            CubeBeanUtils.copyCollection(reqDtoList, list, GiftPackageInfoReqDto.class);
            this.addBatchGiftPackageInfo(reqDtoList);
            return list;
        }
        return new ArrayList<GiftPackageInfoRespDto>();
    }

    @Override
    public Map<String, List<GiftPackageInfoReqDto>> queryByProNoAndLot(GiftPackageInfoReqDto reqDto) {
        if (CollectionUtil.isEmpty((Collection)reqDto.getProNoList()) || CollectionUtil.isEmpty((Collection)reqDto.getLotList())) {
            throw new BizException("-1", "\u67e5\u8be2\u793c\u76d2\u4fe1\u606f\u6709\u8bef");
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.giftPackageInfoDas.filter().eq((Object)"dr", (Object)0)).in(CollectionUtil.isNotEmpty((Collection)reqDto.getProNoList()), (Object)"pro_no", (Collection)reqDto.getProNoList())).in(CollectionUtil.isNotEmpty((Collection)reqDto.getLotList()), (Object)"lot", (Collection)reqDto.getLotList())).list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, GiftPackageInfoReqDto.class);
        return dtoList.stream().collect(Collectors.groupingBy(m -> m.getProNo() + m.getLot()));
    }

    @Override
    public void addBatchGiftPackageInfo(List<GiftPackageInfoReqDto> dtoList) {
        logger.info("\u6279\u91cf\u65b0\u589e\u793c\u76d2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List orderNos = dtoList.stream().map(GiftPackageInfoReqDto::getOrderNo).collect(Collectors.toList());
        this.giftPackageInfoDas.deleteByOrderNo(orderNos);
        ArrayList insEoList = new ArrayList();
        DtoHelper.dtoList2EoList(dtoList, insEoList, GiftPackageInfoEo.class);
        this.giftPackageInfoDas.insertBatch(insEoList);
    }
}

