/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.config.FinanceZTConfig;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalFinanceZTService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.FinanceZTService;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTAllotOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTAllotOrderRespDto;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTDealOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTSmSupplyInfoDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExternalFinanceZTServiceImpl
implements IExternalFinanceZTService {
    private static final Logger logger = LoggerFactory.getLogger(ExternalFinanceZTServiceImpl.class);
    @Resource
    private FinanceZTConfig financeZTConfig;
    @Resource
    private FinanceZTService financeZTService;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private IItemExtendApi itemExtendApi;
    @Resource
    private IItemExtendQueryApi iItemExtendQueryApi;

    @Override
    public FinanceZTAllotOrderRespDto pushAllotOrder(FinanceZTAllotOrderDto reqDto) {
        logger.info("\u63a8\u9001\u5e93\u5b58\u8c03\u62e8pushAllotOrder\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setYd_interoutwarehouse(this.e3WarehouseCode(reqDto.getYd_interoutwarehouse()));
        reqDto.setYd_interinwarehouse(this.e3WarehouseCode(reqDto.getYd_interinwarehouse()));
        FinanceZTAllotOrderRespDto respDto = this.financeZTService.executePost(this.financeZTConfig.getInventoryAllotSaveApi(), BeanUtil.beanToMap((Object)reqDto), FinanceZTAllotOrderRespDto.class);
        logger.info("\u63a8\u9001\u5e93\u5b58\u8c03\u62e8pushAllotOrder\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        return respDto;
    }

    @Override
    public List<FinanceZTSmSupplyInfoDto> fetchAllSmSupplyInfo() {
        logger.info("==========\u5f00\u59cb\u540c\u6b65\u7269\u6599\u8d39\u7528==========");
        List<FinanceZTSmSupplyInfoDto> list = this.financeZTService.executePost(this.financeZTConfig.getSmSupplyinfoApi(), new TypeReference<List<FinanceZTSmSupplyInfoDto>>(){});
        logger.info("\u62c9\u53d6\u4fc3\u9500\u7269\u6599\u4ef7\u683c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(list));
        CompletableFuture.runAsync(() -> list.forEach(it -> {
            if (it.getFprice().compareTo(BigDecimal.ZERO) == 0 && !it.getFnumber().startsWith("A.A")) {
                ItemExtendReqDto itemExtendReq = new ItemExtendReqDto();
                itemExtendReq.setItemCode(it.getFnumber());
                List itemExtendRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iItemExtendQueryApi.queryParam(itemExtendReq));
                if (CollectionUtil.isNotEmpty((Collection)itemExtendRespDtos) && ((ItemExtendRespDto)itemExtendRespDtos.get(0)).getClaimPrice() != null) {
                    return;
                }
            }
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            itemExtendReqDto.setItemCode(it.getFnumber());
            if (it.getFnumber().startsWith("F.A")) {
                itemExtendReqDto.setRecommendPrice(it.getFprice());
            }
            itemExtendReqDto.setClaimPrice(it.getFprice());
            this.itemExtendApi.modifyPrice(itemExtendReqDto);
        }));
        return list;
    }

    @Override
    public FinanceZTAllotOrderRespDto pushDealTransBill(FinanceZTDealOrderDto reqDto) {
        logger.info("\u63a8\u9001\u5185\u90e8\u4ea4\u6613\u5e93\u5b58\u8c03\u62e8\u5355\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        FinanceZTAllotOrderRespDto respDto = this.financeZTService.executePost(this.financeZTConfig.getPushOcsDealTransBillAPi(), BeanUtil.beanToMap((Object)reqDto), FinanceZTAllotOrderRespDto.class);
        logger.info("\u63a8\u9001\u5e93\u5b58\u8c03\u62e8pushAllotOrder\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        return respDto;
    }

    private String e3WarehouseCode(String warehouseCode) {
        CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(warehouseCode));
        return warehouseRespDto.getEasWarehouseCode();
    }
}

