/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.order;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.customer.CustomerHelper;
import com.dtyunxi.tcbj.app.open.biz.utils.ErpOrderAssert;
import com.dtyunxi.tcbj.app.open.biz.utils.OrderExceptionEnum;
import com.dtyunxi.tcbj.app.open.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.order.ErpOrderItemReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.order.ErpSubmitOrderReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.IAddressQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemDetailBatchReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ShelfExtReqDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SubmitOrderHelper {
    private static final Logger log = LoggerFactory.getLogger(SubmitOrderHelper.class);
    @Autowired
    private ISellerExtQueryApi sellerExtQueryApi;
    @Autowired
    private IShopExtQueryApi shopExtQueryApi;
    @Autowired
    private IAddressQueryApi addressQueryApi;
    @Autowired
    private IItemExtQueryApi itemExtQueryApi;
    @Value(value="${com.dtyunxi.yundt.module.trade.order.effectiveTime:1440}")
    private Integer effectiveTime;
    @Autowired
    private CustomerHelper customerHelper;

    public OrderReqDto convertOrderReqDto(ErpSubmitOrderReqDto erpSubmitOrderReqDto) {
        CustomerRespDto customerRespDto = this.customerHelper.queryCustomerByThirdId(erpSubmitOrderReqDto.getPartnerId());
        ErpOrderAssert.notNull(customerRespDto, OrderExceptionEnum.DATA_EXISTS, "\u5ba2\u6237");
        log.info("[erp\u63d0\u4ea4\u8ba2\u5355],[\u5ba2\u6237\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerRespDto.getMerchantId()));
        ErpOrderAssert.notNull(sellerRespDto, OrderExceptionEnum.DATA_EXISTS, "\u5546\u5bb6");
        log.info("[erp\u63d0\u4ea4\u8ba2\u5355],[\u5546\u5bb6\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)sellerRespDto));
        List shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerId(sellerRespDto.getId()));
        ErpOrderAssert.isTrue(CollectionUtils.isNotEmpty((Collection)shopBaseDtos), OrderExceptionEnum.DATA_EXISTS, "\u5e97\u94fa");
        log.info("[erp\u63d0\u4ea4\u8ba2\u5355],[\u5e97\u94fa\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)shopBaseDtos));
        AddressRespDto addressRespDto = (AddressRespDto)RestResponseHelper.extractData((RestResponse)this.addressQueryApi.queryAddressById(erpSubmitOrderReqDto.getAddressId()));
        ErpOrderAssert.notNull(addressRespDto, OrderExceptionEnum.DATA_EXISTS, "\u5730\u5740\u4fe1\u606f");
        log.info("[erp\u63d0\u4ea4\u8ba2\u5355],[\u5730\u5740\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)addressRespDto));
        List itemCodeList = erpSubmitOrderReqDto.getProducts().stream().map(ErpOrderItemReqDto::getNo).distinct().collect(Collectors.toList());
        ItemDetailBatchReqDto itemDetailBatchReqDto = new ItemDetailBatchReqDto();
        itemDetailBatchReqDto.setItemCodes(itemCodeList);
        itemDetailBatchReqDto.setField("attributes,sku,medias");
        List itemDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApi.queryItemDetailByItemIds(itemDetailBatchReqDto));
        log.info("[erp\u63d0\u4ea4\u8ba2\u5355],[\u5546\u54c1\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)itemDetailRespDtos));
        HashSet itemIdSet = Sets.newHashSet();
        HashSet skuIds = Sets.newHashSet();
        for (ItemDetailRespDto itemDetailRespDto : itemDetailRespDtos) {
            ItemRespDto item = itemDetailRespDto.getItem();
            if (item != null) {
                itemIdSet.add(item.getId());
            }
            if (!CollectionUtils.isNotEmpty((Collection)itemDetailRespDto.getItemSkuList())) continue;
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)itemDetailRespDto.getItemSkuList().get(0);
            skuIds.add(itemSkuRespDto.getId());
        }
        ShelfExtReqDto shelfExtReqDto = new ShelfExtReqDto();
        shelfExtReqDto.setItemIds((Set)itemIdSet);
        shelfExtReqDto.setSkuIds(new ArrayList(skuIds));
        shelfExtReqDto.setShopIds((List)Lists.newArrayList((Object[])new Long[]{((ShopBaseDto)shopBaseDtos.get(0)).getId()}));
        shelfExtReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        List itemShelfRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApi.queryItemShelf(shelfExtReqDto));
        log.info("[erp\u63d0\u4ea4\u8ba2\u5355],[\u4e0a\u67b6\u4fe1\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)itemShelfRespDtos));
        OrderReqDto orderReqDto = new OrderReqDto();
        orderReqDto.setSubmitType("1");
        Integer audit = 1;
        orderReqDto.setAuditType(audit);
        orderReqDto.setInstanceId(Long.valueOf(1254039287584232622L));
        orderReqDto.setTenantId(Long.valueOf(1L));
        Integer totalItemNum = erpSubmitOrderReqDto.getProducts().stream().map(ErpOrderItemReqDto::getQuantity).reduce(0, (a, b) -> a + b);
        orderReqDto.setTotalItemNum(totalItemNum);
        orderReqDto.setBuyerRemark(erpSubmitOrderReqDto.getRemark());
        orderReqDto.setBizType("1");
        orderReqDto.setSaleChannel(SaleChannelEnum.SALECHANNEL_ZYSC.getCode());
        orderReqDto.setFreightAmount(BigDecimal.ZERO);
        orderReqDto.setUserSrc("icommerceb");
        orderReqDto.setPlatformDiscountAmount(BigDecimal.ZERO);
        orderReqDto.setShopDiscountAmount(BigDecimal.ZERO);
        orderReqDto.setTotalRebateAmount(BigDecimal.ZERO);
        if (this.effectiveTime != null && this.effectiveTime > 0) {
            orderReqDto.setCloseTime(DateTime.now().plusMinutes(this.effectiveTime.intValue()).toDate());
        }
        orderReqDto.setBusType(Integer.valueOf(0));
        ShopBaseDto shopBaseDto = (ShopBaseDto)shopBaseDtos.get(0);
        orderReqDto.setShopType(shopBaseDto.getType().toString());
        orderReqDto.setSellerId(sellerRespDto.getId().toString());
        orderReqDto.setShopId(shopBaseDto.getId().toString());
        OrderAddressReqDto orderAddressReqDto = this.convertOrderAddress(addressRespDto);
        HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
        addrExtFields.put("customerId", customerRespDto.getId());
        addrExtFields.put("customerName", customerRespDto.getName());
        orderAddressReqDto.setExtFields(addrExtFields);
        orderReqDto.setDeliveryAddress(orderAddressReqDto);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("placeType", 2);
        map.put("payStatus", "WAIT_PAY");
        map.put("customerCode", customerRespDto.getCode());
        map.put("origOrderId", customerRespDto.getMerchantId());
        orderReqDto.setExtFields(map);
        orderReqDto.setCustomerId(customerRespDto.getId().toString());
        orderReqDto.setAmountDetail("");
        orderReqDto.setMktChannel("");
        orderReqDto.setPayUserId("");
        orderReqDto.setPlaceUserId(erpSubmitOrderReqDto.getUserId().toString());
        orderReqDto.setSellerSrc("");
        orderReqDto.setDeviceType("");
        orderReqDto.setOrderItems(this.convertToTradeItemReqDtoList(shopBaseDto, erpSubmitOrderReqDto.getProducts(), itemDetailRespDtos, itemShelfRespDtos));
        String orderNo = TradeUtil.generateOrderNo(customerRespDto.getCode());
        orderReqDto.setOrderNo(orderNo);
        orderReqDto.setDeliveryType(this.checkDeliveryType(customerRespDto, sellerRespDto));
        orderReqDto.setIsCycleBuy(Integer.valueOf(0));
        orderReqDto.setTotalRebateAmount(BigDecimal.ZERO);
        orderReqDto.setIsSplit(Integer.valueOf(0));
        orderReqDto.setUserId(erpSubmitOrderReqDto.getUserId().toString());
        return orderReqDto;
    }

    private List<TradeItemReqDto> convertToTradeItemReqDtoList(ShopBaseDto shopBaseDto, List<ErpOrderItemReqDto> products, List<ItemDetailRespDto> itemDetailRespDtos, List<ItemShelfRespDto> itemShelfRespDtos) {
        ArrayList tradeItemReqDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(products)) {
            Map<String, ItemDetailRespDto> itemDetailMap = itemDetailRespDtos.stream().collect(Collectors.toMap(e -> this.getItemCode((ItemDetailRespDto)e), e -> e, (e1, e2) -> e1));
            Map itemShelfMap = itemShelfRespDtos.stream().collect(Collectors.toMap(ItemShelfRespDto::getSkuId, Function.identity()));
            for (ErpOrderItemReqDto product : products) {
                Map skuAttr;
                ItemDetailRespDto itemDetailRespDto = itemDetailMap.get(product.getNo());
                ErpOrderAssert.notNull(itemDetailRespDto, OrderExceptionEnum.DATA_EXISTS, "\u5546\u54c1\u4fe1\u606f\uff1a" + product.getNo());
                ItemShelfRespDto itemShelfRespDto = (ItemShelfRespDto)itemShelfMap.get(((ItemSkuRespDto)itemDetailRespDto.getItemSkuList().get(0)).getId());
                ErpOrderAssert.notNull(itemShelfRespDto, OrderExceptionEnum.ERROR_MSG, "\u5546\u54c1\u672a\u4e0a\u67b6\uff1a" + product.getNo());
                ItemRespDto item = itemDetailRespDto.getItem();
                ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)itemDetailRespDto.getItemSkuList().get(0);
                TradeItemReqDto tradeItem = new TradeItemReqDto();
                tradeItem.setItemSerial(String.valueOf(item.getId()));
                tradeItem.setSkuSerial(String.valueOf(itemSkuRespDto.getId()));
                tradeItem.setSellerId(String.valueOf(shopBaseDto.getSellerId()));
                tradeItem.setItemCode(item.getCode());
                tradeItem.setCargoSerial(itemSkuRespDto.getCargoCode());
                tradeItem.setSubType(item.getSubType());
                tradeItem.setSkuCode(itemSkuRespDto.getCode());
                tradeItem.setSkuName(itemSkuRespDto.getName());
                tradeItem.setItemName(item.getName());
                tradeItem.setItemNum(product.getQuantity());
                tradeItem.setItemSrc("icommerceb");
                tradeItem.setBrandSerial(String.valueOf(item.getBrandId()));
                tradeItem.setCatalogSerial(String.valueOf(item.getDirId()));
                tradeItem.setDiscounted(Integer.valueOf(0));
                tradeItem.setIsNotCondition(Integer.valueOf(0));
                tradeItem.setItemType(item.getType());
                tradeItem.setBusType(item.getBusType() == null ? ItemBusTypeEnum.ORDINARY.getType() : item.getBusType());
                tradeItem.setItemVer(String.valueOf(item.getVersion()));
                tradeItem.setPriceType(Integer.valueOf(0));
                if (item.getSupplierId() != null) {
                    tradeItem.setSupplierSerial(String.valueOf(item.getSupplierId()));
                }
                if (null != (skuAttr = (Map)ObjectHelper.Json2Bean((String)itemSkuRespDto.getAttr(), Map.class))) {
                    String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
                    tradeItem.setSkuDesc(skuDesc);
                }
                tradeItem.setCargoSrc("icommerceb");
                tradeItem.setCargoSerial(itemSkuRespDto.getCargoCode());
                tradeItem.setShopId(String.valueOf(shopBaseDto.getId()));
                tradeItem.setShopType(String.valueOf(shopBaseDto.getType()));
                tradeItem.setInstanceId(item.getInstanceId());
                tradeItem.setTenantId(item.getTenantId());
                HashMap map = Maps.newHashMap();
                map.put("imgPath", CollectionUtils.isNotEmpty((Collection)itemDetailRespDto.getItemMediasList()) ? ((ItemMediasRespDto)itemDetailRespDto.getItemMediasList().get(0)).getPath1() : null);
                map.put("shopName", shopBaseDto.getName());
                map.put("shelfType", item.getShelfType());
                tradeItem.setExtension(ObjectHelper.bean2Json((Object)map));
                HashMap<String, String> extFieldMap = new HashMap<String, String>();
                extFieldMap.put("unit", itemSkuRespDto.getUnit());
                tradeItem.setExtFields(extFieldMap);
                tradeItemReqDtoList.add(tradeItem);
            }
        }
        return tradeItemReqDtoList;
    }

    private String getItemCode(ItemDetailRespDto itemDetailRespDto) {
        return itemDetailRespDto.getItem() != null && StringUtils.isNotBlank((String)itemDetailRespDto.getItem().getCode()) ? itemDetailRespDto.getItem().getCode() : "";
    }

    private Integer checkDeliveryType(CustomerRespDto customerRespDto, SellerRespDto sellerRespDto) {
        return !OrderDeliveryTypeEnum.FACTORY.getType().equals(customerRespDto.getDeliverMethod()) && !Integer.valueOf(1).equals(sellerRespDto.getIsFactoryDelivery()) ? OrderDeliveryTypeEnum.SELLER.getType() : OrderDeliveryTypeEnum.FACTORY.getType();
    }

    private OrderAddressReqDto convertOrderAddress(AddressRespDto addressRespDto) {
        OrderAddressReqDto address = new OrderAddressReqDto();
        BeanUtil.copyProperties((Object)addressRespDto, (Object)address, (String[])new String[0]);
        address.setAddress(addressRespDto.getDetailAddr());
        address.setProvinceCode(addressRespDto.getProvinceCode() == null ? "" : addressRespDto.getProvinceCode());
        address.setProvinceName(addressRespDto.getProvince() == null ? "" : addressRespDto.getProvince());
        address.setCityCode(addressRespDto.getCityCode() == null ? "" : addressRespDto.getCityCode());
        address.setCityName(addressRespDto.getCity() == null ? "" : addressRespDto.getCity());
        address.setAreaCode(addressRespDto.getDistrictCode() == null ? "" : addressRespDto.getDistrictCode());
        address.setAreaName(addressRespDto.getDistrict() == null ? "" : addressRespDto.getDistrict());
        address.setDeliveryName(addressRespDto.getContact());
        address.setDeliveryMobile(addressRespDto.getPhone());
        address.setShippingType("express");
        address.setDeliveryType(Integer.valueOf(1));
        address.setCountryCode("");
        address.setDetailed("");
        address.setInstanceId(Long.valueOf(1254039287584232622L));
        address.setTenantId(Long.valueOf(1L));
        address.setPostcode("");
        address.setRemark("");
        address.setStreetCode("");
        address.setStreetName("");
        return address;
    }
}

