/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.huieryun.core.util.HttpUtils;
import com.dtyunxi.tcbj.app.open.biz.config.PsiConfig;
import com.dtyunxi.tcbj.app.open.biz.service.MarketingCloudService;
import com.dtyunxi.tcbj.app.open.biz.service.impl.ExternalClientAbstract;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASQueryBaseReqDto;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PSITokenResponse;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PsiResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExternalPsiService
extends ExternalClientAbstract<PsiConfig> {
    private static final Logger logger = LoggerFactory.getLogger(ExternalPsiService.class);
    private static final String SUCCESS = "0";
    private static final String PSI_TOKEN_KEY_CACHE = "PSI_TOKEN_KEY_CACHE";
    @Resource
    private PsiConfig psiConfig;
    @Resource
    private MarketingCloudService marketingCloudService;

    public <T> List<T> queryBaseExecute(EASQueryBaseReqDto reqDto, Class<T> clazz) {
        logger.info("\u8bf7\u6c42\u67e5\u8be2\u5668\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        HashMap<String, String> headerData = new HashMap<String, String>();
        headerData.put("tableName", reqDto.getTableName());
        reqDto.setTableName(null);
        String url = this.psiConfig.getQueryBaseServiceAddress() + this.psiConfig.getQueryBaseApi() + "?access_token=" + this.getToken(this.psiConfig.getQueryBaseServiceAddress(), this.psiConfig.getQueryBaseAppid(), this.psiConfig.getQueryBaseAppSecret());
        HashMap<String, EASQueryBaseReqDto> formData = new HashMap<String, EASQueryBaseReqDto>();
        formData.put("jsonStr", reqDto);
        String result = this.executeForm(url, JSONObject.parseObject((String)JSON.toJSONString(formData)), headerData);
        PsiResponse psiResponse = (PsiResponse)JSON.parseObject((String)result, PsiResponse.class);
        if (ObjectUtil.isNotEmpty((Object)psiResponse) && StringUtils.isNotBlank((CharSequence)psiResponse.getErrorCode()) && psiResponse.getErrorCode().equals("98")) {
            logger.info("TOKEN\u5931\u6548\uff0c\u91cd\u65b0\u8bf7\u6c42");
            url = this.psiConfig.getQueryBaseServiceAddress() + this.psiConfig.getQueryBaseApi() + "?access_token=" + this.getToken(this.psiConfig.getQueryBaseServiceAddress(), this.psiConfig.getQueryBaseAppid(), this.psiConfig.getQueryBaseAppSecret());
            result = this.executeForm(url, JSONObject.parseObject((String)JSON.toJSONString(formData)), headerData);
            psiResponse = (PsiResponse)JSON.parseObject((String)result, PsiResponse.class);
        }
        return this.checkDate(result, psiResponse, clazz);
    }

    public <T> List<T> executeFormPost(String baseUrl, Map<String, Object> formParams, Map<String, String> headerData, Class<T> clazz) {
        String url = baseUrl + "?access_token=" + this.getToken(this.psiConfig.getQueryBaseServiceAddress(), this.psiConfig.getQueryBaseAppid(), this.psiConfig.getQueryBaseAppSecret());
        String result = this.executeForm(url, JSONObject.parseObject((String)JSON.toJSONString(formParams)), headerData);
        PsiResponse psiResponse = (PsiResponse)JSON.parseObject((String)result, PsiResponse.class);
        if (ObjectUtil.isNotEmpty((Object)psiResponse) && StringUtils.isNotBlank((CharSequence)psiResponse.getErrorCode()) && psiResponse.getErrorCode().equals("98")) {
            logger.info("TOKEN\u5931\u6548\uff0c\u91cd\u65b0\u8bf7\u6c42");
            url = baseUrl + "?access_token=" + this.getToken(this.psiConfig.getQueryBaseServiceAddress(), this.psiConfig.getQueryBaseAppid(), this.psiConfig.getQueryBaseAppSecret());
            result = this.executeForm(url, JSONObject.parseObject((String)JSON.toJSONString(formParams)), headerData);
            psiResponse = (PsiResponse)JSON.parseObject((String)result, PsiResponse.class);
        }
        return this.checkDate(result, psiResponse, clazz);
    }

    public <T> List<T> queryGet(String url, Map<String, String> params, Class<T> clazz) {
        params.put("access_token", this.getToken(this.psiConfig.getQueryBaseServiceAddress(), this.psiConfig.getQueryBaseAppid(), this.psiConfig.getQueryBaseAppSecret()));
        String result = this.executeGet(url, params);
        PsiResponse psiResponse = (PsiResponse)JSON.parseObject((String)result, PsiResponse.class);
        if (ObjectUtil.isNotEmpty((Object)psiResponse) && StringUtils.isNotBlank((CharSequence)psiResponse.getErrorCode()) && psiResponse.getErrorCode().equals("98")) {
            logger.info("TOKEN\u5931\u6548\uff0c\u91cd\u65b0\u8bf7\u6c42");
            params.put("access_token", this.getToken(this.psiConfig.getQueryBaseServiceAddress(), this.psiConfig.getQueryBaseAppid(), this.psiConfig.getQueryBaseAppSecret()));
            result = this.executeGet(url, params);
            psiResponse = (PsiResponse)JSON.parseObject((String)result, PsiResponse.class);
        }
        return this.checkDate(result, psiResponse, clazz);
    }

    private String executeGet(String url, Map<String, String> params) {
        String paramsStr = HttpUtil.toParams(params);
        url = url + "?" + paramsStr;
        HttpRequest get = HttpUtil.createGet((String)url);
        logger.info("\u8fdb\u9500\u5b58\u670d\u52a1GET\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString(params));
        logger.info("\u8bf7\u6c42\u94fe\u63a5\uff1a{}", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", params);
        Instant start = Instant.now();
        HttpResponse httpResponse = get.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        logger.info("\u8fdb\u9500\u5b58\u670d\u52a1GET\u8bf7\u6c42\uff0c\u8bf7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        logger.info("\u8fdb\u9500\u5b58\u670d\u52a1GET\u8bf7\u6c42\uff0c\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        return body;
    }

    private String executeForm(String url, JSONObject formData, Map<String, String> headerData) {
        if (ObjectUtil.isNotEmpty(headerData)) {
            url = url + "&" + HttpUtil.toParams(headerData);
        }
        logger.info("\u8fdb\u9500\u5b58\u670d\u52a1Form\u8868\u5355\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)formData));
        logger.info("\u8bf7\u6c42\u94fe\u63a5\uff1a{}", (Object)url);
        HttpRequest post = (HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/x-www-form-urlencoded");
        post.form((Map)formData);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)url);
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)formData);
        Instant start = Instant.now();
        HttpResponse httpResponse = post.execute();
        String body = httpResponse.body();
        Instant end = Instant.now();
        logger.info("\u8fdb\u9500\u5b58\u670d\u52a1Form\u8868\u5355\u63d0\u4ea4\uff0c\u8bf7\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)formData));
        logger.info("\u8fdb\u9500\u5b58\u670d\u52a1Form\u8868\u5355\u63d0\u4ea4\uff0c\u8017\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)Duration.between(start, end).toMillis(), (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)httpResponse.isGzip());
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)body);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)httpResponse.getStatus());
        return body;
    }

    @Override
    public String buildUrl(String url) {
        String urls = super.buildUrl(url);
        if (this.psiConfig.getRequestVerify().booleanValue()) {
            urls = urls + "?access_token=" + this.getToken(null, null, null);
        }
        return urls;
    }

    private String getToken(String serviceAddress, String appId, String appSecret) {
        logger.info("PSI\u83b7\u53d6token\uff1a{}", (Object)serviceAddress);
        String url = StringUtils.isBlank((CharSequence)serviceAddress) ? this.psiConfig.buildRequestUrl(this.psiConfig.getAccessTokenApi() + "?appId=" + this.psiConfig.getAppid() + "&appSecret=" + this.psiConfig.getAppSecret()) : serviceAddress + this.psiConfig.getAccessTokenApi() + "?appId=" + appId + "&appSecret=" + appSecret;
        String tokenCache = this.getTokenCache(PSI_TOKEN_KEY_CACHE);
        if (StringUtils.isNotBlank((CharSequence)tokenCache)) {
            return tokenCache;
        }
        String result = HttpUtils.get((String)url);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u83b7\u53d6token\uff1a{}, {}", (Object)url, (Object)JSONObject.toJSONString((Object)result));
        if (ObjectUtils.isNotEmpty((Object)result)) {
            PsiResponse rest = (PsiResponse)JSONObject.parseObject((String)result, PsiResponse.class);
            Assert.isTrue((boolean)rest.getErrorCode().equals("00"), (String)rest.getErrorCode(), (String)rest.getErrorMessage());
            PSITokenResponse dto = (PSITokenResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rest.getReturnObject()), PSITokenResponse.class);
            this.setTokenCache(PSI_TOKEN_KEY_CACHE, dto.getAccess_token(), 1800);
            return dto.getAccess_token();
        }
        throw new BizException("\u83b7\u53d6token\u5931\u8d25");
    }

    @Override
    void check(String result) {
        PsiResponse psiResponse = (PsiResponse)JSON.parseObject((String)result, PsiResponse.class);
        if (ObjectUtil.isEmpty((Object)psiResponse) || StringUtils.isBlank((CharSequence)psiResponse.getErrorCode())) {
            throw new BizException("\u54cd\u5e94\u5931\u8d25\u5f02\u5e38\uff1a" + result);
        }
        if (!psiResponse.getErrorCode().equals(SUCCESS)) {
            throw new BizException("\u54cd\u5e94\u5931\u8d25\uff1a" + JSON.toJSONString((Object)psiResponse));
        }
    }

    private <T> List<T> checkDate(String resultStr, PsiResponse psiResponse, Class<T> clazz) {
        if (ObjectUtil.isEmpty((Object)psiResponse) || StringUtils.isBlank((CharSequence)psiResponse.getErrorCode())) {
            throw new BizException("\u8bf7\u6c42\u67e5\u8be2\u5668\u5f02\u5e38\uff1a" + resultStr);
        }
        if (!psiResponse.getErrorCode().equals("00")) {
            throw new BizException("\u8bf7\u6c42\u67e5\u8be2\u5668\u5f02\u5e38\uff1a" + JSON.toJSONString((Object)psiResponse));
        }
        if (ObjectUtil.isNotEmpty((Object)psiResponse.getReturnObject())) {
            return JSONArray.parseArray((String)JSON.toJSONString((Object)psiResponse.getReturnObject()), clazz);
        }
        return new ArrayList();
    }
}

