/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricEncoder {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";
    public static final String HmacMD5 = "HmacMD5";
    public static final String HmacSHA1 = "HmacSHA1";
    public static final String DES = "DES";
    public static final String AES = "AES";
    public String charset = "utf-8";
    public int keysizeDES = 0;
    public int keysizeAES = 128;
    public static SymmetricEncoder me;

    private SymmetricEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SymmetricEncoder getInstance() {
        if (me != null) return me;
        Class<SymmetricEncoder> clazz = SymmetricEncoder.class;
        synchronized (SymmetricEncoder.class) {
            if (me != null) return me;
            me = new SymmetricEncoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    private String messageDigest(String res, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] resBytes = this.charset == null ? res.getBytes() : res.getBytes(this.charset);
            return this.base64(md.digest(resBytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String keyGeneratorMac(String res, String algorithm, String key) {
        try {
            SecretKey sk = null;
            if (key == null) {
                KeyGenerator kg = KeyGenerator.getInstance(algorithm);
                sk = kg.generateKey();
            } else {
                byte[] keyBytes = this.charset == null ? key.getBytes() : key.getBytes(this.charset);
                sk = new SecretKeySpec(keyBytes, algorithm);
            }
            Mac mac = Mac.getInstance(algorithm);
            mac.init(sk);
            byte[] result = mac.doFinal(res.getBytes());
            return this.base64(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String keyGeneratorES(String res, String algorithm, String key, int keysize, boolean isEncode) {
        try {
            byte[] keyBytes;
            KeyGenerator kg = KeyGenerator.getInstance(algorithm);
            if (keysize == 0) {
                keyBytes = this.charset == null ? key.getBytes() : key.getBytes(this.charset);
                kg.init(new SecureRandom(keyBytes));
            } else if (key == null) {
                kg.init(keysize);
            } else {
                keyBytes = this.charset == null ? key.getBytes() : key.getBytes(this.charset);
                kg.init(keysize, new SecureRandom(keyBytes));
            }
            SecretKey sk = kg.generateKey();
            SecretKeySpec sks = new SecretKeySpec(sk.getEncoded(), algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (isEncode) {
                cipher.init(1, sks);
                byte[] resBytes = this.charset == null ? res.getBytes() : res.getBytes(this.charset);
                return SymmetricEncoder.parseByte2HexStr(cipher.doFinal(resBytes));
            }
            cipher.init(2, sks);
            return new String(cipher.doFinal(SymmetricEncoder.parseHexStr2Byte(res)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String base64(byte[] res) throws UnsupportedEncodingException {
        return new String(Base64.getEncoder().encode(res), this.charset);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (byte b : buf) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public String MD5(String res) {
        return this.messageDigest(res, MD5);
    }

    public String MD5(String res, String key) {
        return this.keyGeneratorMac(res, HmacMD5, key);
    }

    public String SHA1(String res) {
        return this.messageDigest(res, SHA1);
    }

    public String SHA1(String res, String key) {
        return this.keyGeneratorMac(res, HmacSHA1, key);
    }

    public String DESencode(String res, String key) {
        return this.keyGeneratorES(res, DES, key, this.keysizeDES, true);
    }

    public String DESdecode(String res, String key) {
        return this.keyGeneratorES(res, DES, key, this.keysizeDES, false);
    }

    public String AESencode(String res, String key) {
        return this.keyGeneratorES(res, AES, key, this.keysizeAES, true);
    }

    public String AESdecode(String res, String key) {
        return this.keyGeneratorES(res, AES, key, this.keysizeAES, false);
    }

    public static String XORencode(String res, String key) {
        byte[] bs = res.getBytes();
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(bs[i] ^ key.hashCode());
        }
        return SymmetricEncoder.parseByte2HexStr(bs);
    }

    public static String XORdecode(String res, String key) {
        byte[] bs = SymmetricEncoder.parseHexStr2Byte(res);
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(bs[i] ^ key.hashCode());
        }
        return new String(bs);
    }

    public static int XOR(int res, String key) {
        return res ^ key.hashCode();
    }
}

