/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.services;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.center.openapi.common.qimen.constant.QimenOrderTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.DeliveryorderConfirmRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.DeliveryorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.EntryorderConfirmRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.EntryorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.InventoryQueryRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.OrderCancelRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.ReturnorderConfirmRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.ReturnorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.SingleitemSynchronizeRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.StockoutConfirmRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.StockoutCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.StoreprocessConfirmRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.StoreprocessCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.SupplierSynchronizeRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.DeliveryorderCreateResponseDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.EntryorderCreateResponseDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.InventoryQueryResponseDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.OrderCancelResponseDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.ReturnorderCreateResponseDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.StockoutCreateResponseDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.WmsDailyDeliveryReportRespDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.TransportConfirmInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.TransportOrderInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsInSendBackDetailReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsInSendBackReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOutSendBackDetailReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOutSendBackReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsShippingInfoReqDto;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.client.CommonQimenClient;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.services.IProcessorWms;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.external.wms.ICsWmsApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qimen.api.QimenRequest;
import com.qimen.api.QimenResponse;
import com.qimen.api.request.DeliveryorderConfirmRequest;
import com.qimen.api.request.EntryorderQueryRequest;
import com.qimen.api.request.StockoutConfirmRequest;
import com.qimen.api.request.StockoutQueryRequest;
import com.qimen.api.response.EntryorderQueryResponse;
import com.qimen.api.response.SingleitemSynchronizeResponse;
import com.qimen.api.response.StockoutQueryResponse;
import com.qimen.api.response.StoreprocessCreateResponse;
import com.qimen.api.response.SupplierSynchronizeResponse;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProcessorWms
implements IProcessorWms {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProcessorWms.class);
    @Resource
    private CommonQimenClient qimenClient;
    private static final String CANCELED = "CANCELED";
    private static final String CLOSED = "CLOSED";
    @Autowired
    private ICsWmsApi wmsApi;

    @Override
    public WmsOutSendBackReqDto stockoutConfirm(StockoutConfirmRequestDto stockoutConfirmRequestDto) {
        WmsOutSendBackReqDto reqDto = new WmsOutSendBackReqDto();
        reqDto.setOutNoticeOrderNo(stockoutConfirmRequestDto.getDeliveryOrder().getDeliveryOrderCode());
        reqDto.setWmsOrderNo(stockoutConfirmRequestDto.getDeliveryOrder().getOutBizCode());
        Map extendProps = stockoutConfirmRequestDto.getExtendProps();
        reqDto.setRemark((String)Optional.ofNullable(extendProps).map(r -> r.get("remark")).orElse(""));
        if (CANCELED.equals(stockoutConfirmRequestDto.getDeliveryOrder().getStatus()) || CLOSED.equals(stockoutConfirmRequestDto.getDeliveryOrder().getStatus())) {
            reqDto.setClose(true);
            return reqDto;
        }
        reqDto.setExtensionExternal(Optional.ofNullable(extendProps).map(r -> r.get("orderLineDetails")).orElse("").toString());
        reqDto.setAppendLogistics(Objects.equals(Optional.ofNullable(extendProps).map(r -> r.get("appendLogistics")).orElse(""), "1"));
        reqDto.setUpdateCarrierFlag(Objects.equals(Optional.ofNullable(extendProps).map(r -> r.get("updateCarrier")).orElse(""), "1"));
        reqDto.setMergeQuantity(new BigDecimal(Optional.ofNullable(extendProps).orElse(Maps.newHashMap()).getOrDefault("mergeQuantity", "0")));
        reqDto.setTotalCartons(new BigDecimal(Optional.ofNullable(extendProps).orElse(Maps.newHashMap()).getOrDefault("totalCartons", "0")));
        reqDto.setCarNum(Optional.ofNullable(extendProps).map(r -> r.get("carNum")).orElse("").toString());
        reqDto.setDriverName(Optional.ofNullable(extendProps).map(r -> r.get("driverName")).orElse("").toString());
        reqDto.setDriverPhone(Optional.ofNullable(extendProps).map(r -> r.get("driverPhone")).orElse("").toString());
        reqDto.setMergeOrderNo(Optional.ofNullable(extendProps).map(r -> r.get("mergeOrderNo")).orElse("").toString());
        Map securityCodesMap = Optional.ofNullable(extendProps).orElse(Maps.newHashMap()).getOrDefault("securityCodesMap", new HashMap());
        reqDto.setOutTime((Date)DateUtil.parse((CharSequence)stockoutConfirmRequestDto.getDeliveryOrder().getOrderConfirmTime()));
        AtomicReference<Boolean> hasBatch = new AtomicReference<Boolean>(false);
        AtomicReference<Boolean> hasQuantity = new AtomicReference<Boolean>(false);
        reqDto.setDetailReqDtoList(Optional.ofNullable(stockoutConfirmRequestDto.getOrderLines()).orElse(Lists.newArrayList()).stream().flatMap(orderLine -> {
            if (CollectionUtil.isEmpty((Collection)orderLine.getBatchs())) {
                return Lists.newArrayList((Object[])new WmsOutSendBackDetailReqDto[]{this.buildWmsOutSendBackDetailReqDto(stockoutConfirmRequestDto.getDeliveryOrder().getWarehouseCode(), securityCodesMap, (StockoutConfirmRequest.OrderLine)orderLine, Optional.ofNullable(orderLine.getBatchCode()).filter(StringUtils::isNotBlank).orElse(orderLine.getProduceCode()))}).stream();
            }
            hasBatch.set(true);
            return orderLine.getBatchs().stream().map(batch -> {
                WmsOutSendBackDetailReqDto detailReqDto = this.buildWmsOutSendBackDetailReqDto(stockoutConfirmRequestDto.getDeliveryOrder().getWarehouseCode(), securityCodesMap, (StockoutConfirmRequest.OrderLine)orderLine, Optional.ofNullable(batch.getBatchCode()).filter(StringUtils::isNotBlank).orElse(batch.getProduceCode()));
                detailReqDto.setQuantity(new BigDecimal(batch.getActualQty()));
                if (Integer.valueOf(batch.getActualQty()) > 0) {
                    hasQuantity.set(true);
                }
                detailReqDto.setExpireTime(this.parseTime(batch.getExpireDate()));
                detailReqDto.setProduceTime(this.parseTime(batch.getProductDate()));
                return detailReqDto;
            });
        }).collect(Collectors.toList()));
        if (hasBatch.get().booleanValue()) {
            AssertUtil.isTrue((boolean)hasQuantity.get(), (String)"\u8ba2\u5355\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a0");
        }
        WmsShippingInfoReqDto req = new WmsShippingInfoReqDto();
        req.setWmsOrderNo(stockoutConfirmRequestDto.getDeliveryOrder().getOutBizCode());
        Optional.ofNullable(stockoutConfirmRequestDto.getPackages()).filter(CollUtil::isNotEmpty).map(p -> (StockoutConfirmRequest.Package)p.get(0)).ifPresent(p -> {
            req.setShippingCompanyName(p.getLogisticsName());
            req.setShippingCompanyCode(p.getLogisticsCode());
            req.setShippingNo(Optional.ofNullable(req.getConsignNo()).filter(StringUtils::isNotBlank).orElse(stockoutConfirmRequestDto.getDeliveryOrder().getExpressCode()));
            req.setConsignNo(Optional.ofNullable(p.getExpressCode()).orElse(stockoutConfirmRequestDto.getDeliveryOrder().getExpressCode()));
            reqDto.setVolume(BigDecimalUtils.divide((BigDecimal)BigDecimalUtils.parse((String)p.getVolume()), (BigDecimal)BigDecimalUtils.parse((String)"1000"), (int)6));
            reqDto.setWeight(BigDecimalUtils.parse((String)p.getWeight()));
        });
        req.setShippingCompanyCode(Optional.ofNullable(req.getShippingCompanyCode()).filter(StringUtils::isNotBlank).orElse(stockoutConfirmRequestDto.getDeliveryOrder().getLogisticsCode()));
        req.setShippingCompanyName(Optional.ofNullable(req.getShippingCompanyName()).filter(StringUtils::isNotBlank).orElse(stockoutConfirmRequestDto.getDeliveryOrder().getLogisticsName()));
        req.setLogisticsType((String)Optional.ofNullable(extendProps).map(r -> r.get("logisticsType")).orElse(""));
        req.setConsignNo(Optional.ofNullable(req.getConsignNo()).filter(StringUtils::isNotBlank).orElse(stockoutConfirmRequestDto.getDeliveryOrder().getExpressCode()));
        req.setShippingNo(Optional.ofNullable(req.getConsignNo()).filter(StringUtils::isNotBlank).orElse(stockoutConfirmRequestDto.getDeliveryOrder().getExpressCode()));
        req.setDeliveryTime((Date)DateUtil.parse((CharSequence)stockoutConfirmRequestDto.getDeliveryOrder().getOrderConfirmTime()));
        if (null == req.getDeliveryTime()) {
            req.setDeliveryTime(new Date());
        }
        reqDto.setOutTime(req.getDeliveryTime());
        reqDto.setShippingInfoReqDtoList((List)Lists.newArrayList((Object[])new WmsShippingInfoReqDto[]{req}));
        return reqDto;
    }

    private WmsOutSendBackDetailReqDto buildWmsOutSendBackDetailReqDto(String warehouseCode, Map<String, String> securityCodesMap, StockoutConfirmRequest.OrderLine orderLine, String batchCode) {
        WmsOutSendBackDetailReqDto wmsOutSendBackDetailReqDto = new WmsOutSendBackDetailReqDto();
        wmsOutSendBackDetailReqDto.setBatch(batchCode);
        wmsOutSendBackDetailReqDto.setQuantity(new BigDecimal(Optional.ofNullable(orderLine.getActualQty()).orElse("0")));
        wmsOutSendBackDetailReqDto.setWarehouseCode(warehouseCode);
        wmsOutSendBackDetailReqDto.setSkuCode(orderLine.getItemCode());
        try {
            wmsOutSendBackDetailReqDto.setTradeOrderItemId(Long.valueOf(orderLine.getOrderLineNo()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        wmsOutSendBackDetailReqDto.setStringCode(Optional.ofNullable(orderLine.getSnList()).map(StockoutConfirmRequest.SnList::getSn).map(strings -> String.join((CharSequence)",", strings)).orElse(""));
        wmsOutSendBackDetailReqDto.setSecurityCode(securityCodesMap.get(orderLine.getOrderLineNo()));
        wmsOutSendBackDetailReqDto.setExpireTime(this.parseTime(orderLine.getExpireDate()));
        wmsOutSendBackDetailReqDto.setProduceTime(this.parseTime(orderLine.getProductDate()));
        return wmsOutSendBackDetailReqDto;
    }

    @Override
    public WmsInSendBackReqDto entryorderConfirm(EntryorderConfirmRequestDto entryorderConfirmRequestDto) {
        logger.info("\u5165\u5e93\u5355\u786e\u8ba4\u6570\u636e\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)entryorderConfirmRequestDto));
        WmsInSendBackReqDto wms = new WmsInSendBackReqDto();
        wms.setWmsOrderNo(entryorderConfirmRequestDto.getEntryOrder().getOutBizCode());
        wms.setInNoticeOrderNo(entryorderConfirmRequestDto.getEntryOrder().getEntryOrderCode());
        wms.setRemark((String)Optional.ofNullable(entryorderConfirmRequestDto.getExtendProps()).map(r -> r.get("remark")).orElse(""));
        if (CANCELED.equals(entryorderConfirmRequestDto.getEntryOrder().getStatus()) || CLOSED.equals(entryorderConfirmRequestDto.getEntryOrder().getStatus())) {
            wms.setClose(true);
            return wms;
        }
        Optional.ofNullable(entryorderConfirmRequestDto.getEntryOrder().getOperateTime()).ifPresent(date -> wms.setInTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)date, (String)"yyyy-MM-dd HH:mm:ss")));
        wms.setDetailReqDtoList(Optional.ofNullable(entryorderConfirmRequestDto.getOrderLines()).orElse(Lists.newArrayList()).stream().map(orderLine -> {
            WmsInSendBackDetailReqDto detailReqDto = new WmsInSendBackDetailReqDto();
            detailReqDto.setBatch(Optional.ofNullable(orderLine.getBatchCode()).orElse(orderLine.getProduceCode()));
            detailReqDto.setQuantity(new BigDecimal(Optional.ofNullable(orderLine.getActualQty()).orElse("0")));
            detailReqDto.setWarehouseCode(entryorderConfirmRequestDto.getEntryOrder().getWarehouseCode());
            detailReqDto.setSkuCode(orderLine.getItemCode());
            try {
                detailReqDto.setTradeOrderItemId(Long.valueOf(orderLine.getOrderLineNo()));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            Optional.ofNullable(orderLine.getProductDate()).ifPresent(dete -> detailReqDto.setProduceTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)dete, (String)"yyyy-MM-dd")));
            Optional.ofNullable(orderLine.getExpireDate()).ifPresent(dete -> detailReqDto.setExpireTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)dete, (String)"yyyy-MM-dd")));
            return detailReqDto;
        }).collect(Collectors.toList()));
        return wms;
    }

    @Override
    public EntryorderQueryResponse entryorderQuery(EntryorderQueryRequest entryorderQueryRequest) {
        try {
            return (EntryorderQueryResponse)this.qimenClient.invoke((QimenRequest)entryorderQueryRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public StockoutQueryResponse stockoutQuery(StockoutQueryRequest stockoutQueryRequest) {
        try {
            return (StockoutQueryResponse)this.qimenClient.invoke((QimenRequest)stockoutQueryRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public InventoryQueryResponseDto inventoryQuery(InventoryQueryRequestDto inventoryQueryRequest) {
        try {
            return (InventoryQueryResponseDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.qimenClient.invoke((QimenRequest)inventoryQueryRequest)), InventoryQueryResponseDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public OrderCancelResponseDto cancel(OrderCancelRequestDto orderCancelRequestDto) {
        Assert.notEmpty((String)orderCancelRequestDto.getOrderCode(), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            QimenResponse invoke = this.qimenClient.invoke((QimenRequest)orderCancelRequestDto);
            return (OrderCancelResponseDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)invoke), OrderCancelResponseDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public EntryorderCreateResponseDto entryorderCreate(EntryorderCreateRequestDto entryorderCreateRequestDto) {
        try {
            QimenResponse invoke = this.qimenClient.invoke((QimenRequest)entryorderCreateRequestDto);
            return (EntryorderCreateResponseDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)invoke), EntryorderCreateResponseDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public StockoutCreateResponseDto stockoutCreate(StockoutCreateRequestDto stockoutCreateRequestDto) {
        try {
            return (StockoutCreateResponseDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.qimenClient.invoke((QimenRequest)stockoutCreateRequestDto)), StockoutCreateResponseDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public DeliveryorderCreateResponseDto deliveryOrderCreate(DeliveryorderCreateRequestDto deliveryorderCreateRequestDto) {
        try {
            return (DeliveryorderCreateResponseDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.qimenClient.invoke((QimenRequest)deliveryorderCreateRequestDto)), DeliveryorderCreateResponseDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public WmsOutSendBackReqDto deliveryOrderConfirm(DeliveryorderConfirmRequestDto deliveryorderConfirmRequestDto) {
        WmsOutSendBackReqDto reqDto = new WmsOutSendBackReqDto();
        reqDto.setOutNoticeOrderNo(deliveryorderConfirmRequestDto.getDeliveryOrder().getDeliveryOrderCode());
        reqDto.setWmsOrderNo(deliveryorderConfirmRequestDto.getDeliveryOrder().getOutBizCode());
        reqDto.setRemark((String)Optional.ofNullable(deliveryorderConfirmRequestDto.getExtendProps()).map(r -> r.get("remark")).orElse(""));
        if (CANCELED.equals(deliveryorderConfirmRequestDto.getDeliveryOrder().getStatus()) || CLOSED.equals(deliveryorderConfirmRequestDto.getDeliveryOrder().getStatus())) {
            reqDto.setClose(true);
            return reqDto;
        }
        reqDto.setAppendLogistics(Objects.equals(Optional.ofNullable(deliveryorderConfirmRequestDto.getExtendProps()).map(r -> r.get("appendLogistics")).orElse(""), "1"));
        Optional.ofNullable(deliveryorderConfirmRequestDto.getDeliveryOrder().getRelatedOrders()).filter(CollUtil::isNotEmpty).ifPresent(od -> reqDto.setPlatformOrderNo(((DeliveryorderConfirmRequest.RelatedOrder)od.get(0)).getOrderCode()));
        reqDto.setMergeQuantity(new BigDecimal(Optional.ofNullable(deliveryorderConfirmRequestDto.getExtendProps()).orElse(Maps.newHashMap()).getOrDefault("mergeQuantity", "0")));
        reqDto.setTotalCartons(new BigDecimal(Optional.ofNullable(deliveryorderConfirmRequestDto.getExtendProps()).orElse(Maps.newHashMap()).getOrDefault("totalCartons", "0")));
        Map securityCodesMap = Optional.ofNullable(deliveryorderConfirmRequestDto.getExtendProps()).orElse(Maps.newHashMap()).getOrDefault("securityCodesMap", new HashMap());
        reqDto.setDetailReqDtoList(Optional.ofNullable(deliveryorderConfirmRequestDto.getOrderLines()).orElse(Lists.newArrayList()).stream().flatMap(orderLine -> {
            StockoutConfirmRequest.OrderLine line = (StockoutConfirmRequest.OrderLine)BeanUtil.copyProperties((Object)orderLine, StockoutConfirmRequest.OrderLine.class, (String[])new String[0]);
            if (CollectionUtil.isEmpty((Collection)orderLine.getBatchs())) {
                return Lists.newArrayList((Object[])new WmsOutSendBackDetailReqDto[]{this.buildWmsOutSendBackDetailReqDto(deliveryorderConfirmRequestDto.getDeliveryOrder().getWarehouseCode(), securityCodesMap, line, Optional.ofNullable(orderLine.getBatchCode()).filter(StringUtils::isNotBlank).orElse(orderLine.getProduceCode()))}).stream();
            }
            return orderLine.getBatchs().stream().map(batch -> {
                WmsOutSendBackDetailReqDto detailReqDto = this.buildWmsOutSendBackDetailReqDto(deliveryorderConfirmRequestDto.getDeliveryOrder().getWarehouseCode(), securityCodesMap, line, Optional.ofNullable(batch.getBatchCode()).filter(StringUtils::isNotBlank).orElse(batch.getProduceCode()));
                detailReqDto.setQuantity(new BigDecimal(batch.getActualQty()));
                detailReqDto.setExpireTime(this.parseTime(batch.getExpireDate()));
                detailReqDto.setProduceTime(this.parseTime(batch.getProduceCode()));
                return detailReqDto;
            });
        }).collect(Collectors.toList()));
        WmsShippingInfoReqDto req = new WmsShippingInfoReqDto();
        req.setWmsOrderNo(deliveryorderConfirmRequestDto.getDeliveryOrder().getOutBizCode());
        Optional.ofNullable(deliveryorderConfirmRequestDto.getPackages()).filter(CollUtil::isNotEmpty).map(p -> (DeliveryorderConfirmRequest.Package)p.get(0)).ifPresent(p -> {
            req.setShippingCompanyName(p.getLogisticsName());
            req.setShippingCompanyCode(p.getLogisticsCode());
            req.setShippingNo(Optional.ofNullable(p.getExpressCode()).orElse(deliveryorderConfirmRequestDto.getDeliveryOrder().getExpressCode()));
            req.setConsignNo(Optional.ofNullable(p.getExpressCode()).orElse(deliveryorderConfirmRequestDto.getDeliveryOrder().getExpressCode()));
        });
        req.setShippingCompanyCode(Optional.ofNullable(req.getShippingCompanyCode()).filter(StringUtils::isNotBlank).orElse(deliveryorderConfirmRequestDto.getDeliveryOrder().getLogisticsCode()));
        req.setShippingCompanyName(Optional.ofNullable(req.getShippingCompanyName()).filter(StringUtils::isNotBlank).orElse(deliveryorderConfirmRequestDto.getDeliveryOrder().getLogisticsName()));
        req.setLogisticsType((String)Optional.ofNullable(deliveryorderConfirmRequestDto.getExtendProps()).map(r -> r.get("logisticsType")).orElse(""));
        req.setConsignNo(Optional.ofNullable(req.getConsignNo()).filter(StringUtils::isNotBlank).orElse(deliveryorderConfirmRequestDto.getDeliveryOrder().getExpressCode()));
        req.setShippingNo(Optional.ofNullable(req.getConsignNo()).filter(StringUtils::isNotBlank).orElse(deliveryorderConfirmRequestDto.getDeliveryOrder().getExpressCode()));
        req.setDeliveryTime((Date)DateUtil.parse((CharSequence)deliveryorderConfirmRequestDto.getDeliveryOrder().getOrderConfirmTime()));
        if (null == req.getDeliveryTime()) {
            req.setDeliveryTime(new Date());
        }
        reqDto.setShippingInfoReqDtoList((List)Lists.newArrayList((Object[])new WmsShippingInfoReqDto[]{req}));
        return reqDto;
    }

    private Date parseTime(String de) {
        return Optional.ofNullable(de).map(date -> com.dtyunxi.cube.utils.DateUtil.parseDate((String)date, (String)"yyyy-MM-dd")).orElse(null);
    }

    @Override
    public ReturnorderCreateResponseDto returnOrderCreate(ReturnorderCreateRequestDto returnorderCreateRequestDto) {
        try {
            Optional.ofNullable(returnorderCreateRequestDto.getExtendPropsDto()).ifPresent(prop -> returnorderCreateRequestDto.setExtendProps((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)returnorderCreateRequestDto.getExtendPropsDto()))));
            Optional.ofNullable(returnorderCreateRequestDto.getOrderLineExtendPropsMap()).ifPresent(map -> returnorderCreateRequestDto.getOrderLines().forEach(o -> Optional.ofNullable(map.get(o.getOrderLineNo())).ifPresent(ex -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)ex)))));
            return (ReturnorderCreateResponseDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.qimenClient.invoke((QimenRequest)returnorderCreateRequestDto)), ReturnorderCreateResponseDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public WmsInSendBackReqDto returnOrderConfirm(ReturnorderConfirmRequestDto returnorderConfirmRequestDto) {
        logger.info("\u9000\u8d27\u5165\u5e93\u5355\u786e\u8ba4\uff1a{}", (Object)JSON.toJSONString((Object)returnorderConfirmRequestDto));
        WmsInSendBackReqDto wms = new WmsInSendBackReqDto();
        ReturnorderConfirmRequestDto.ReturnOrder returnOrder = returnorderConfirmRequestDto.getReturnOrder();
        if (QimenOrderTypeEnum.DAILY_DELIVERY_REPORT.getDesc().equals(returnOrder.getOrderType())) {
            logger.info("\u6bcf\u65e5\u53d1\u8d27\u62a5\u8868\u67e5\u8be2\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)returnorderConfirmRequestDto));
            List dailyDeliveryReportDtoList = returnorderConfirmRequestDto.getOrderLines().stream().filter(e -> !e.getExtendProps().isEmpty()).map(e -> {
                String extendProps = JSON.toJSONString((Object)e.getExtendProps());
                WmsDailyDeliveryReportRespDto dailyDeliveryReportRespDto = (WmsDailyDeliveryReportRespDto)JSON.parseObject((String)extendProps, WmsDailyDeliveryReportRespDto.class);
                if (StringUtils.isNotBlank((CharSequence)dailyDeliveryReportRespDto.getItemDetails())) {
                    try {
                        String byteToText = new String(Base64.getDecoder().decode(dailyDeliveryReportRespDto.getItemDetails()), "UTF-8");
                        logger.info("byteToText = {}" + byteToText);
                        List detail = JSON.parseArray((String)byteToText, WmsDailyDeliveryReportRespDto.WmsDailyDeliveryReportDetailRespDto.class);
                        dailyDeliveryReportRespDto.setWmsDailyDeliveryReportDetailRespDtos(detail);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
                return dailyDeliveryReportRespDto;
            }).collect(Collectors.toList());
            wms.setWmsDailyDeliveryReportRespDtoList(dailyDeliveryReportDtoList);
            wms.setOrderType(returnOrder.getOrderType());
            return wms;
        }
        if (QimenOrderTypeEnum.TRANSPORT_ORDER_INFO.getCode().equals(returnOrder.getOrderType())) {
            wms.setTransferConsignmentFlag(Boolean.valueOf(true));
            if (null != returnorderConfirmRequestDto.getExtendProps()) {
                TransportOrderInfoReqDto transportOrderInfoReqDto = (TransportOrderInfoReqDto)JSON.parseObject((String)JSONObject.toJSONString((Object)returnorderConfirmRequestDto.getExtendProps()), TransportOrderInfoReqDto.class);
                wms.setTransportOrderInfoReqDto(transportOrderInfoReqDto);
            }
        }
        if (QimenOrderTypeEnum.TRANSPORT_CONFIRM_INFO.getCode().equals(returnOrder.getOrderType())) {
            wms.setTransferConsignmentConfirmFlag(Boolean.valueOf(true));
            if (null != returnorderConfirmRequestDto.getExtendProps()) {
                TransportConfirmInfoReqDto transportConfirmInfoReqDto = (TransportConfirmInfoReqDto)JSON.parseObject((String)JSONObject.toJSONString((Object)returnorderConfirmRequestDto.getExtendProps()), TransportConfirmInfoReqDto.class);
                wms.setTransportConfirmInfoReqDto(transportConfirmInfoReqDto);
            }
        }
        wms.setWmsOrderNo(returnOrder.getOutBizCode());
        wms.setInNoticeOrderNo(returnOrder.getReturnOrderCode());
        wms.setPlatformOrderNo(returnOrder.getRefOrderCode());
        Optional.ofNullable(returnOrder.getOrderConfirmTime()).ifPresent(date -> wms.setInTime(com.dtyunxi.cube.utils.DateUtil.parseDate((String)date, (String)"yyyy-MM-dd HH:mm:ss")));
        wms.setDetailReqDtoList(Optional.ofNullable(returnorderConfirmRequestDto.getOrderLines()).orElse(Lists.newArrayList()).stream().map(orderLine -> {
            WmsInSendBackDetailReqDto detailReqDto = new WmsInSendBackDetailReqDto();
            detailReqDto.setBatch(orderLine.getBatchCode());
            detailReqDto.setQuantity(new BigDecimal(Optional.ofNullable(orderLine.getActualQty()).orElse("0")));
            detailReqDto.setWarehouseCode(returnOrder.getWarehouseCode());
            detailReqDto.setSkuCode(orderLine.getItemCode());
            try {
                detailReqDto.setTradeOrderItemId(Long.valueOf(orderLine.getOrderLineNo()));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            detailReqDto.setProduceTime(this.parseTime(orderLine.getProductDate()));
            return detailReqDto;
        }).collect(Collectors.toList()));
        return wms;
    }

    @Override
    public SingleitemSynchronizeResponse singleItemSynchronize(SingleitemSynchronizeRequestDto singleitemSynchronizeRequestDto) {
        try {
            Optional.ofNullable(singleitemSynchronizeRequestDto.getExtendPropsDto()).ifPresent(ex -> {
                singleitemSynchronizeRequestDto.setExtendPropsDto(null);
                singleitemSynchronizeRequestDto.setExtendProps((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)ex)));
            });
            return (SingleitemSynchronizeResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.qimenClient.invoke((QimenRequest)singleitemSynchronizeRequestDto)), SingleitemSynchronizeResponse.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public SupplierSynchronizeResponse supplierSynchronize(SupplierSynchronizeRequestDto supplierSynchronizeRequestDto) {
        try {
            Optional.ofNullable(supplierSynchronizeRequestDto.getExtendPropsDto()).ifPresent(ex -> {
                supplierSynchronizeRequestDto.setExtendPropsDto(null);
                supplierSynchronizeRequestDto.setRemark(JSONObject.toJSONString((Object)ex));
            });
            logger.info("\u5ba2\u6237\u8d44\u6599\u540c\u6b65\u5947\u95e8\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)supplierSynchronizeRequestDto));
            return (SupplierSynchronizeResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.qimenClient.invoke((QimenRequest)supplierSynchronizeRequestDto)), SupplierSynchronizeResponse.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public StoreprocessCreateResponse ocsToWms(StoreprocessCreateRequestDto storeprocessCreateRequestDto) {
        try {
            return (StoreprocessCreateResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.qimenClient.invoke((QimenRequest)storeprocessCreateRequestDto)), StoreprocessCreateResponse.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public StoreprocessConfirmRequestDto wmsToOcs(StoreprocessConfirmRequestDto storeprocessConfirmRequestDto) {
        if (Objects.isNull(storeprocessConfirmRequestDto.getExtendProps())) {
            throw new BizException("\u5fc5\u4f20\u53c2\u6570\u6269\u5c55\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)storeprocessConfirmRequestDto.getReturnOrder().getOrderType())) {
            Map extendPropsMap = storeprocessConfirmRequestDto.getExtendProps();
            if (!extendPropsMap.containsKey("orderType") || StringUtils.isBlank((CharSequence)extendPropsMap.get("orderType").toString())) {
                throw new BizException("\u5fc5\u4f20\u53c2\u6570orderType\u4e3a\u7a7a");
            }
            storeprocessConfirmRequestDto.getReturnOrder().setOrderType(extendPropsMap.get("orderType").toString());
        }
        return storeprocessConfirmRequestDto;
    }
}

