/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.services.channel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.center.openapi.common.wms.enums.ExternalWmsServiceEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOrderMergeReqDto;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.common.QimenPropertiesConfig;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.services.AbstractProcessorWms;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class WzProcessorWmsImpl
extends AbstractProcessorWms {
    private final Logger logger = LoggerFactory.getLogger(WzProcessorWmsImpl.class);
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private QimenPropertiesConfig qimenPropertiesConfig;

    @Override
    public String getChannelCode() {
        return ExternalWmsServiceEnum.WmsMappingEnum.WZ.getChannelCode();
    }

    @Override
    public JSONObject orderMerge(WmsOrderMergeReqDto reqDto) {
        this.logger.info("\u8bf7\u6c42\u63a8\u9001WMS\u5408\u5e76\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        QimenPropertiesConfig.Properties byCustomer = this.qimenPropertiesConfig.findByCustomer(reqDto.getCustomerId());
        String url = byCustomer.getExtServerUrl() + "/tcbjwms/api/ehub/business/pcp-CombinOrder?kmhMasterOrderCode=%s&kmhOrderSplitNum=%s";
        String format = String.format(url, reqDto.getOrderCode(), reqDto.getMergeOrderNum());
        ResponseEntity forEntity = this.restTemplate.getForEntity(format, String.class, new Object[0]);
        this.logger.info("\u8bf7\u6c42\u63a8\u9001WMS\u5408\u5e76\u54cd\u5e94entity\uff1a{}", (Object)JSON.toJSONString((Object)forEntity));
        JSONObject jsonObject = JSON.parseObject((String)StrUtil.unWrap((CharSequence)StringEscapeUtils.unescapeJava((String)((String)forEntity.getBody())), (String)"\"", (String)"\""));
        if (ObjectUtils.isEmpty((Object)jsonObject) || ObjectUtils.isEmpty((Object)jsonObject.get((Object)"status")) || !jsonObject.get((Object)"status").equals("success")) {
            throw new BizException("-1", jsonObject.toString());
        }
        return jsonObject;
    }
}

