/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.impl.notify;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.NotifyAssitantVo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.swiftpass.AbstractSpGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.notify.SpNotifyMsg;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="spPayOrderNotifyGatewayService")
@Transactional(transactionManager="paymentCenterDataSourceTransactionManager", rollbackFor={Exception.class})
public class SpPayOrderNotifyGatewayServiceImpl
extends AbstractSpGatewayService<NotifyAssitantVo, SpNotifyMsg> {
    public BaseGatewayResult rechargeResult(NotifyAssitantVo assitantVo, SpNotifyMsg spNotifyMsg) throws Exception {
        this.logger.info("\u63a5\u6536\u4ea4\u6613\u56de\u8c03\uff1a{}=={}", (Object)JSON.toJSONString((Object)assitantVo), (Object)JSON.toJSONString((Object)((Object)spNotifyMsg)));
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)assitantVo.getTradeId());
        PayOrderAttachInfoEo attachInfoEo = new PayOrderAttachInfoEo();
        attachInfoEo.setTradeId(assitantVo.getTradeId());
        if ("0".equals(spNotifyMsg.getResultCode()) && "0".equals(spNotifyMsg.getStatus())) {
            if ("0".equals(spNotifyMsg.getPayResult())) {
                partnerOrder.setPartnerOrderId(spNotifyMsg.getTransactionId());
                attachInfoEo.setRemark1(spNotifyMsg.getOutTransactionId());
                partnerOrder.setAmount(new BigDecimal(spNotifyMsg.getTotalFee()).movePointLeft(2));
                partnerOrder.setRemark(spNotifyMsg.getTradeType());
                if (StringUtils.isNotBlank((CharSequence)spNotifyMsg.getTimeEnd())) {
                    partnerOrder.setFinishTime(DateUtil.parseDate((String)spNotifyMsg.getTimeEnd(), (String)"yyyyMMddHHmmss"));
                } else {
                    partnerOrder.setFinishTime(new Date());
                }
                this.payOrderProcessorService.handleSuccOrder((Object)partnerOrder, (Object)attachInfoEo);
            } else {
                partnerOrder.setErrorCode(spNotifyMsg.getErrCode());
                partnerOrder.setErrorMsg(spNotifyMsg.getErrMsg());
                this.payOrderProcessorService.handleFailOrder((Object)partnerOrder);
            }
        } else {
            this.logger.info("\u901a\u77e5\u6570\u636e\u4e0d\u5408\u6cd5\uff0c \u4e0d\u5904\u7406\u8ba2\u5355");
        }
        return new GatewayResult(true, assitantVo.getTradeId());
    }

    public SpNotifyMsg _execute(NotifyAssitantVo assitantVo) throws Exception {
        PayOrderEo payOrder = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)assitantVo.getTradeId());
        PartnerConfigEo config = (PartnerConfigEo)this.payPartnerConfigDas.selectByLogicKey((Object)payOrder.getPartnerConfigCode());
        return (SpNotifyMsg)((Object)this.spPartnerService.parseNotify(assitantVo.getNotify(), config));
    }

    public void validate(NotifyAssitantVo assitantVo, SpNotifyMsg spNotifyMsg) throws Exception {
    }
}

