/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass;

import com.dtyunxi.yundt.cube.center.payment.service.constants.SwiftpassConstants;
import com.dtyunxi.yundt.cube.center.payment.service.partner.AbstractPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.BaseSpRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.BaseSpResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.request.SpDownloadOrderRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpDownloadOrderResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.response.SpRefundQueryResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.IntStream;

public class AbstractSpPartnerService
extends AbstractPartnerService<BaseSpRequest, BaseSpResponse> {
    protected String doExecute(BaseSpRequest request) throws Exception {
        if (request instanceof SpDownloadOrderRequest) {
            request.setRequestUrl(SwiftpassConstants.SWIFTPASSCFG.getDownloadUrl());
        } else {
            request.setRequestUrl(SwiftpassConstants.SWIFTPASSCFG.getReqUrl());
        }
        String requestXml = request.bean2Xml();
        this.logger.info("\u5411\u5a01\u5bcc\u901a\u6e20\u9053\u53d1\u8d77\u8bf7\u6c42,\u8bf7\u6c42\u5730\u5740:{}, \u8bf7\u6c42\u53c2\u6570:{}", (Object)request.getRequestUrl(), (Object)requestXml);
        String xml = this.post(request.getRequestUrl(), requestXml);
        this.logger.info("\u6536\u5230\u6e20\u9053\u54cd\u5e94:{}", (Object)xml);
        return xml;
    }

    protected void doReqEncrypt(BaseSpRequest request) throws Exception {
        request.doEncrypt();
    }

    protected void verifyResp(BaseSpRequest request, String result, BaseSpResponse response) throws Exception {
        if (response instanceof SpDownloadOrderResponse) {
            this.logger.info("\u5bf9\u8d26\u6587\u4ef6\u8fd4\u56de");
            ((SpDownloadOrderResponse)response).setBillDate(((SpDownloadOrderRequest)request).getBillDate());
        } else {
            response.setEncryptKey(request.getEncryptKey());
            response.setDecryptKey(request.getDecryptKey());
            Map data = response.xml2Map(result);
            response.verifySign(data);
        }
    }

    protected BaseSpResponse parseResponse(String result, BaseSpResponse response) throws Exception {
        if (response instanceof SpRefundQueryResponse) {
            response = (SpRefundQueryResponse)response.xml2Bean(result);
            Map resultMap = response.xml2Map(result);
            int refundCount = ((SpRefundQueryResponse)response).getRefundCount();
            ArrayList<SpRefundQueryResponse.RefundData> refundDatas = new ArrayList<SpRefundQueryResponse.RefundData>();
            IntStream.range(0, refundCount).forEach(i -> {
                SpRefundQueryResponse.RefundData raw = new SpRefundQueryResponse.RefundData();
                raw.setOutRefundNo((String)resultMap.get("out_refund_no_" + i));
                raw.setRefundId((String)resultMap.get("refund_id_" + i));
                raw.setRefundChannel((String)resultMap.get("refund_channel_" + i));
                raw.setRefundFee((String)resultMap.get("refund_fee_" + i));
                raw.setCouponRefundFee((String)resultMap.get("coupon_refund_fee_" + i));
                raw.setRefundTime((String)resultMap.get("refund_time_" + i));
                raw.setRefundStatus((String)resultMap.get("refund_status_" + i));
                raw.setRefundStatusInfo((String)resultMap.get("refund_status_info_" + i));
                refundDatas.add(raw);
            });
            ((SpRefundQueryResponse)response).setRefundDatas(refundDatas);
        } else if (response instanceof SpDownloadOrderResponse) {
            this.logger.info("\u5bf9\u8d26\u6587\u4ef6\u8fd4\u56de\u8f6c\u5316\u7ed3\u6784");
            ((SpDownloadOrderResponse)response).setFileText(result);
        } else {
            response = (BaseSpResponse)response.xml2Bean(result);
        }
        return response;
    }
}

