/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.BaseSpPartnerDomain;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.domain.BaseSpRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.utils.SignUtil;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSpResponse
extends BaseSpPartnerDomain {
    private static Logger logger = LoggerFactory.getLogger(BaseSpRequest.class);
    public static final String REQ_SUCCESS = "0";
    public static final String BUSI_SUCCESS = "0";
    public static final String TRADE_SUCC_STATE = "SUCCESS";
    public static final String TRADE_REFUND_STATE = "REFUND";
    public static final String TRADE_NOTPAY_STATE = "NOTPAY";
    public static final String TRADE_CLOSED_STATE = "CLOSED";
    public static final String TRADE_PAYERROR_STATE = "PAYERROR";
    public static final String REFUND_SUCCESS_STATE = "SUCCESS";
    public static final String REFUND_FAIL_STATE = "FAIL";
    public static final String REFUND_PROCESSING_STATE = "PROCESSING";
    public static final String REFUND_NOTSURE_STATE = "NOTSURE";
    public static final String REFUND_CHANGE_STATE = "CHANGE";
    public static final String[] SUCC_STATE = new String[]{"SUCCESS", "REFUND"};
    public static final String[] FAIL_STATE = new String[]{"PAYERROR", "CLOSED"};
    public static final String[] PROCESS_STATE = new String[]{"NOTPAY"};
    public static final String[] REF_SUCC_STATE = new String[]{"SUCCESS"};
    public static final String[] REF_PRO_STATE = new String[]{"PROCESSING", "NOTSURE"};
    public static final String[] REF_FAIL_STATE = new String[]{"FAIL", "CHANGE"};
    private String status;
    private String message;
    private String appId;
    private String resultCode;
    private String errCode;
    private String errMsg;

    public static boolean isTradeSuccess(String tradeState) {
        return Arrays.asList(SUCC_STATE).contains(tradeState);
    }

    public static boolean isTradeFail(String tradeState) {
        return Arrays.asList(FAIL_STATE).contains(tradeState);
    }

    public static boolean isTradeProcess(String tradeState) {
        return Arrays.asList(PROCESS_STATE).contains(tradeState);
    }

    public static boolean isRefundSuccess(String tradeState) {
        return Arrays.asList(REF_SUCC_STATE).contains(tradeState);
    }

    public static boolean isRefundFail(String tradeState) {
        return Arrays.asList(REF_FAIL_STATE).contains(tradeState);
    }

    public static boolean isRefundProcess(String tradeState) {
        return Arrays.asList(REF_PRO_STATE).contains(tradeState);
    }

    public boolean verifySign(Map<String, String> response) throws Exception {
        String sign = response.get("sign");
        logger.info("\u9a8c\u7b7e\u524dmap\uff1a{}", (Object)JSON.toJSONString(response));
        logger.info("\u9a8c\u7b7e\u516c\u94a5:" + this.getDecryptKey());
        boolean signResult = SignUtil.verifySign(sign, "RSA_1_256", response, this.getDecryptKey());
        if (!signResult) {
            logger.error("\u56de\u8c03\u7b7e\u540d\u4e0d\u4e00\u81f4");
            throw new BizException("-1", "\u56de\u8c03\u7b7e\u540d\u4e0d\u4e00\u81f4");
        }
        return true;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JSONField(name="appid")
    public String getAppId() {
        return this.appId;
    }

    @JSONField(name="appid")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JSONField(name="result_code")
    public String getResultCode() {
        return this.resultCode;
    }

    @JSONField(name="result_code")
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    @JSONField(name="err_code")
    public String getErrCode() {
        return this.errCode;
    }

    @JSONField(name="err_code")
    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    @JSONField(name="err_msg")
    public String getErrMsg() {
        return this.errMsg;
    }

    @JSONField(name="err_msg")
    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}

