/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.partner.swiftpass.utils;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class RSAUtil {
    private static KeyFactory getKeyFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sign(SignatureSuite suite, byte[] msgBuf, String privateKeyStr) {
        Signature signature = null;
        try {
            signature = Signature.getInstance(suite.val());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyStr));
            PrivateKey privateKey = RSAUtil.getKeyFactory().generatePrivate(keySpec);
            signature.initSign(privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            signature.update(msgBuf);
            return signature.sign();
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySign(SignatureSuite suite, byte[] msgBuf, byte[] sign, String publicKeyStr) {
        Signature signature = null;
        try {
            signature = Signature.getInstance(suite.val());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyStr));
            PublicKey publicKey = RSAUtil.getKeyFactory().generatePublic(keySpec);
            signature.initVerify(publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            signature.update(msgBuf);
            return signature.verify(sign);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum SignatureSuite {
        SHA1("SHA1WithRSA"),
        SHA256("SHA256WithRSA");

        private String suite;

        private SignatureSuite(String suite) {
            this.suite = suite;
        }

        public String val() {
            return this.suite;
        }
    }
}

