/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StoreSearchReqDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSearchRespDto;
import com.dtyunxi.tcbj.api.query.IStoreSearchQueryApi;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.tcbj.module.export.biz.utils.MyEasyPoiExportUtil;
import com.dtyunxi.tcbj.module.export.biz.utils.ThreadPoolUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.StoreExportVo;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.StoreSellerGovernExportExtVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreSellerGovernContentQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreSellerGovernQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="customerExportService")
public class CustomerExportService {
    @Resource
    private IContext context;
    @Resource
    private ExportService exportService;
    @Resource
    private IStoreSearchQueryApi storeSearchQueryApi;
    @Resource
    private IStoreSellerGovernQueryApi storeSellerGovernQueryApi;
    @Resource
    private IStoreSellerGovernContentQueryApi storeSellerGovernContentQueryApi;
    private static final Logger logger = LoggerFactory.getLogger(CustomerExportService.class);

    public RestResponse<Object> exportSellerGovern(StoreSellerGovernQueryReqDto reqDto) {
        String name = "\u7ba1\u8f96\u836f\u5e97\u5206\u914d";
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.SELLER_GOVERN);
        baseExportService.executor(req -> {
            List list = (List)RestResponseHelper.extractData((RestResponse)this.storeSellerGovernQueryApi.queryExcel(req));
            logger.info(name + "\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)JSON.toJsonString((Object)list));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList rList = Lists.newArrayList();
                for (StoreSellerGovernRespDto govern : list) {
                    if (StringUtils.isNotBlank((CharSequence)govern.getAreaCode())) {
                        List<String> areaCodes = Arrays.asList(govern.getAreaCode().split(";"));
                        List<String> areaNames = Arrays.asList(govern.getAreaName().split(";"));
                        areaCodes.forEach(c -> {
                            StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                            vo.setType(GovernTypeEnum.AREA.getCode());
                            vo.setCode((String)c);
                            vo.setName((String)areaNames.get(areaCodes.indexOf(c)));
                            rList.add(vo);
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)govern.getStoreName())) {
                        List<String> storeNames = Arrays.asList(govern.getStoreName().split(";"));
                        List<String> storeSocialCredits = Arrays.asList(govern.getStoreSocialCredit().split(";"));
                        storeNames.forEach(c -> {
                            StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                            vo.setType(GovernTypeEnum.STORE.getCode());
                            vo.setName((String)c);
                            vo.setCode((String)storeSocialCredits.get(storeNames.indexOf(c)));
                            rList.add(vo);
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)govern.getBlackList())) {
                        List<String> blackList = Arrays.asList(govern.getBlackList().split(";"));
                        List<String> blackListSocialCredit = Arrays.asList(govern.getBlackListSocialCredit().split(";"));
                        blackList.forEach(c -> {
                            StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                            CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                            vo.setType(GovernTypeEnum.BLACKLIST.getCode());
                            vo.setName((String)c);
                            vo.setCode((String)blackListSocialCredit.get(blackList.indexOf(c)));
                            rList.add(vo);
                        });
                    }
                    if (!StringUtils.isNotBlank((CharSequence)govern.getStoreParentList())) continue;
                    List<String> storeParentList = Arrays.asList(govern.getStoreParentList().split(";"));
                    List<String> storeParentListSocialCredit = Arrays.asList(govern.getStoreParentListSocialCredit().split(";"));
                    storeParentList.forEach(c -> {
                        StoreSellerGovernExportExtVo vo = new StoreSellerGovernExportExtVo();
                        CubeBeanUtils.copyProperties((Object)vo, (Object)govern, (String[])new String[0]);
                        vo.setType(GovernTypeEnum.STOREPARENT.getCode());
                        vo.setName((String)c);
                        vo.setCode((String)storeParentListSocialCredit.get(storeParentList.indexOf(c)));
                        rList.add(vo);
                    });
                }
                baseExportService.exportUrl(rList, StoreSellerGovernExportExtVo.class);
            } else {
                this.exportService.fail(baseExportService.getId(), "\u5bfc\u51fa" + name + "\u5217\u8868,\u6570\u636e\u4e3a\u7a7a");
            }
            return null;
        }, reqDto);
        return new RestResponse("0", "\u5bfc\u51fa" + name + "\u6210\u529f");
    }

    public RestResponse<Object> exportStoreListSearch(StoreSearchReqDto storeSearchReqDto) {
        String fileName = "\u836f\u5e97\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        Long id = this.exportService.init(fileName, ExportTypeEnum.STORE);
        Long uesrId = this.context.userId();
        String organization = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        ThreadPoolUtil.executorService.submit(() -> {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            ServiceContext.getContext().set("yes.req.requestId", (Object)uuid);
            this.context.userId(uesrId);
            logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\uff1a{},UUID:{}", (Object)fileName, (Object)uuid);
            try {
                if (Objects.nonNull(organization)) {
                    storeSearchReqDto.setOrgId(Long.valueOf(organization.toString()));
                }
                Long total = null;
                double num = 0.0;
                Integer pageNum = 1;
                Integer pageSize = 5000;
                ArrayList rList = Lists.newArrayList();
                while (total == null || (double)pageNum.intValue() <= num) {
                    storeSearchReqDto.setPageNum(pageNum.intValue());
                    storeSearchReqDto.setPageSize(pageSize.intValue());
                    logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u836f\u5e97\u53c2\u6570:{},UUID:{}", (Object)JSONObject.toJSONString((Object)storeSearchReqDto), (Object)uuid);
                    PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.storeSearchQueryApi.queryStoreListSearch(storeSearchReqDto));
                    if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u67e5\u8be2\u836f\u5e97\u7ed3\u679c:{},UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                    }
                    if (total == null) {
                        total = pageInfo.getTotal();
                        num = Math.ceil(Double.valueOf(total.longValue()) / (double)pageSize.intValue());
                        logger.info("\u6267\u884c\u5f02\u6b65\u4efb\u52a1\u521d\u59cb\u5316UUID:{},\u67e5\u8be2\u836f\u5e97\u603b\u6570:{},\u4e00\u5171\u9700\u8981\u5206\u6279:{}\u6b21", new Object[]{uuid, total, num});
                    }
                    pageNum = pageNum + 1;
                    if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
                    logger.info("\u836f\u5e97\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{},UUID:{}", (Object)pageInfo.getList().size(), (Object)uuid);
                    for (int i = 0; i < pageInfo.getList().size(); ++i) {
                        StoreSearchRespDto store = (StoreSearchRespDto)pageInfo.getList().get(i);
                        StoreExportVo storeExportVo = new StoreExportVo();
                        CubeBeanUtils.copyProperties((Object)storeExportVo, (Object)store, (String[])new String[]{"ifSupply", "ifCustomer", "ifParentCustomer"});
                        storeExportVo.setIfSupply(store.getIfSupply() == 1 ? "\u662f" : "\u5426");
                        storeExportVo.setIfCustomer(store.getIfCustomer() == 1 ? "\u662f" : "\u5426");
                        storeExportVo.setIfParentCustomer(store.getIfParentCustomer() == 1 ? "\u662f" : "\u5426");
                        rList.add(storeExportVo);
                    }
                    pageInfo.getList().clear();
                    System.gc();
                }
                logger.info("\u836f\u5e97\u5217\u8868\u67e5\u8be2\u6570\u636e\u8f6c\u6362\u7ed3\u679c\u5927\u5c0f:{},UUID:{}", (Object)rList.size(), (Object)uuid);
                if (CollectionUtils.isNotEmpty((Collection)rList)) {
                    String excelName = "cube/" + fileName;
                    try {
                        logger.info("\u6267\u884c\u836f\u5e97\u67e5\u8be2\u7ed3\u679c\u5bfc\u51fa\u5927\u5c0f\u4e3a:{},UUID:{}", (Object)rList.size(), (Object)uuid);
                        String exportUrl = MyEasyPoiExportUtil.getExportUrl(rList, StoreExportVo.class, null, excelName, "xlsx");
                        this.exportService.success(id, exportUrl);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef:{}", (Object)e.toString());
                        this.exportService.fail(id, "\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef1:" + e);
                        return;
                    }
                }
                this.exportService.fail(id, "\u5bfc\u51fa\u989d\u5ea6\u8d26\u6237,\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef2:{}", (Object)e.toString());
                this.exportService.fail(id, "\u5bfc\u51fa\u836f\u5e97\u5217\u8868-\u9519\u8bef2:" + e);
                return;
            }
        });
        return new RestResponse("0", "\u5bfc\u51fa\u836f\u5e97\u5217\u8868\u6210\u529f");
    }
}

