/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.abs.ReportExportAbstract;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CreditAccountExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.operation.CurrentCommonService;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.CreditAccountExportVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditEntityQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CreditAccountExportService
extends ReportExportAbstract<CreditEntityPageRespDto, CreditAccountExportReqDto, CreditAccountExportVo> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICreditEntityQueryApi creditEntityQueryApi;
    @Resource
    private IContext context;
    @Resource
    private CurrentCommonService currentCommonService;

    @Override
    public ExportTypeEnum getExportType() {
        return ExportTypeEnum.CREDIT_ACCOUNT;
    }

    @Override
    public PageInfo<CreditEntityPageRespDto> queryData(CreditAccountExportReqDto creditAccountExportReqDto) {
        CreditEntitySearchReqDto creditEntitySearchReqDto = new CreditEntitySearchReqDto();
        creditEntitySearchReqDto.setInstanceId(creditAccountExportReqDto.getInstanceId());
        creditEntitySearchReqDto.setTenantId(creditAccountExportReqDto.getTenantId());
        creditEntitySearchReqDto.setKeyword(creditAccountExportReqDto.getKeyword());
        creditEntitySearchReqDto.setHaveAccount(creditAccountExportReqDto.getHaveAccount());
        creditEntitySearchReqDto.setCreateTimeStart(creditAccountExportReqDto.getCreateTimeStart());
        creditEntitySearchReqDto.setCreateTimeEnd(creditAccountExportReqDto.getCreateTimeEnd());
        creditEntitySearchReqDto.setOrgInfoId(creditAccountExportReqDto.getOrganizationId());
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.creditEntityQueryApi.pageCreditEntity(creditEntitySearchReqDto, Integer.valueOf(creditAccountExportReqDto.getPageNum()), Integer.valueOf(creditAccountExportReqDto.getPageSize())));
    }

    @Override
    public CreditAccountExportReqDto definePrams(CreditAccountExportReqDto creditAccountExportReqDto) {
        creditAccountExportReqDto.setInstanceId(this.context.instanceId());
        creditAccountExportReqDto.setTenantId(this.context.tenantId());
        List<Long> currentOrgId = this.currentCommonService.getCurrentOrgId();
        this.logger.info("[\u5ba2\u6237\u4fe1\u7528\u6863\u6848\u5bfc\u51fa]\uff0c\u7ec4\u7ec7id\uff1a{}", currentOrgId);
        if (CollectionUtils.isNotEmpty(currentOrgId)) {
            creditAccountExportReqDto.setOrganizationId(currentOrgId.get(0));
        }
        return creditAccountExportReqDto;
    }

    @Override
    public Gson buildGson() {
        return new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    }
}

