/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.settlement.biz.service.IOfflineBalanceBillService;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceBillApi;
import com.yx.tcbj.center.rebate.api.dto.request.BatchAuditBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillImportReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillQueryReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.AuditBalanceBillRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceBillImportResultDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceBillRespDto;
import com.yx.tcbj.center.rebate.api.query.IOfflineBalanceBillQueryApi;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfflineBalanceBillServiceImpl
implements IOfflineBalanceBillService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOfflineBalanceBillApi offlineBalanceBillApi;
    @Autowired
    private IOfflineBalanceBillQueryApi offlineBalanceBillQueryApi;
    @Resource
    private HttpServletRequest request;

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public RestResponse<OfflineBalanceBillRespDto> queryById(Long id) {
        return this.offlineBalanceBillQueryApi.queryById(id);
    }

    @Override
    public RestResponse<PageInfo<OfflineBalanceBillRespDto>> queryByPage(OfflineBalanceBillQueryReqDto queryReqDto) {
        if (Objects.isNull(queryReqDto.getMerchantId())) {
            String orgIdStr = this.headerOrgId();
            this.logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
            if (StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
                queryReqDto.setMerchantId(Long.valueOf(orgIdStr));
            }
        }
        return this.offlineBalanceBillQueryApi.queryByPage(queryReqDto);
    }

    @Override
    public RestResponse<Long> addOfflineBalanceBill(OfflineBalanceBillReqDto addReqDto) {
        return this.offlineBalanceBillApi.addOfflineBalanceBill(addReqDto);
    }

    @Override
    public RestResponse<Void> modifyOfflineBalanceBill(OfflineBalanceBillReqDto modifyReqDto) {
        return this.offlineBalanceBillApi.modifyOfflineBalanceBill(modifyReqDto);
    }

    @Override
    public RestResponse<Void> removeOfflineBalanceBill(String ids, Long instanceId) {
        return this.offlineBalanceBillApi.removeOfflineBalanceBill(ids, instanceId);
    }

    @Override
    public RestResponse<Void> auditBill(OfflineBalanceBillReqDto auditDto) {
        return this.offlineBalanceBillApi.auditBill(auditDto);
    }

    @Override
    public RestResponse<List<AuditBalanceBillRespDto>> auditBillBatch(BatchAuditBalanceBillReqDto auditDto) {
        return this.offlineBalanceBillApi.auditBillBatch(auditDto);
    }

    @Override
    public RestResponse<Void> closeBillByPayNo(String receiptRecordsNo) {
        return this.offlineBalanceBillApi.closeBillByPayNo(receiptRecordsNo);
    }

    @Override
    public RestResponse<String> exportOfflineBalanceBill(OfflineBalanceBillQueryReqDto queryReqDto) {
        if (Objects.isNull(queryReqDto.getMerchantId())) {
            String orgIdStr = this.headerOrgId();
            this.logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
            if (StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
                queryReqDto.setMerchantId(Long.valueOf(orgIdStr));
            }
        }
        return this.offlineBalanceBillApi.exportOfflineBalanceBill(queryReqDto);
    }

    @Override
    public RestResponse<OfflineBalanceBillImportResultDto> billImport(OfflineBalanceBillImportReqDto importReqDto) {
        return this.offlineBalanceBillApi.billImport(importReqDto);
    }
}

