/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.calculator.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceFindOptTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderExecutor;
import com.dtyunxi.cube.center.source.biz.service.calculator.SourceOrderExecutorStep;
import com.dtyunxi.cube.center.source.biz.utils.SourceExecuteUtils;
import com.dtyunxi.cube.center.source.biz.vo.SourceExecuteContextVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceOrderExecuteResultVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SourceOrderExecutorImpl
implements SourceOrderExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SourceOrderExecutorImpl.class);
    @Resource
    private SourceOrderExecutorStep sourceOrderExecutorStep;

    @Override
    public SourceOrderExecuteResultVo executeSourcing(OrderDetailRespDto orderDetailRespDto) {
        logger.info("\u3010\u5f00\u59cb\u6267\u884c\u5bfb\u6e90\u3011\u8bf7\u6c42orderDetailRespDto={}", (Object)JSON.toJSONString((Object)orderDetailRespDto));
        this.checkSourceParams(orderDetailRespDto);
        SourceExecuteContextVo sourceExecuteContextVo = this.sourceOrderExecutorStep.buildContextStep(orderDetailRespDto);
        this.sourceOrderExecutorStep.matchSourceClueListStep(sourceExecuteContextVo);
        SourceOrderResultRespDto sourceOrderResultRespDto = this.sourceOrderExecutorStep.calculationSourceResultStep(sourceExecuteContextVo);
        SourceOrderExecuteResultVo sourceOrderExecuteResultVo = this.sourceOrderExecutorStep.matchNotSplitOrderWhiteListStep(sourceExecuteContextVo, sourceOrderResultRespDto);
        try {
            this.sourceOrderExecutorStep.saveSourceZtNumStep(sourceExecuteContextVo, sourceOrderResultRespDto);
        }
        catch (Exception e) {
            logger.info("\u8bb0\u5f55\u5728\u9014\u4f7f\u7528\u4fe1\u606f\u62a5\u9519:{}", (Throwable)e);
        }
        SourceExecuteUtils.saveOrderResourceLog(SourceFindOptTypeEnum.SOURCE_END, sourceExecuteContextVo, SourceStatusEnum.forCode((String)sourceOrderExecuteResultVo.getSourceOrderResultRespDto().getSgStatus()).getDesc());
        Collections.reverse(Optional.ofNullable(sourceOrderExecuteResultVo.getSourceExecuteContextVo().getSourceLogDetailRespDtoList()).orElse(new ArrayList()));
        this.checkOrderItemResultRespListCount(sourceOrderExecuteResultVo);
        return sourceOrderExecuteResultVo;
    }

    private void checkOrderItemResultRespListCount(SourceOrderExecuteResultVo sourceOrderExecuteResultVo) {
        List orderItemRespDtoList = sourceOrderExecuteResultVo.getSourceExecuteContextVo().getOrderDetailRespDto().getOrderItemRespDtoList();
        List orderItemResultRespDtoList = sourceOrderExecuteResultVo.getSourceOrderResultRespDto().getOrderItemResultRespDtoList();
        if (CollectionUtils.isEmpty((Collection)orderItemResultRespDtoList)) {
            return;
        }
        int beforeItemCount = orderItemRespDtoList.stream().mapToInt(dto -> dto.getItemNum().intValue()).sum();
        int afterItemCount = orderItemResultRespDtoList.stream().filter(dto -> dto.getDeliveryItemNum() != null).mapToInt(dto -> dto.getDeliveryItemNum().intValue()).sum();
        if (afterItemCount > beforeItemCount) {
            SourceExecuteUtils.completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum.ORDER_SPILT_CHECK, sourceOrderExecuteResultVo.getSourceExecuteContextVo(), sourceOrderExecuteResultVo.getSourceOrderResultRespDto(), "\u5bfb\u6e90\u5546\u54c1\u6570\u5339\u914d\u5f02\u5e38");
            throw SourceExceptionCode.NORMAL_EXCEPTION.buildBizException(new String[]{"\u5bfb\u6e90\u5546\u54c1\u6570\u5339\u914d\u5f02\u5e38"});
        }
    }

    private void checkSourceParams(OrderDetailRespDto orderDetailRespDto) {
        SourceAssert.notNull((Object)orderDetailRespDto.getOrderItemRespDtoList(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5546\u54c1\u660e\u7ec6"});
        orderDetailRespDto.getOrderItemRespDtoList().forEach(dto -> {
            SourceAssert.notBlank((String)dto.getItemSkuCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5546\u54c1sku"});
            SourceAssert.notNull((Object)dto.getItemNum(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5546\u54c1\u6570\u91cf"});
        });
        SourceAssert.notBlank((String)orderDetailRespDto.getLinkOrderNo(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5355\u636e\u53f7"});
        SourceAssert.notBlank((String)orderDetailRespDto.getLinkOrderType(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5355\u636e\u7c7b\u578b"});
        SourceAssert.notBlank((String)orderDetailRespDto.getLinkOrderChannelWarehouseCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u6e20\u9053\u4ed3code"});
        SourceAssert.notNull((Object)orderDetailRespDto.getLinkOrderChannelWarehouseId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u6e20\u9053\u4ed3id"});
        SourceAssert.notBlank((String)orderDetailRespDto.getLinkOrderChannelCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u8ba2\u5355\u6e20\u9053code"});
        SourceAssert.notNull((Object)orderDetailRespDto.getLinkOrderChannelId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u8ba2\u5355\u6e20\u9053id"});
        SourceAssert.notNull((Object)orderDetailRespDto.getLinkOrderCustomerId(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5173\u8054\u5ba2\u6237id"});
        SourceAssert.notBlank((String)orderDetailRespDto.getOrderAddrRespDto().getCityCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u6536\u8d27\u5730\u5740-\u5e02\u7f16\u7801"});
        SourceAssert.notBlank((String)orderDetailRespDto.getOrderAddrRespDto().getProvinceCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u6536\u8d27\u5730\u5740-\u7701\u7f16\u7801"});
    }
}

