/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitSelectTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.ClueSuitTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.EnableEnum;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueReqDto;
import com.dtyunxi.cube.center.source.api.dto.request.DistributionClueSuitActReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueActRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.DistributionClueSuitRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IDistributionClueService;
import com.dtyunxi.cube.center.source.biz.service.IDistributionClueSuitService;
import com.dtyunxi.cube.center.source.dao.das.DistributionClueDas;
import com.dtyunxi.cube.center.source.dao.eo.DistributionClueEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributionClueServiceImpl
implements IDistributionClueService {
    private static final Logger log = LoggerFactory.getLogger(DistributionClueServiceImpl.class);
    @Resource
    private DistributionClueDas distributionClueDas;
    @Resource
    private IDistributionClueSuitService distributionClueSuitService;
    private static final Set<String> ALL_MATCH_CODE_SET = new HashSet<String>();

    @Override
    public Long addDistributionClue(DistributionClueReqDto addReqDto) {
        DistributionClueEo distributionClueEo = new DistributionClueEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)distributionClueEo);
        this.distributionClueDas.insert((BaseEo)distributionClueEo);
        return distributionClueEo.getId();
    }

    @Override
    public void modifyDistributionClue(DistributionClueReqDto modifyReqDto) {
        DistributionClueEo distributionClueEo = new DistributionClueEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)distributionClueEo);
        this.distributionClueDas.updateSelective((BaseEo)distributionClueEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDistributionClue(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            DistributionClueEo eo = (DistributionClueEo)this.distributionClueDas.selectByPrimaryKey(Long.valueOf(id));
            SourceAssert.notNull((Object)eo, (SourceExceptionCode)SourceExceptionCode.ID_FALL, (String[])new String[0]);
            if (eo.getClueEnableStatus().equals(EnableEnum.ENABLE.getCode())) {
                throw new BizException("\u542f\u7528\u72b6\u6001\u7684\u7b56\u7565\u4e0d\u80fd\u5220\u9664");
            }
            this.distributionClueDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DistributionClueRespDto queryById(Long id) {
        DistributionClueEo distributionClueEo = (DistributionClueEo)this.distributionClueDas.selectByPrimaryKey(id);
        if (distributionClueEo == null) {
            return null;
        }
        DistributionClueRespDto distributionClueRespDto = new DistributionClueRespDto();
        DtoHelper.eo2Dto((BaseEo)distributionClueEo, (BaseVo)distributionClueRespDto);
        return distributionClueRespDto;
    }

    @Override
    public PageInfo<DistributionClueRespDto> queryByPage(DistributionClueReqDto dto) {
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.distributionClueDas.filter().like(StringUtils.isNotBlank((CharSequence)dto.getClueCode()), (Object)"clue_code", (Object)dto.getClueCode())).like(StringUtils.isNotBlank((CharSequence)dto.getClueName()), (Object)"clue_name", (Object)dto.getClueName())).eq(StringUtils.isNotBlank((CharSequence)dto.getClueEnableStatus()), (Object)"clue_enable_status", (Object)dto.getClueEnableStatus())).ge(StringUtils.isNotBlank((CharSequence)dto.getUpdateTimeStart()), (Object)"update_time", (Object)(dto.getUpdateTimeStart() + " 00:00:00"))).le(StringUtils.isNotBlank((CharSequence)dto.getUpdateTimeEnd()), (Object)"update_time", (Object)(dto.getUpdateTimeEnd() + " 23:59:59"))).page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DistributionClueRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public DistributionClueActRespDto queryClueDetailById(Long id) {
        SourceAssert.notNull((Object)id, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7b56\u7565id"});
        DistributionClueActRespDto clueActRespDto = new DistributionClueActRespDto();
        DistributionClueRespDto clueRespDto = this.queryById(id);
        CubeBeanUtils.copyProperties((Object)clueActRespDto, (Object)clueRespDto, (String[])new String[0]);
        DistributionClueSuitRespDto clueSuitAttributeReqDto = new DistributionClueSuitRespDto();
        clueSuitAttributeReqDto.setSgClueId(id);
        PageInfo<DistributionClueSuitRespDto> clueSuitAttributeRespDtoPageInfo = this.distributionClueSuitService.queryByPage(JSON.toJSONString((Object)clueSuitAttributeReqDto), 1, 10000);
        Map<String, List<DistributionClueSuitRespDto>> clueSuitAttributeMap = clueSuitAttributeRespDtoPageInfo.getList().stream().collect(Collectors.groupingBy(DistributionClueSuitRespDto::getSgSuitType));
        clueActRespDto.setSuitCustomerList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_CUSTOMER.getCode()));
        clueActRespDto.setSuitOrderTypeList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode()));
        clueActRespDto.setSuitOrganizationList(clueSuitAttributeMap.get(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode()));
        return clueActRespDto;
    }

    @Override
    public DistributionClueActRespDto querySuitClueByOrder(DistributionClueSuitActReqDto reqDto) {
        log.info("\u67e5\u8be2\u547d\u4e2d\u7b56\u7565\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        Set<Long> clueIdSet = this.matchSourceClueListStep(reqDto);
        log.info("\u547d\u4e2d\u7684\u7b56\u7565\u89c4\u5219:{}", (Object)JSON.toJSONString(clueIdSet));
        if (clueIdSet.isEmpty()) {
            return null;
        }
        String now = DateUtil.getDateToString((Date)new Date());
        List clueEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.distributionClueDas.filter().in((Object)"id", clueIdSet)).eq((Object)"clue_enable_status", (Object)EnableEnum.ENABLE.getCode())).le((Object)"clue_enable_start_time", (Object)now)).ge((Object)"clue_enable_end_time", (Object)now)).orderByAsc((Object)"clue_priority_level")).orderByDesc((Object)"update_time")).list(Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)clueEoList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7b56\u7565\u89c4\u5219");
            return null;
        }
        DistributionClueEo distributionClueEo = (DistributionClueEo)clueEoList.get(0);
        DistributionClueActRespDto respDto = new DistributionClueActRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)distributionClueEo, (String[])new String[0]);
        log.info("\u67e5\u8be2\u547d\u4e2d\u7b56\u7565\u8fd4\u56de\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)respDto));
        return respDto;
    }

    public Set<Long> matchSourceClueListStep(DistributionClueSuitActReqDto reqDto) {
        HashSet<String> matchCodeList = new HashSet<String>(ALL_MATCH_CODE_SET);
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode(), reqDto.getOrderType()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_CUSTOMER.getCode(), reqDto.getCustomerId()));
        matchCodeList.add(this.buildSuitMatchCode(ClueSuitSelectTypeEnum.SELECT.getCode(), ClueSuitTypeEnum.HIT_ORGANIZATION.getCode(), reqDto.getOrganizationId()));
        List<DistributionClueSuitRespDto> matchClueIdList = this.distributionClueSuitService.queryListByMatchSuitCodeList(matchCodeList);
        if (CollectionUtils.isEmpty(matchClueIdList)) {
            return new HashSet<Long>();
        }
        Map<Long, List<DistributionClueSuitRespDto>> clueSuitMap = matchClueIdList.stream().collect(Collectors.groupingBy(DistributionClueSuitRespDto::getSgClueId));
        HashSet<Long> matchClueIdSet = new HashSet<Long>();
        clueSuitMap.forEach((k, v) -> {
            if (this.matchAllSuitCode((List<DistributionClueSuitRespDto>)v)) {
                matchClueIdSet.add((Long)k);
            }
        });
        return matchClueIdSet;
    }

    private String buildSuitMatchCode(String selectType, String suitType, Object key) {
        return selectType + "_" + suitType + "_" + key;
    }

    private boolean matchAllSuitCode(List<DistributionClueSuitRespDto> distributionClueSuitRespDtos) {
        Map<String, List<DistributionClueSuitRespDto>> clueSuitAttributeRespDtoMap = distributionClueSuitRespDtos.stream().collect(Collectors.groupingBy(DistributionClueSuitRespDto::getSgSuitType));
        List<DistributionClueSuitRespDto> hisCustomer = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_CUSTOMER.getCode());
        List<DistributionClueSuitRespDto> hisOrderType = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_ORDER_TYPE.getCode());
        List<DistributionClueSuitRespDto> hisOrganiztion = clueSuitAttributeRespDtoMap.get(ClueSuitTypeEnum.HIT_ORGANIZATION.getCode());
        return !CollectionUtils.isEmpty(hisCustomer) && !CollectionUtils.isEmpty(hisOrderType) && !CollectionUtils.isEmpty(hisOrganiztion);
    }

    static {
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_ORDER_TYPE + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_CUSTOMER + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
        ALL_MATCH_CODE_SET.add(ClueSuitSelectTypeEnum.ALL.getCode() + "_" + ClueSuitTypeEnum.HIT_ORGANIZATION + "_" + ClueSuitSelectTypeEnum.ALL.getCode());
    }
}

