/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.center.source.api.dto.request.OrderPriorityRuleReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderCustomerPriorityRuleRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderPriorityRuleDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderPriorityRuleRespDto;
import com.dtyunxi.cube.center.source.biz.service.IOrderPriorityRuleService;
import com.dtyunxi.cube.center.source.dao.das.OrderCustomerPriorityRuleDas;
import com.dtyunxi.cube.center.source.dao.das.OrderPriorityRuleDas;
import com.dtyunxi.cube.center.source.dao.eo.OrderCustomerPriorityRuleEo;
import com.dtyunxi.cube.center.source.dao.eo.OrderPriorityRuleEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderPriorityRuleServiceImpl
implements IOrderPriorityRuleService {
    @Resource
    private OrderPriorityRuleDas orderPriorityRuleDas;
    @Resource
    private OrderCustomerPriorityRuleDas orderCustomerPriorityRuleDas;

    @Override
    public Long addOrderPriorityRule(OrderPriorityRuleReqDto addReqDto) {
        OrderPriorityRuleEo orderPriorityRuleEo = new OrderPriorityRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderPriorityRuleEo);
        this.orderPriorityRuleDas.insert((BaseEo)orderPriorityRuleEo);
        return orderPriorityRuleEo.getId();
    }

    @Override
    public void modifyOrderPriorityRule(OrderPriorityRuleReqDto modifyReqDto) {
        Assert.isTrue((modifyReqDto.getId() != null ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderPriorityRuleEo orderPriorityRuleEo = new OrderPriorityRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderPriorityRuleEo);
        this.orderPriorityRuleDas.updateSelective((BaseEo)orderPriorityRuleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderPriorityRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderPriorityRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderPriorityRuleRespDto queryById(Long id) {
        OrderPriorityRuleEo orderPriorityRuleEo = (OrderPriorityRuleEo)this.orderPriorityRuleDas.selectByPrimaryKey(id);
        OrderPriorityRuleRespDto orderPriorityRuleRespDto = new OrderPriorityRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)orderPriorityRuleEo, (BaseVo)orderPriorityRuleRespDto);
        return orderPriorityRuleRespDto;
    }

    @Override
    public PageInfo<OrderPriorityRuleRespDto> queryByPage(OrderPriorityRuleReqDto dto) {
        OrderPriorityRuleEo orderPriorityRuleEo = new OrderPriorityRuleEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)orderPriorityRuleEo);
        PageInfo eoPageInfo = this.orderPriorityRuleDas.selectPage((BaseEo)orderPriorityRuleEo, dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderPriorityRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public OrderPriorityRuleDetailRespDto queryDetail() {
        OrderPriorityRuleEo queryEo = new OrderPriorityRuleEo();
        queryEo.setDr(0);
        List ruleEos = this.orderPriorityRuleDas.select((BaseEo)queryEo);
        if (CollectionUtils.isEmpty((Collection)ruleEos)) {
            return null;
        }
        OrderPriorityRuleEo orderPriorityRuleEo = (OrderPriorityRuleEo)ruleEos.get(0);
        OrderPriorityRuleDetailRespDto orderPriorityRuleRespDto = new OrderPriorityRuleDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)orderPriorityRuleEo, (BaseVo)orderPriorityRuleRespDto);
        if (Objects.equals(orderPriorityRuleRespDto.getStatus(), YesOrNoEnum.NO.getCode())) {
            return orderPriorityRuleRespDto;
        }
        OrderCustomerPriorityRuleEo customerPriorityRuleQueryEo = new OrderCustomerPriorityRuleEo();
        customerPriorityRuleQueryEo.setDr(0);
        customerPriorityRuleQueryEo.setRuleId(orderPriorityRuleRespDto.getId());
        List customerPriorityRuleEos = this.orderCustomerPriorityRuleDas.select((BaseEo)customerPriorityRuleQueryEo);
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)customerPriorityRuleEos, dtoList, OrderCustomerPriorityRuleRespDto.class);
        orderPriorityRuleRespDto.setCustomerPriorityRuleList(dtoList);
        return orderPriorityRuleRespDto;
    }
}

