/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.center.source.api.dto.request.WarehouseProvideGoodsRangeReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.WarehouseProvideGoodsRangeRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IWarehouseProvideGoodsRangeService;
import com.dtyunxi.cube.center.source.dao.das.WarehouseProvideGoodsRangeDas;
import com.dtyunxi.cube.center.source.dao.eo.WarehouseProvideGoodsRangeEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WarehouseProvideGoodsRangeServiceImpl
implements IWarehouseProvideGoodsRangeService {
    @Resource
    private WarehouseProvideGoodsRangeDas warehouseProvideGoodsRangeDas;

    @Override
    public Long addWarehouseProvideGoodsRange(WarehouseProvideGoodsRangeReqDto addReqDto) {
        this.checkParam(addReqDto);
        WarehouseProvideGoodsRangeEo eo = (WarehouseProvideGoodsRangeEo)((ExtQueryChainWrapper)this.warehouseProvideGoodsRangeDas.filter().eq((Object)"provide_load_code", (Object)addReqDto.getProvideLoadCode())).one();
        if (eo != null) {
            throw new BizException("\u8be5\u4ed3\u5e93\u4f9b\u8d27\u533a\u57df\u5df2\u5b58\u5728");
        }
        WarehouseProvideGoodsRangeEo warehouseProvideGoodsRangeEo = new WarehouseProvideGoodsRangeEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)warehouseProvideGoodsRangeEo);
        this.warehouseProvideGoodsRangeDas.insert((BaseEo)warehouseProvideGoodsRangeEo);
        return warehouseProvideGoodsRangeEo.getId();
    }

    private void checkParam(WarehouseProvideGoodsRangeReqDto addReqDto) {
        SourceAssert.notBlank((String)addReqDto.getProvideLoadCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u6536\u8d27\u5730\u533a\u4ee3\u7801"});
        SourceAssert.notBlank((String)addReqDto.getPhysicsWarehouseCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7269\u7406\u4ed3\u7f16\u7801"});
        SourceAssert.notBlank((String)addReqDto.getProvinceCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u7701\u7f16\u7801"});
        if (addReqDto.getCheckAreaCodeIsNull().booleanValue()) {
            SourceAssert.notBlank((String)addReqDto.getCityCode(), (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5e02\u7f16\u7801"});
        }
    }

    @Override
    public void modifyWarehouseProvideGoodsRange(WarehouseProvideGoodsRangeReqDto modifyReqDto) {
        WarehouseProvideGoodsRangeEo warehouseProvideGoodsRangeEo = new WarehouseProvideGoodsRangeEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)warehouseProvideGoodsRangeEo);
        this.warehouseProvideGoodsRangeDas.updateSelective((BaseEo)warehouseProvideGoodsRangeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeWarehouseProvideGoodsRange(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.warehouseProvideGoodsRangeDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public WarehouseProvideGoodsRangeRespDto queryById(Long id) {
        WarehouseProvideGoodsRangeEo warehouseProvideGoodsRangeEo = (WarehouseProvideGoodsRangeEo)this.warehouseProvideGoodsRangeDas.selectByPrimaryKey(id);
        if (warehouseProvideGoodsRangeEo == null) {
            return null;
        }
        WarehouseProvideGoodsRangeRespDto warehouseProvideGoodsRangeRespDto = new WarehouseProvideGoodsRangeRespDto();
        DtoHelper.eo2Dto((BaseEo)warehouseProvideGoodsRangeEo, (BaseVo)warehouseProvideGoodsRangeRespDto);
        return warehouseProvideGoodsRangeRespDto;
    }

    @Override
    public PageInfo<WarehouseProvideGoodsRangeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        WarehouseProvideGoodsRangeReqDto warehouseProvideGoodsRangeReqDto = (WarehouseProvideGoodsRangeReqDto)JSON.parseObject((String)filter, WarehouseProvideGoodsRangeReqDto.class);
        LambdaQueryWrapper<WarehouseProvideGoodsRangeEo> wrapper = this.queryWrapper(warehouseProvideGoodsRangeReqDto);
        IPage page = this.warehouseProvideGoodsRangeDas.getMapper().selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), wrapper);
        PageInfo eoPageInfo = new PageInfo(page.getRecords());
        eoPageInfo.setPageNum(pageNum.intValue());
        eoPageInfo.setPageSize(pageSize.intValue());
        eoPageInfo.setPages((int)page.getPages());
        eoPageInfo.setTotal(page.getTotal());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseProvideGoodsRangeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<WarehouseProvideGoodsRangeRespDto> queryWarehouseProvideGoodsRangeRespDtoListByWarehouseCode(List<String> warehouseCodes, String provinceCode, String cityCode, String areaCode) {
        ExtQueryChainWrapper children0 = (ExtQueryChainWrapper)this.warehouseProvideGoodsRangeDas.filter().in((Object)"physics_warehouse_code", warehouseCodes);
        ExtQueryChainWrapper children1 = Optional.ofNullable(provinceCode).map(code -> (ExtQueryChainWrapper)children0.eq((Object)"province_code", (Object)provinceCode)).orElse(children0);
        ExtQueryChainWrapper children2 = Optional.ofNullable(provinceCode).map(code -> (ExtQueryChainWrapper)children0.eq((Object)"city_code", (Object)cityCode)).orElse(children1);
        ExtQueryChainWrapper children3 = Optional.ofNullable(provinceCode).map(code -> (ExtQueryChainWrapper)children0.eq((Object)"area_code", (Object)areaCode)).orElse(children2);
        List resultList = children3.list(Integer.valueOf(10000));
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            ArrayList<WarehouseProvideGoodsRangeRespDto> respDtoList = new ArrayList<WarehouseProvideGoodsRangeRespDto>();
            CubeBeanUtils.copyCollection(respDtoList, (Collection)resultList, WarehouseProvideGoodsRangeRespDto.class);
            return respDtoList;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<WarehouseProvideGoodsRangeReqDto> reqList) {
        if (CollectionUtils.isEmpty(reqList)) {
            return;
        }
        List<WarehouseProvideGoodsRangeEo> eoList = reqList.stream().map(i -> {
            WarehouseProvideGoodsRangeEo eo = new WarehouseProvideGoodsRangeEo();
            DtoHelper.dto2Eo((BaseVo)i, (BaseEo)eo);
            eo.setCreatePerson(i.getOperator());
            eo.setUpdatePerson(i.getOperator());
            return eo;
        }).collect(Collectors.toList());
        List list = ((ExtQueryChainWrapper)this.warehouseProvideGoodsRangeDas.filter().in((Object)"provide_load_code", (Collection)eoList.stream().map(WarehouseProvideGoodsRangeEo::getProvideLoadCode).collect(Collectors.toList()))).list(Integer.valueOf(reqList.size()));
        ArrayList insertList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map map = list.stream().collect(Collectors.toMap(WarehouseProvideGoodsRangeEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
            eoList.forEach(i -> {
                if (map.containsKey(i.getUniqueKey())) {
                    WarehouseProvideGoodsRangeEo updateEo = (WarehouseProvideGoodsRangeEo)map.get(i.getUniqueKey());
                    updateEo.setPhysicsWarehouseCode(i.getPhysicsWarehouseCode());
                    updateList.add(updateEo);
                } else {
                    insertList.add(i);
                }
            });
        } else {
            this.warehouseProvideGoodsRangeDas.insertBatch(eoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.warehouseProvideGoodsRangeDas.insertBatch((List)insertList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            updateList.forEach(i -> this.warehouseProvideGoodsRangeDas.updateSelective((BaseEo)i));
        }
    }

    @Override
    public Integer queryByCount(String filter) {
        WarehouseProvideGoodsRangeReqDto warehouseProvideGoodsRangeReqDto = (WarehouseProvideGoodsRangeReqDto)JSON.parseObject((String)filter, WarehouseProvideGoodsRangeReqDto.class);
        LambdaQueryWrapper<WarehouseProvideGoodsRangeEo> wrapper = this.queryWrapper(warehouseProvideGoodsRangeReqDto);
        return this.warehouseProvideGoodsRangeDas.count(wrapper);
    }

    private LambdaQueryWrapper<WarehouseProvideGoodsRangeEo> queryWrapper(WarehouseProvideGoodsRangeReqDto reqDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (reqDto != null) {
            if (StringUtils.isNotEmpty((String)reqDto.getPhysicsWarehouseCode())) {
                wrapper.eq(WarehouseProvideGoodsRangeEo::getPhysicsWarehouseCode, (Object)reqDto.getPhysicsWarehouseCode());
            }
            if (StringUtils.isNotEmpty((String)reqDto.getProvinceCode())) {
                wrapper.eq(WarehouseProvideGoodsRangeEo::getProvinceCode, (Object)reqDto.getProvinceCode());
            }
            if (StringUtils.isNotEmpty((String)reqDto.getCityCode())) {
                wrapper.eq(WarehouseProvideGoodsRangeEo::getCityCode, (Object)reqDto.getCityCode());
            }
            if (StringUtils.isNotEmpty((String)reqDto.getAreaCode())) {
                wrapper.eq(WarehouseProvideGoodsRangeEo::getAreaCode, (Object)reqDto.getAreaCode());
            }
            if (StringUtils.isNotEmpty((String)reqDto.getProvideLoadCode())) {
                wrapper.like(WarehouseProvideGoodsRangeEo::getProvideLoadCode, (Object)("%" + reqDto.getProvideLoadCode() + "%"));
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getProvinceCodes())) {
                wrapper.in(WarehouseProvideGoodsRangeEo::getProvinceCode, (Collection)reqDto.getProvinceCodes());
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getAreaCodes())) {
                wrapper.in(WarehouseProvideGoodsRangeEo::getAreaCode, (Collection)reqDto.getAreaCodes());
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getCityCodes())) {
                wrapper.in(WarehouseProvideGoodsRangeEo::getCityCode, (Collection)reqDto.getCityCodes());
            }
        }
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.orderByDesc(BaseEo::getCreateTime);
        return wrapper;
    }
}

